/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.invocation.StubInfoImpl;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.verification.DefaultRegisteredInvocations;
import org.mockito.internal.verification.RegisteredInvocations;
import org.mockito.internal.verification.SingleRegisteredInvocation;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.InvocationContainer;
import org.mockito.invocation.MatchableInvocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubbing;
import org.mockito.stubbing.ValidableAnswer;

public class InvocationContainerImpl
implements InvocationContainer,
Serializable {
    private static final long serialVersionUID = -5334301962749537177L;
    private final LinkedList<StubbedInvocationMatcher> stubbed = new LinkedList();
    private final List<Answer<?>> answersForStubbing = new ArrayList();
    private final RegisteredInvocations registeredInvocations;
    private MatchableInvocation invocationForStubbing;

    public InvocationContainerImpl(MockCreationSettings mockSettings) {
        this.registeredInvocations = this.createRegisteredInvocations(mockSettings);
    }

    public void setInvocationForPotentialStubbing(MatchableInvocation invocation) {
        this.registeredInvocations.add(invocation.getInvocation());
        this.invocationForStubbing = invocation;
    }

    public void resetInvocationForPotentialStubbing(MatchableInvocation invocationMatcher) {
        this.invocationForStubbing = invocationMatcher;
    }

    public void addAnswer(Answer answer) {
        this.registeredInvocations.removeLast();
        this.addAnswer(answer, false);
    }

    public void addConsecutiveAnswer(Answer answer) {
        this.addAnswer(answer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubbedInvocationMatcher addAnswer(Answer answer, boolean isConsecutive) {
        Invocation invocation = this.invocationForStubbing.getInvocation();
        ThreadSafeMockingProgress.mockingProgress().stubbingCompleted();
        if (answer instanceof ValidableAnswer) {
            ((ValidableAnswer)((Object)answer)).validateFor(invocation);
        }
        LinkedList<StubbedInvocationMatcher> linkedList = this.stubbed;
        synchronized (linkedList) {
            if (isConsecutive) {
                this.stubbed.getFirst().addAnswer(answer);
            } else {
                this.stubbed.addFirst(new StubbedInvocationMatcher(this.invocationForStubbing, answer));
            }
            return this.stubbed.getFirst();
        }
    }

    Object answerTo(Invocation invocation) throws Throwable {
        return this.findAnswerFor(invocation).answer(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubbedInvocationMatcher findAnswerFor(Invocation invocation) {
        LinkedList<StubbedInvocationMatcher> linkedList = this.stubbed;
        synchronized (linkedList) {
            for (StubbedInvocationMatcher s : this.stubbed) {
                if (!s.matches(invocation)) continue;
                s.markStubUsed(invocation);
                invocation.markStubbed(new StubInfoImpl(s));
                return s;
            }
        }
        return null;
    }

    public void addAnswerForVoidMethod(Answer answer) {
        this.answersForStubbing.add(answer);
    }

    public void setAnswersForStubbing(List<Answer<?>> answers) {
        this.answersForStubbing.addAll(answers);
    }

    public boolean hasAnswersForStubbing() {
        return !this.answersForStubbing.isEmpty();
    }

    public boolean hasInvocationForPotentialStubbing() {
        return !this.registeredInvocations.isEmpty();
    }

    public void setMethodForStubbing(MatchableInvocation invocation) {
        this.invocationForStubbing = invocation;
        assert (this.hasAnswersForStubbing());
        for (int i = 0; i < this.answersForStubbing.size(); ++i) {
            this.addAnswer(this.answersForStubbing.get(i), i != 0);
        }
        this.answersForStubbing.clear();
    }

    public String toString() {
        return "invocationForStubbing: " + this.invocationForStubbing;
    }

    public List<Invocation> getInvocations() {
        return this.registeredInvocations.getAll();
    }

    public void clearInvocations() {
        this.registeredInvocations.clear();
    }

    public List<Stubbing> getStubbedInvocations() {
        return this.stubbed;
    }

    public Object invokedMock() {
        return this.invocationForStubbing.getInvocation().getMock();
    }

    public MatchableInvocation getInvocationForStubbing() {
        return this.invocationForStubbing;
    }

    private RegisteredInvocations createRegisteredInvocations(MockCreationSettings mockSettings) {
        return mockSettings.isStubOnly() ? new SingleRegisteredInvocation() : new DefaultRegisteredInvocations();
    }
}

