/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.i18n.GatewaySpiMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;

public class BaseKeystoreService {
    private static GatewaySpiMessages LOG = (GatewaySpiMessages)MessagesFactory.get(GatewaySpiMessages.class);
    protected MasterService masterService;
    protected String keyStoreDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(File keyStoreFile, char[] masterPassword, String storeType) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(storeType);
        if (keyStoreFile.exists()) {
            try (FileInputStream input = new FileInputStream(keyStoreFile);){
                keyStore.load(input, masterPassword);
            }
        } else {
            keyStore.load(null, masterPassword);
        }
        return keyStore;
    }

    private static FileOutputStream createKeyStoreFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(file.getAbsolutePath());
            }
            if (!file.canWrite()) {
                throw new IOException(file.getAbsolutePath());
            }
        } else {
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException(file.getAbsolutePath());
            }
        }
        FileOutputStream stream = new FileOutputStream(file);
        return stream;
    }

    protected void createKeystore(String filename, String keystoreType) throws KeystoreServiceException {
        try {
            FileOutputStream out = BaseKeystoreService.createKeyStoreFile(filename);
            KeyStore ks = KeyStore.getInstance(keystoreType);
            ks.load(null, null);
            ks.store(out, this.masterService.getMasterSecret());
            out.close();
        }
        catch (KeyStoreException e) {
            LOG.failedToCreateKeystore(filename, keystoreType, e);
            throw new KeystoreServiceException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.failedToCreateKeystore(filename, keystoreType, e);
            throw new KeystoreServiceException(e);
        }
        catch (CertificateException e) {
            LOG.failedToCreateKeystore(filename, keystoreType, e);
            throw new KeystoreServiceException(e);
        }
        catch (FileNotFoundException e) {
            LOG.failedToCreateKeystore(filename, keystoreType, e);
            throw new KeystoreServiceException(e);
        }
        catch (IOException e) {
            LOG.failedToCreateKeystore(filename, keystoreType, e);
            throw new KeystoreServiceException(e);
        }
    }

    protected boolean isKeystoreAvailable(File keyStoreFile, String storeType) throws KeyStoreException, IOException {
        if (keyStoreFile.exists()) {
            FileInputStream input = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(storeType);
                input = new FileInputStream(keyStoreFile);
                keyStore.load(input, this.masterService.getMasterSecret());
                boolean bl = true;
                return bl;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
            }
            catch (CertificateException e) {
                LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
            }
            catch (IOException e) {
                LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
                throw e;
            }
            catch (KeyStoreException e) {
                LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
                throw e;
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
                }
            }
        }
        return false;
    }

    protected KeyStore getKeystore(File keyStoreFile, String storeType) throws KeystoreServiceException {
        KeyStore credStore = null;
        try {
            credStore = BaseKeystoreService.loadKeyStore(keyStoreFile, this.masterService.getMasterSecret(), storeType);
        }
        catch (CertificateException e) {
            LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
            throw new KeystoreServiceException(e);
        }
        catch (KeyStoreException e) {
            LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
            throw new KeystoreServiceException(e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
            throw new KeystoreServiceException(e);
        }
        catch (IOException e) {
            LOG.failedToLoadKeystore(keyStoreFile.getName(), storeType, e);
            throw new KeystoreServiceException(e);
        }
        return credStore;
    }

    protected void addCredential(String alias, String value, KeyStore ks) {
        if (ks != null) {
            try {
                SecretKeySpec key = new SecretKeySpec(value.getBytes(StandardCharsets.UTF_8), "AES");
                ks.setKeyEntry(alias, key, this.masterService.getMasterSecret(), null);
            }
            catch (KeyStoreException e) {
                LOG.failedToAddCredential(e);
            }
        }
    }

    public void removeCredential(String alias, KeyStore ks) {
        if (ks != null) {
            try {
                if (ks.containsAlias(alias)) {
                    ks.deleteEntry(alias);
                }
            }
            catch (KeyStoreException e) {
                LOG.failedToRemoveCredential(e);
            }
        }
    }

    protected char[] getCredential(String alias, char[] credential, KeyStore ks) {
        if (ks != null) {
            try {
                credential = new String(ks.getKey(alias, this.masterService.getMasterSecret()).getEncoded(), StandardCharsets.UTF_8).toCharArray();
            }
            catch (UnrecoverableKeyException e) {
                LOG.failedToGetCredential(e);
            }
            catch (KeyStoreException e) {
                LOG.failedToGetCredential(e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.failedToGetCredential(e);
            }
        }
        return credential;
    }

    protected void writeCertificateToFile(Certificate cert, File file) throws CertificateEncodingException, IOException {
        byte[] bytes = cert.getEncoded();
        Base64 encoder = new Base64(76, "\n".getBytes(StandardCharsets.US_ASCII));
        try (FileOutputStream out = new FileOutputStream(file);){
            out.write("-----BEGIN CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII));
            out.write(encoder.encodeToString(bytes).getBytes(StandardCharsets.US_ASCII));
            out.write("-----END CERTIFICATE-----\n".getBytes(StandardCharsets.US_ASCII));
        }
    }

    protected void writeKeystoreToFile(KeyStore keyStore, File file) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        try (FileOutputStream out = new FileOutputStream(file);){
            keyStore.store(out, this.masterService.getMasterSecret());
        }
    }

    public void setMasterService(MasterService ms) {
        this.masterService = ms;
    }
}

