/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class GenericProviderDeploymentContributor
extends ProviderDeploymentContributorBase {
    public static final String FILTER_PARAM = "filter";

    public String getRole() {
        return "*";
    }

    public String getName() {
        return "generic";
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        String filterClassName = this.getFilterClassName(provider.getParams());
        if (filterClassName != null) {
            FilterDescriptor filter = resource.addFilter();
            filter.name(this.getName());
            filter.role(provider.getRole());
            filter.impl(filterClassName);
            filter.params(this.getFilterInitParams(filter, provider.getParams(), params));
        }
    }

    private String getFilterClassName(Map<String, String> params) {
        String filterClassName = null;
        if (params != null) {
            filterClassName = params.get(FILTER_PARAM);
        }
        if (filterClassName == null) {
            throw new IllegalArgumentException("filter==null");
        }
        return filterClassName;
    }

    private List<FilterParamDescriptor> getFilterInitParams(FilterDescriptor filter, Map<String, String> providerParams, List<FilterParamDescriptor> filterParams) {
        ArrayList<FilterParamDescriptor> aggregateParams = new ArrayList<FilterParamDescriptor>();
        if (providerParams != null) {
            for (Map.Entry<String, String> param : providerParams.entrySet()) {
                String name = param.getKey();
                if (FILTER_PARAM.equalsIgnoreCase(name)) continue;
                aggregateParams.add(filter.createParam().name(name).value(param.getValue()));
            }
        }
        if (filterParams != null) {
            aggregateParams.addAll(filterParams);
        }
        return aggregateParams;
    }
}

