/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.SparkCommonServiceURLCreator;

public class SparkThriftServerUIServiceURLCreator
extends SparkCommonServiceURLCreator {
    private static final String RESOURCE_ROLE = "THRIFTSERVERUI";

    @Override
    public void init(AmbariCluster cluster) {
        super.init(cluster);
        this.primaryComponentName = "SPARK_THRIFTSERVER";
        this.secondaryComponentName = "SPARK2_THRIFTSERVER";
        this.portConfigProperty = "hive.server2.thrift.http.port";
    }

    @Override
    public String getTargetService() {
        return RESOURCE_ROLE;
    }

    @Override
    public List<String> create(String service, Map<String, String> serviceParams) {
        ArrayList<String> thriftURLs = new ArrayList<String>();
        List<String> urls = super.create(service, serviceParams);
        if (urls != null && !urls.isEmpty()) {
            String transportMode;
            AmbariComponent comp = this.cluster.getComponent(this.primaryComponentName);
            if (comp == null) {
                comp = this.cluster.getComponent(this.secondaryComponentName);
            }
            if (comp != null && (transportMode = comp.getConfigProperty("hive.server2.transport.mode")).equalsIgnoreCase("http")) {
                String endpoint = comp.getConfigProperty("hive.server2.http.endpoint");
                for (String url : urls) {
                    thriftURLs.add(url + (endpoint != null ? "/" + endpoint : ""));
                }
            }
        }
        return thriftURLs;
    }
}

