/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.activation.MimeType;
import javax.servlet.FilterConfig;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.filter.GatewayRequestWrapper;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteServletContextListener;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteServletFilter;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStreamFilterFactory;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteRequestStream;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteUtil;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStreamFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.MimeTypes;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Template;
import org.eclipse.jetty.http.HttpHeader;

public class UrlRewriteRequest
extends GatewayRequestWrapper
implements Resolver {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private FilterConfig config;
    private UrlRewriter rewriter;
    private String urlRuleName;
    private String bodyFilterName;
    private String headersFilterName;
    private UrlRewriteFilterContentDescriptor headersFilterConfig;
    private String cookiesFilterName;

    public UrlRewriteRequest(FilterConfig config, HttpServletRequest request) {
        super(request);
        this.config = config;
        this.rewriter = UrlRewriteServletContextListener.getUrlRewriter(config.getServletContext());
        this.urlRuleName = config.getInitParameter("request.url");
        this.bodyFilterName = config.getInitParameter("request.body");
        this.headersFilterName = config.getInitParameter("request.headers");
        this.headersFilterConfig = this.getRewriteFilterConfig(this.headersFilterName, UrlRewriteServletFilter.HEADERS_MIME_TYPE);
        this.cookiesFilterName = config.getInitParameter("request.cookies");
    }

    Template getSourceUrl() {
        Template urlTemplate;
        StringBuffer urlString = new StringBuffer(128);
        urlString.append(this.getScheme());
        urlString.append("://");
        urlString.append(this.getServerName());
        urlString.append(":");
        urlString.append(this.getServerPort());
        urlString.append(super.getRequestURI());
        String queryString = super.getQueryString();
        if (queryString != null) {
            urlString.append('?');
            urlString.append(queryString);
        }
        try {
            urlTemplate = Parser.parseLiteral((String)urlString.toString());
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(urlString.toString());
            urlTemplate = null;
        }
        return urlTemplate;
    }

    Template getTargetUrl() {
        Template targetUrl;
        boolean rewriteRequestUrl = true;
        if (rewriteRequestUrl) {
            targetUrl = (Template)this.getAttribute("targetRequestUrl");
            if (targetUrl == null) {
                Template sourceUrl = this.getSourceUrl();
                targetUrl = this.rewriter.rewrite(this, sourceUrl, UrlRewriter.Direction.IN, this.urlRuleName);
                this.setAttribute("targetRequestUrl", targetUrl);
            }
        } else {
            targetUrl = (Template)this.getAttribute("sourceRequestUrl");
        }
        return targetUrl;
    }

    private String[] splitTargetUrl(Template url) {
        if (url == null) {
            return EMPTY_STRING_ARRAY;
        }
        String s = url.toString();
        return s.split("\\?");
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getRequestURI() {
        String[] split = this.splitTargetUrl(this.getTargetUrl());
        if (split.length > 0) {
            return split[0];
        }
        return "";
    }

    public String getQueryString() {
        String[] split = this.splitTargetUrl(this.getTargetUrl());
        if (split.length > 1) {
            try {
                return URLDecoder.decode(split[1], StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LOG.failedToDecodeQueryString(split[1], e);
                return split[1];
            }
        }
        return null;
    }

    private String rewriteValue(UrlRewriter rewriter, String value, String rule) {
        try {
            Template input = Parser.parseLiteral((String)value);
            Template output = rewriter.rewrite(this, input, UrlRewriter.Direction.IN, rule);
            value = output.getPattern();
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = null;
        if (name.equalsIgnoreCase("Host")) {
            String uri = this.getRequestURI();
            try {
                URL url = new URL(uri);
                value = url.getHost();
                return value;
            }
            catch (MalformedURLException e) {
                value = null;
            }
        }
        if ((value = super.getHeader(name)) != null) {
            value = this.rewriteValue(this.rewriter, super.getHeader(name), UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name));
        }
        return value;
    }

    public Enumeration getHeaders(String name) {
        return new EnumerationRewriter(this.rewriter, super.getHeaders(name), UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name));
    }

    public List<String> resolve(String name) {
        return Arrays.asList(this.config.getInitParameter(name));
    }

    public ServletInputStream getInputStream() throws IOException {
        Object input = super.getInputStream();
        if (this.getContentLength() != 0) {
            Object stream;
            UrlRewriteStreamFilter filter;
            String asType;
            UrlRewriteFilterContentDescriptor filterContentConfig;
            MimeType mimeType = this.getMimeType();
            String contentEncoding = this.getHeader(HttpHeader.CONTENT_ENCODING.asString());
            if (!StringUtils.isBlank((CharSequence)contentEncoding) && StringUtils.containsAny((CharSequence)contentEncoding, (CharSequence[])new CharSequence[]{"gzip", "compress", "deflate", "br"})) {
                mimeType = MimeTypes.create((String)("application/" + contentEncoding), (String)this.getCharacterEncoding());
            }
            if ((filterContentConfig = this.getRewriteFilterConfig(this.bodyFilterName, mimeType)) != null && (asType = filterContentConfig.asType()) != null && asType.trim().length() > 0) {
                mimeType = MimeTypes.create((String)asType, (String)this.getCharacterEncoding());
            }
            if ((filter = UrlRewriteStreamFilterFactory.create(mimeType, null)) != null) {
                String charset = MimeTypes.getCharset((MimeType)mimeType, (String)StandardCharsets.ISO_8859_1.name());
                stream = filter.filter((InputStream)input, charset, this.rewriter, this, UrlRewriter.Direction.IN, filterContentConfig);
            } else {
                stream = input;
            }
            input = new UrlRewriteRequestStream((InputStream)stream);
        }
        return input;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
    }

    public int getContentLength() {
        int contentLength = super.getContentLength();
        if (contentLength > 0) {
            contentLength = -1;
        }
        return contentLength;
    }

    private UrlRewriteFilterContentDescriptor getRewriteFilterConfig(String filterName, MimeType mimeType) {
        UrlRewriteFilterDescriptor filterConfig;
        UrlRewriteFilterContentDescriptor filterContentConfig = null;
        UrlRewriteRulesDescriptor rewriteConfig = this.rewriter.getConfig();
        if (rewriteConfig != null && (filterConfig = rewriteConfig.getFilter(filterName)) != null) {
            filterContentConfig = filterConfig.getContent(mimeType);
        }
        return filterContentConfig;
    }

    private class EnumerationRewriter
    implements Enumeration<String> {
        private UrlRewriter rewriter;
        private Enumeration<String> delegate;
        private String rule;

        private EnumerationRewriter(UrlRewriter rewriter, Enumeration<String> delegate, String rule) {
            this.rewriter = rewriter;
            this.delegate = delegate;
            this.rule = rule;
        }

        @Override
        public boolean hasMoreElements() {
            return this.delegate.hasMoreElements();
        }

        @Override
        public String nextElement() {
            return UrlRewriteRequest.this.rewriteValue(this.rewriter, this.delegate.nextElement(), this.rule);
        }
    }
}

