/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.util.ArrayList;
import java.util.Collections;

public class IpAddressValidator {
    private ArrayList<String> ipaddr = new ArrayList();
    private ArrayList<String> wildCardIPs = new ArrayList();
    private boolean anyIP = true;

    public IpAddressValidator(String commaSeparatedIpAddresses) {
        if (commaSeparatedIpAddresses == null) {
            this.anyIP = true;
            return;
        }
        this.parseIpAddesses(commaSeparatedIpAddresses);
    }

    private void parseIpAddesses(String commaSeparatedIpAddresses) {
        String[] ips = commaSeparatedIpAddresses.split(",");
        this.ipaddr = new ArrayList();
        this.wildCardIPs = new ArrayList();
        Collections.addAll(this.ipaddr, ips);
        if (!this.ipaddr.contains("*")) {
            this.anyIP = false;
            for (String addr : this.ipaddr) {
                if (!addr.contains("*")) continue;
                this.wildCardIPs.add(addr.substring(0, addr.lastIndexOf(42)));
            }
        }
    }

    public boolean validateIpAddress(String addr) {
        boolean valid = false;
        if (addr == null) {
            return false;
        }
        if (this.anyIP) {
            valid = true;
        } else if (this.ipaddr.contains(addr)) {
            valid = true;
        } else if (!this.wildCardIPs.isEmpty()) {
            for (String ip : this.wildCardIPs) {
                if (!addr.startsWith(ip)) continue;
                valid = true;
                break;
            }
        }
        return valid;
    }

    public boolean allowsAnyIP() {
        return this.anyIP;
    }

    public ArrayList<String> getIPAddresses() {
        return this.ipaddr;
    }
}

