/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class HttpUtils {
    public static Map<String, List<String>> splitQuery(String queryString) throws UnsupportedEncodingException {
        String[] pairs;
        HashMap<String, List<String>> queryPairs = new HashMap<String, List<String>>();
        if (queryString == null || queryString.trim().isEmpty()) {
            return queryPairs;
        }
        for (String pair : pairs = queryString.split("&")) {
            String key;
            int idx = pair.indexOf(61);
            String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8.name()) : pair;
            if (!queryPairs.containsKey(key)) {
                queryPairs.put(key, new ArrayList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8.name()) : "";
            ((List)queryPairs.get(key)).add(value);
        }
        return queryPairs;
    }

    public static Map<String, String[]> parseQueryString(String queryString) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (queryString != null && !queryString.isEmpty()) {
            StringTokenizer parser = new StringTokenizer(queryString, "&?;=", true);
            String name = null;
            String value = null;
            block4: while (parser.hasMoreTokens()) {
                String token = parser.nextToken();
                String ttoken = token.trim();
                if (ttoken.length() == 1) {
                    char c = ttoken.charAt(0);
                    switch (c) {
                        case '&': 
                        case ';': 
                        case '?': {
                            HttpUtils.addQueryStringParam(map, name, value);
                            name = null;
                            value = null;
                            continue block4;
                        }
                        case '=': {
                            if (name == null) {
                                name = "";
                                value = "";
                                continue block4;
                            }
                            if (name.isEmpty()) {
                                HttpUtils.addQueryStringParam(map, name, value);
                                name = "";
                                value = "";
                                continue block4;
                            }
                            value = "";
                            continue block4;
                        }
                    }
                }
                if (name == null) {
                    name = token;
                    continue;
                }
                value = token;
            }
            if (name != null) {
                HttpUtils.addQueryStringParam(map, name, value);
            }
        }
        return map;
    }

    private static final String urlDecodeUtf8(String s) {
        if (s != null) {
            try {
                s = URLDecoder.decode(s, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    static final void addQueryStringParam(Map<String, String[]> map, String name, String value) {
        name = HttpUtils.urlDecodeUtf8(name);
        value = HttpUtils.urlDecodeUtf8(value);
        String[] values = map.get(name);
        if (values == null) {
            values = new String[]{value};
        } else {
            values = Arrays.copyOf(values, values.length + 1);
            values[values.length - 1] = value;
        }
        map.put(name, values);
    }
}

