/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.core.internal.filter;

import java.util.ArrayList;
import org.apache.karaf.packages.core.internal.filter.AndExpression;
import org.apache.karaf.packages.core.internal.filter.ExprTokenizer;
import org.apache.karaf.packages.core.internal.filter.Expression;
import org.apache.karaf.packages.core.internal.filter.NotExpression;
import org.apache.karaf.packages.core.internal.filter.SimpleItem;

public class FilterParser {
    public Expression parse(String filter) {
        return this.parse(new ExprTokenizer(filter));
    }

    private Expression parse(ExprTokenizer tokenizer) {
        if (!"(".equals(tokenizer.nextToken())) {
            throw new IllegalArgumentException("Invalid Syntax");
        }
        return this.parseFilterComp(tokenizer);
    }

    private Expression parseFilterComp(ExprTokenizer tokenizer) {
        String token = tokenizer.peekNextToken();
        if ("!".equals(token)) {
            tokenizer.nextToken();
            return new NotExpression(this.parse(tokenizer));
        }
        if ("&".equals(token)) {
            tokenizer.nextToken();
            return new AndExpression(this.parseFilterList(tokenizer));
        }
        return this.parseItem(tokenizer);
    }

    private Expression[] parseFilterList(ExprTokenizer tokenizer) {
        ArrayList<Expression> exprList = new ArrayList<Expression>();
        while ("(".equals(tokenizer.peekNextToken())) {
            tokenizer.nextToken();
            exprList.add(this.parseFilterComp(tokenizer));
            tokenizer.nextToken();
        }
        return exprList.toArray(new Expression[0]);
    }

    private Expression parseItem(ExprTokenizer tokenizer) {
        String attr = tokenizer.nextToken();
        String filterType = tokenizer.nextToken();
        String value = tokenizer.nextToken();
        return new SimpleItem(attr, filterType, value);
    }
}

