/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.lib.io.IO;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferDataInput
implements DataInput {
    private final ByteBuffer bb;

    public static DataInput wrap(ByteBuffer bb) {
        return new ByteBufferDataInput(bb);
    }

    public static DataInput wrap(byte[] b) {
        return ByteBufferDataInput.wrap(b, 0, b.length);
    }

    public static DataInput wrap(byte[] b, int off, int len) {
        return ByteBufferDataInput.wrap(ByteBuffer.wrap(b, off, len));
    }

    private ByteBufferDataInput(ByteBuffer bb) {
        this.bb = Objects.requireNonNull(bb);
    }

    private int ranged(int n) {
        if (n <= 0) {
            return 0;
        }
        return Math.min(n, this.bb.remaining());
    }

    public ByteBuffer slice(int n) {
        int limit = this.ranged(n);
        ByteBuffer slice = this.bb.slice();
        slice.limit(limit);
        this.bb.position(this.bb.position() + limit);
        return slice;
    }

    @Override
    public void readFully(byte[] b) {
        this.bb.get(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this.bb.get(b, off, len);
    }

    @Override
    public int skipBytes(int n) {
        int skipped = this.ranged(n);
        this.bb.position(this.bb.position() + skipped);
        return skipped;
    }

    @Override
    public boolean readBoolean() {
        return this.bb.get() != 0;
    }

    @Override
    public byte readByte() {
        return this.bb.get();
    }

    @Override
    public int readUnsignedByte() {
        return Byte.toUnsignedInt(this.bb.get());
    }

    @Override
    public short readShort() {
        return this.bb.getShort();
    }

    @Override
    public int readUnsignedShort() {
        return Short.toUnsignedInt(this.bb.getShort());
    }

    @Override
    public char readChar() {
        return this.bb.getChar();
    }

    @Override
    public int readInt() {
        return this.bb.getInt();
    }

    @Override
    public long readLong() {
        return this.bb.getLong();
    }

    @Override
    public float readFloat() {
        return this.bb.getFloat();
    }

    @Override
    public double readDouble() {
        return this.bb.getDouble();
    }

    @Override
    @Deprecated
    public String readLine() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return IO.readUTF(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[pos=");
        sb.append(this.bb.position());
        sb.append(" lim=");
        sb.append(this.bb.limit());
        sb.append(" cap=");
        sb.append(this.bb.capacity());
        sb.append("]");
        return sb.toString();
    }
}

