/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.List;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundlesCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="ids", description="The list of bundle (identified by IDs or name or name/version) separated by whitespaces", required=false, multiValued=true)
    List<String> ids;
    boolean defaultAllBundles = true;
    BundleService bundleService;

    public BundlesCommand(boolean defaultAllBundles) {
        this.defaultAllBundles = defaultAllBundles;
    }

    protected Object doExecute() throws Exception {
        this.doExecute(true);
        return null;
    }

    protected Object doExecute(boolean force) throws Exception {
        List bundles = this.bundleService.selectBundles(this.ids, this.defaultAllBundles);
        if (!force) {
            this.assertNoSystemBundles(bundles);
        }
        this.doExecute(bundles);
        return null;
    }

    private void assertNoSystemBundles(List<Bundle> bundles) {
        for (Bundle bundle : bundles) {
            if (!ShellUtil.isASystemBundle((BundleContext)this.bundleContext, (Bundle)bundle)) continue;
            throw new RuntimeException("Access to system bundle " + bundle.getBundleId() + " denied. You can override with -f");
        }
    }

    protected abstract void doExecute(List<Bundle> var1) throws Exception;

    public void setBundleService(BundleService bundleSelector) {
        this.bundleService = bundleSelector;
    }
}

