/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.state.internals.RecordConverter;
import org.apache.kafka.streams.state.internals.RecordConverters;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;

final class StateManagerUtil {
    static final String CHECKPOINT_FILE_NAME = ".checkpoint";
    static final long OFFSET_DELTA_THRESHOLD_FOR_CHECKPOINT = 10000L;

    private StateManagerUtil() {
    }

    static RecordConverter converterForStore(StateStore store) {
        return WrappedStateStore.isTimestamped(store) && !WrappedStateStore.isVersioned(store) ? RecordConverters.rawValueToTimestampedValue() : RecordConverters.identity();
    }

    static boolean checkpointNeeded(boolean enforceCheckpoint, Map<TopicPartition, Long> oldOffsetSnapshot, Map<TopicPartition, Long> newOffsetSnapshot) {
        if (oldOffsetSnapshot == null) {
            return false;
        }
        if (enforceCheckpoint) {
            return true;
        }
        long totalOffsetDelta = 0L;
        for (Map.Entry<TopicPartition, Long> entry : newOffsetSnapshot.entrySet()) {
            totalOffsetDelta += entry.getValue() - oldOffsetSnapshot.getOrDefault(entry.getKey(), 0L);
        }
        return totalOffsetDelta > 10000L;
    }

    static void registerStateStores(Logger log, String logPrefix, ProcessorTopology topology, ProcessorStateManager stateMgr, StateDirectory stateDirectory, InternalProcessorContext<?, ?> processorContext) {
        if (topology.stateStores().isEmpty()) {
            return;
        }
        TaskId id = stateMgr.taskId();
        if (!stateDirectory.lock(id)) {
            throw new LockException(String.format("%sFailed to lock the state directory for task %s", logPrefix, id));
        }
        log.debug("Acquired state directory lock");
        boolean storeDirsEmpty = stateDirectory.directoryForTaskIsEmpty(id);
        stateMgr.registerStateStores(topology.stateStores(), processorContext);
        log.debug("Registered state stores");
        stateMgr.initializeStoreOffsetsFromCheckpoint(storeDirsEmpty);
        log.debug("Initialized state stores");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeStateManager(Logger log, String logPrefix, boolean closeClean, boolean eosEnabled, ProcessorStateManager stateMgr, StateDirectory stateDirectory, Task.TaskType taskType) {
        AtomicReference<Object> firstException;
        block17: {
            boolean wipeStateStore = !closeClean && eosEnabled;
            TaskId id = stateMgr.taskId();
            log.trace("Closing state manager for {} task {}", (Object)taskType, (Object)id);
            firstException = new AtomicReference<Object>(null);
            try {
                if (stateDirectory.lock(id)) {
                    try {
                        stateMgr.close();
                        break block17;
                    }
                    catch (ProcessorStateException e) {
                        firstException.compareAndSet(null, e);
                        break block17;
                    }
                    finally {
                        try {
                            if (wipeStateStore) {
                                log.debug("Wiping state stores for {} task {}", (Object)taskType, (Object)id);
                                Utils.delete((File)stateMgr.baseDir());
                            }
                        }
                        finally {
                            stateDirectory.unlock(id);
                        }
                    }
                }
                log.error("Failed to acquire lock while closing the state store for {} task {}", (Object)taskType, (Object)id);
            }
            catch (IOException e) {
                ProcessorStateException exception = new ProcessorStateException(String.format("%sFatal error while trying to close the state manager for task %s", logPrefix, id), e);
                firstException.compareAndSet(null, exception);
            }
        }
        ProcessorStateException exception = firstException.get();
        if (exception != null) {
            throw exception;
        }
    }

    static TaskId parseTaskDirectoryName(String taskIdStr, String namedTopology) {
        int index = taskIdStr.indexOf(95);
        if (index <= 0 || index + 1 >= taskIdStr.length()) {
            throw new TaskIdFormatException(taskIdStr);
        }
        try {
            int topicGroupId = Integer.parseInt(taskIdStr.substring(0, index));
            int partition = Integer.parseInt(taskIdStr.substring(index + 1));
            return new TaskId(topicGroupId, partition, namedTopology);
        }
        catch (Exception e) {
            throw new TaskIdFormatException(taskIdStr, e);
        }
    }

    static String toTaskDirString(TaskId taskId) {
        return taskId.subtopology() + "_" + taskId.partition();
    }
}

