/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ReplicaKey;

public final class VoterSet {
    private final Map<Integer, VoterNode> voters;
    private static final VoterSet EMPTY = new VoterSet(Collections.emptyMap());

    private VoterSet(Map<Integer, VoterNode> voters) {
        this.voters = voters;
    }

    public Set<Node> voterNodes(Stream<Integer> voterIds, ListenerName listenerName) {
        return voterIds.map(voterId -> this.voterNode((int)voterId, listenerName).orElseThrow(() -> new IllegalArgumentException(String.format("Unable to find endpoint for voter %d and listener %s in %s", voterId, listenerName, this.voters)))).collect(Collectors.toSet());
    }

    public Optional<Node> voterNode(int voterId, ListenerName listenerName) {
        return Optional.ofNullable(this.voters.get(voterId)).flatMap(voterNode -> voterNode.address(listenerName)).map(address -> new Node(voterId, address.getHostString(), address.getPort()));
    }

    public boolean voterNodeNeedsUpdate(VoterNode updatedVoterNode) {
        return Optional.ofNullable(this.voters.get(updatedVoterNode.voterKey().id())).map(node -> node.isVoter(updatedVoterNode.voterKey()) && !node.equals(updatedVoterNode)).orElse(false);
    }

    public boolean isVoter(ReplicaKey replicaKey) {
        return Optional.ofNullable(this.voters.get(replicaKey.id())).map(node -> node.isVoter(replicaKey)).orElse(false);
    }

    public boolean isOnlyVoter(ReplicaKey nodeKey) {
        return this.voters.size() == 1 && this.isVoter(nodeKey);
    }

    public Set<Integer> voterIds() {
        return this.voters.keySet();
    }

    public Set<ReplicaKey> voterKeys() {
        return this.voters.values().stream().map(VoterNode::voterKey).collect(Collectors.toSet());
    }

    public Set<VoterNode> voterNodes() {
        return new HashSet<VoterNode>(this.voters.values());
    }

    public int size() {
        return this.voters.size();
    }

    public boolean isEmpty() {
        return this.voters.isEmpty();
    }

    public Endpoints listeners(int voterId) {
        return Optional.ofNullable(this.voters.get(voterId)).map(VoterNode::listeners).orElse(Endpoints.empty());
    }

    public Optional<VoterSet> addVoter(VoterNode voter) {
        if (this.voters.containsKey(voter.voterKey().id())) {
            return Optional.empty();
        }
        HashMap<Integer, VoterNode> newVoters = new HashMap<Integer, VoterNode>(this.voters);
        newVoters.put(voter.voterKey().id(), voter);
        return Optional.of(new VoterSet(newVoters));
    }

    public Optional<VoterSet> removeVoter(ReplicaKey voterKey) {
        VoterNode oldVoter = this.voters.get(voterKey.id());
        if (oldVoter != null && Objects.equals(oldVoter.voterKey(), voterKey) && this.voters.size() > 1) {
            HashMap<Integer, VoterNode> newVoters = new HashMap<Integer, VoterNode>(this.voters);
            newVoters.remove(voterKey.id());
            return Optional.of(new VoterSet(newVoters));
        }
        return Optional.empty();
    }

    public Optional<VoterSet> updateVoter(VoterNode voter) {
        VoterNode oldVoter = this.voters.get(voter.voterKey().id());
        if (oldVoter != null && oldVoter.isVoter(voter.voterKey())) {
            HashMap<Integer, VoterNode> newVoters = new HashMap<Integer, VoterNode>(this.voters);
            newVoters.put(voter.voterKey().id(), voter);
            return Optional.of(new VoterSet(newVoters));
        }
        return Optional.empty();
    }

    public VotersRecord toVotersRecord(short version) {
        Function<VoterNode, VotersRecord.Voter> voterConvertor = voter -> {
            Iterator<VotersRecord.Endpoint> endpoints = voter.listeners().votersRecordEndpoints();
            VotersRecord.KRaftVersionFeature kraftVersionFeature = new VotersRecord.KRaftVersionFeature().setMinSupportedVersion(voter.supportedKRaftVersion().min()).setMaxSupportedVersion(voter.supportedKRaftVersion().max());
            return new VotersRecord.Voter().setVoterId(voter.voterKey().id()).setVoterDirectoryId(voter.voterKey().directoryId().orElse(Uuid.ZERO_UUID)).setEndpoints(new VotersRecord.EndpointCollection(endpoints)).setKRaftVersionFeature(kraftVersionFeature);
        };
        List voterRecordVoters = this.voters.values().stream().map(voterConvertor).collect(Collectors.toList());
        return new VotersRecord().setVersion(version).setVoters(voterRecordVoters);
    }

    public boolean hasOverlappingMajority(VoterSet that) {
        Set<ReplicaKey> thatReplicaKeys;
        Set<ReplicaKey> thisReplicaKeys = this.voterKeys();
        if (Utils.diff(HashSet::new, thisReplicaKeys, thatReplicaKeys = that.voterKeys()).size() > 1) {
            return false;
        }
        return Utils.diff(HashSet::new, thatReplicaKeys, thisReplicaKeys).size() <= 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoterSet that = (VoterSet)o;
        return this.voters.equals(that.voters);
    }

    public int hashCode() {
        return Objects.hashCode(this.voters);
    }

    public String toString() {
        return String.format("VoterSet(voters=%s)", this.voters);
    }

    public static VoterSet empty() {
        return EMPTY;
    }

    public static VoterSet fromVotersRecord(VotersRecord voters) {
        HashMap<Integer, VoterNode> voterNodes = new HashMap<Integer, VoterNode>(voters.voters().size());
        for (VotersRecord.Voter voter : voters.voters()) {
            voterNodes.put(voter.voterId(), new VoterNode(ReplicaKey.of(voter.voterId(), voter.voterDirectoryId()), Endpoints.fromVotersRecordEndpoints((Collection<VotersRecord.Endpoint>)voter.endpoints()), new SupportedVersionRange(voter.kRaftVersionFeature().minSupportedVersion(), voter.kRaftVersionFeature().maxSupportedVersion())));
        }
        return new VoterSet(voterNodes);
    }

    public static VoterSet fromInetSocketAddresses(ListenerName listener, Map<Integer, InetSocketAddress> voters) {
        Map<Integer, VoterNode> voterNodes = voters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new VoterNode(ReplicaKey.of((Integer)entry.getKey(), Uuid.ZERO_UUID), Endpoints.fromInetSocketAddresses(Collections.singletonMap(listener, (InetSocketAddress)entry.getValue())), new SupportedVersionRange(0, 0))));
        return new VoterSet(voterNodes);
    }

    public static VoterSet fromMap(Map<Integer, VoterNode> voters) {
        return new VoterSet(new HashMap<Integer, VoterNode>(voters));
    }

    public static final class VoterNode {
        private final ReplicaKey voterKey;
        private final Endpoints listeners;
        private final SupportedVersionRange supportedKRaftVersion;

        VoterNode(ReplicaKey voterKey, Endpoints listeners, SupportedVersionRange supportedKRaftVersion) {
            this.voterKey = voterKey;
            this.listeners = listeners;
            this.supportedKRaftVersion = supportedKRaftVersion;
        }

        public ReplicaKey voterKey() {
            return this.voterKey;
        }

        public boolean isVoter(ReplicaKey replicaKey) {
            if (this.voterKey.id() != replicaKey.id()) {
                return false;
            }
            if (this.voterKey.directoryId().isPresent()) {
                return this.voterKey.directoryId().equals(replicaKey.directoryId());
            }
            return true;
        }

        public Endpoints listeners() {
            return this.listeners;
        }

        SupportedVersionRange supportedKRaftVersion() {
            return this.supportedKRaftVersion;
        }

        Optional<InetSocketAddress> address(ListenerName listener) {
            return this.listeners.address(listener);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VoterNode that = (VoterNode)o;
            if (!Objects.equals(this.voterKey, that.voterKey)) {
                return false;
            }
            if (!Objects.equals(this.supportedKRaftVersion, that.supportedKRaftVersion)) {
                return false;
            }
            return Objects.equals(this.listeners, that.listeners);
        }

        public int hashCode() {
            return Objects.hash(this.voterKey, this.listeners, this.supportedKRaftVersion);
        }

        public String toString() {
            return String.format("VoterNode(voterKey=%s, listeners=%s, supportedKRaftVersion=%s)", this.voterKey, this.listeners, this.supportedKRaftVersion);
        }

        public static VoterNode of(ReplicaKey voterKey, Endpoints listeners, SupportedVersionRange supportedKRaftVersion) {
            return new VoterNode(voterKey, listeners, supportedKRaftVersion);
        }
    }
}

