/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.Deserializer;
import org.apache.kafka.coordinator.common.runtime.Serializer;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public abstract class CoordinatorRecordSerde
implements Serializer<CoordinatorRecord>,
Deserializer<CoordinatorRecord> {
    @Override
    public byte[] serializeKey(CoordinatorRecord record) {
        return MessageUtil.toVersionPrefixedBytes((short)record.key().version(), (Message)record.key().message());
    }

    @Override
    public byte[] serializeValue(CoordinatorRecord record) {
        if (record.value() == null) {
            return null;
        }
        return MessageUtil.toVersionPrefixedBytes((short)record.value().version(), (Message)record.value().message());
    }

    @Override
    public CoordinatorRecord deserialize(ByteBuffer keyBuffer, ByteBuffer valueBuffer) throws RuntimeException {
        short recordType = this.readVersion(keyBuffer, "key");
        ApiMessage keyMessage = this.apiMessageKeyFor(recordType);
        this.readMessage(keyMessage, keyBuffer, recordType, "key");
        if (valueBuffer == null) {
            return new CoordinatorRecord(new ApiMessageAndVersion(keyMessage, recordType), null);
        }
        ApiMessage valueMessage = this.apiMessageValueFor(recordType);
        short valueVersion = this.readVersion(valueBuffer, "value");
        if (valueVersion < valueMessage.lowestSupportedVersion() || valueVersion > valueMessage.highestSupportedVersion()) {
            throw new Deserializer.UnknownRecordVersionException(recordType, valueVersion);
        }
        this.readMessage(valueMessage, valueBuffer, valueVersion, "value");
        return new CoordinatorRecord(new ApiMessageAndVersion(keyMessage, recordType), new ApiMessageAndVersion(valueMessage, valueVersion));
    }

    private short readVersion(ByteBuffer buffer, String name) throws RuntimeException {
        try {
            return buffer.getShort();
        }
        catch (BufferUnderflowException ex) {
            throw new RuntimeException(String.format("Could not read version from %s's buffer.", name));
        }
    }

    private void readMessage(ApiMessage message, ByteBuffer buffer, short version, String name) throws RuntimeException {
        try {
            message.read((Readable)new ByteBufferAccessor(buffer), version);
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(String.format("Could not read record with version %d from %s's buffer due to: %s.", version, name, ex.getMessage()), ex);
        }
    }

    protected abstract ApiMessage apiMessageKeyFor(short var1);

    protected abstract ApiMessage apiMessageValueFor(short var1);
}

