/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.Objects;
import org.apache.kafka.server.share.ShareSessionKey;

public class LastUsedKey
implements Comparable<LastUsedKey> {
    private final ShareSessionKey key;
    private final long lastUsedMs;

    public LastUsedKey(ShareSessionKey key, long lastUsedMs) {
        this.key = key;
        this.lastUsedMs = lastUsedMs;
    }

    public ShareSessionKey key() {
        return this.key;
    }

    public long lastUsedMs() {
        return this.lastUsedMs;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.lastUsedMs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LastUsedKey other = (LastUsedKey)obj;
        return this.lastUsedMs == other.lastUsedMs && Objects.equals(this.key, other.key);
    }

    @Override
    public int compareTo(LastUsedKey other) {
        int res = Long.compare(this.lastUsedMs, other.lastUsedMs);
        if (res != 0) {
            return res;
        }
        return Integer.compare(this.key.hashCode(), other.key.hashCode());
    }
}

