/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r\u0015e\u0001\u0002)R\u0001YC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\tq\u0002\u0011)\u0019!C\u0001s\"I\u0011\u0011\u0003\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002@\u0001\u0011\t\u0011)A\u0005\u0003\u0003Bq!a\u0013\u0001\t\u0003\ti\u0005\u0003\u0006\u0002\\\u0001\u0011\r\u0011\"\u0001R\u0003;B\u0001\"!\u001c\u0001A\u0003%\u0011q\f\u0005\n\u0003_\u0002\u0001\u0019!C\u0005\u0003cB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u000f\u0005\u0005\u0005\u0001)Q\u0005U\"Q\u00111\u0012\u0001C\u0002\u0013\u0005\u0011+!$\t\u0011\u0005U\u0005\u0001)A\u0005\u0003\u001fC!\"a&\u0001\u0005\u0004%\t!UAM\u0011!\t)\u000b\u0001Q\u0001\n\u0005m\u0005BCAT\u0001\t\u0007I\u0011A)\u0002*\"A!\u0011\u0010\u0001!\u0002\u0013\tY\u000bC\u0004\u0003|\u0001!IA! \t\u0011\t=\u0005\u0001\"\u0001R\u0005#CqAa%\u0001\t\u0003\u0011y\u0003\u0003\u0005\u0003\u0016\u0002\u0001K\u0011\u0002B\u0018\u0011\u001d\u00119\n\u0001C\u0001\u0005_AqA!'\u0001\t\u0003\u0011y\u0003C\u0004\u0003\u001c\u0002!\tE!(\t\u000f\t\u0015\u0006\u0001\"\u0011\u0003(\"9!1\u0017\u0001\u0005B\tU\u0006b\u0002B_\u0001\u0011\u0005!q\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0001Bc\u0011%\u0011)\u000eAI\u0001\n\u0003\u00119\u000eC\u0004\u0003n\u0002!\tAa<\t\u000f\tm\b\u0001\"\u0001\u0003~\"911\u0001\u0001\u0005\u0002\r\u0015\u0001bBB\b\u0001\u0011\u00051\u0011\u0003\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019\u0019\u0003\u0001C\u0001\u0007KA\u0011ba\f\u0001#\u0003%\ta!\r\t\u000f\rU\u0002\u0001\"\u0001\u00048!A1\u0011\t\u0001\u0005\u0002M\u000b\t\b\u0003\u0005\u0004D\u0001!\t!\u0015BI\r\u001d\tY\f\u0001\u0001R\u0003{C!\"a3,\u0005\u0003\u0005\u000b\u0011BAg\u0011\u001d\tYe\u000bC\u0001\u0003'Dq!a6,\t#\nI\u000eC\u0005\u0002r.\u0012\r\u0011\"\u0001\u0002t\"A\u00111`\u0016!\u0002\u0013\t)\u0010C\u0005\u0002~.\u0002\r\u0011\"\u0001\u0002\u0000\"I!qA\u0016A\u0002\u0013\u0005!\u0011\u0002\u0005\t\u0005\u001bY\u0003\u0015)\u0003\u0003\u0002!I!\u0011C\u0016A\u0002\u0013\u0005!1\u0003\u0005\n\u00057Y\u0003\u0019!C\u0001\u0005;A\u0001B!\t,A\u0003&!Q\u0003\u0005\b\u0005KYC\u0011\u0002B\u0014\u0011\u001d\u0011ic\u000bC!\u0005_AqA!\r,\t\u0013\u0011\u0019\u0004C\u0004\u0003<-\"IAa\r\t\u000f\t53\u0006\"\u0003\u0003P!9!1L\u0016\u0005\n\tusaBB##\"\u00051q\t\u0004\u0007!FC\ta!\u0013\t\u000f\u0005-c\b\"\u0001\u0004L!I1Q\n C\u0002\u0013\u0005!Q\u0014\u0005\t\u0007\u001fr\u0004\u0015!\u0003\u0003 \"91\u0011\u000b \u0005\u0002\rM\u0003\"CB,}\t\u0007I\u0011BB-\u0011!\u0019)G\u0010Q\u0001\n\rm\u0003\"CB4}\t\u0007I\u0011BB-\u0011!\u0019IG\u0010Q\u0001\n\rm\u0003\"CB6}\t\u0007I\u0011BB-\u0011!\u0019iG\u0010Q\u0001\n\rm\u0003\"CB8}\t\u0007I\u0011BB-\u0011!\u0019\tH\u0010Q\u0001\n\rm\u0003\"CB:}\t\u0007I\u0011BB-\u0011!\u0019)H\u0010Q\u0001\n\rm\u0003BCB<}\t\u0007I\u0011A)\u0004z!A1Q\u0010 !\u0002\u0013\u0019Y\bC\u0005\u0004\u0000y\n\n\u0011\"\u0001\u0004\u0002\nQAj\\4DY\u0016\fg.\u001a:\u000b\u0005I\u001b\u0016a\u00017pO*\tA+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u00019Vl\u0019\t\u00031nk\u0011!\u0017\u0006\u00025\u0006)1oY1mC&\u0011A,\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\u001c\u0016!B;uS2\u001c\u0018B\u00012`\u0005\u001daunZ4j]\u001e\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ*\u0002\rM,'O^3s\u0013\tAWM\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000eS:LG/[1m\u0007>tg-[4\u0011\u0005-4X\"\u00017\u000b\u0005Ik'B\u00018p\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002qc\u000691\u000f^8sC\u001e,'B\u0001+s\u0015\t\u0019H/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0006\u0019qN]4\n\u0005]d'!D\"mK\u0006tWM]\"p]\u001aLw-A\u0004m_\u001e$\u0015N]:\u0016\u0003i\u0004Ba\u001f@\u0002\u00025\tAP\u0003\u0002~3\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005}d(aA*fcB!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011AA5p\u0015\t\tY!\u0001\u0003kCZ\f\u0017\u0002BA\b\u0003\u000b\u0011AAR5mK\u0006AAn\\4ESJ\u001c\b%\u0001\u0003m_\u001e\u001cXCAA\f!\u001dq\u0016\u0011DA\u000f\u0003SI1!a\u0007`\u0005\u0011\u0001vn\u001c7\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tr\u0003\u0019\u0019w.\\7p]&!\u0011qEA\u0011\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!a\u000b\u0002.5\t\u0011+C\u0002\u00020E\u0013!\"\u00168jM&,G\rT8h\u0003\u0015awnZ:!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\u0011\u0011q\u0007\t\u0004W\u0006e\u0012bAA\u001eY\n!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\fQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007%\u0001\u0003uS6,\u0007\u0003BA\"\u0003\u000fj!!!\u0012\u000b\u0007\u0001\f\t#\u0003\u0003\u0002J\u0005\u0015#\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003DA(\u0003#\n\u0019&!\u0016\u0002X\u0005e\u0003cAA\u0016\u0001!)\u0011.\u0003a\u0001U\")\u00010\u0003a\u0001u\"9\u00111C\u0005A\u0002\u0005]\u0001bBA\u001a\u0013\u0001\u0007\u0011q\u0007\u0005\n\u0003\u007fI\u0001\u0013!a\u0001\u0003\u0003\nA\"\\3ue&\u001c7o\u0012:pkB,\"!a\u0018\u0011\t\u0005\u0005\u0014\u0011N\u0007\u0003\u0003GRA!!\u001a\u0002h\u00059Q.\u001a;sS\u000e\u001c(B\u00014r\u0013\u0011\tY'a\u0019\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0007G>tg-[4\u0016\u0003)\f!bY8oM&<w\fJ3r)\u0011\t9(! \u0011\u0007a\u000bI(C\u0002\u0002|e\u0013A!\u00168ji\"A\u0011qP\u0007\u0002\u0002\u0003\u0007!.A\u0002yIE\nqaY8oM&<\u0007\u0005K\u0002\u000f\u0003\u000b\u00032\u0001WAD\u0013\r\tI)\u0017\u0002\tm>d\u0017\r^5mK\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014XCAAH!\u0011\tY#!%\n\u0007\u0005M\u0015KA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fqb\u00197fC:,'/T1oC\u001e,'\u000fI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\"!a'\u0011\t\u0005u\u0015\u0011U\u0007\u0003\u0003?S!\u0001Y7\n\t\u0005\r\u0016q\u0014\u0002\n)\"\u0014x\u000e\u001e;mKJ\f!\u0002\u001e5s_R$H.\u001a:!\u0003!\u0019G.Z1oKJ\u001cXCAAV!\u0019\ti+a-\u000286\u0011\u0011q\u0016\u0006\u0004\u0003cc\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003k\u000byKA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bcAA]W5\t\u0001AA\u0007DY\u0016\fg.\u001a:UQJ,\u0017\rZ\n\u0005W\u0005}V\f\u0005\u0003\u0002B\u0006\u001dWBAAb\u0015\u0011\t)-a\u001a\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0013\f\u0019M\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017\u0001\u0003;ie\u0016\fG-\u00133\u0011\u0007a\u000by-C\u0002\u0002Rf\u00131!\u00138u)\u0011\t9,!6\t\u000f\u0005-W\u00061\u0001\u0002N\u0006QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005m\u0007\u0003BAo\u0003WtA!a8\u0002hB\u0019\u0011\u0011]-\u000e\u0005\u0005\r(bAAs+\u00061AH]8pizJ1!!;Z\u0003\u0019\u0001&/\u001a3fM&!\u0011Q^Ax\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011^-\u0002\u000f\rdW-\u00198feV\u0011\u0011Q\u001f\t\u0005\u0003W\t90C\u0002\u0002zF\u0013qa\u00117fC:,'/\u0001\u0005dY\u0016\fg.\u001a:!\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0003\u0002A!\u00111\u0006B\u0002\u0013\r\u0011)!\u0015\u0002\r\u00072,\u0017M\\3s'R\fGo]\u0001\u000eY\u0006\u001cHo\u0015;biN|F%Z9\u0015\t\u0005]$1\u0002\u0005\n\u0003\u007f\u0012\u0014\u0011!a\u0001\u0005\u0003\t!\u0002\\1tiN#\u0018\r^:!Q\r\u0019\u0014QQ\u0001\u0012Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cXC\u0001B\u000b!\u0011\tYCa\u0006\n\u0007\te\u0011KA\u0007Qe\u0016\u001cE.Z1o'R\fGo]\u0001\u0016Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001cx\fJ3r)\u0011\t9Ha\b\t\u0013\u0005}T'!AA\u0002\tU\u0011A\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ug\u0002B3ANAC\u0003%\u0019\u0007.Z2l\t>tW\r\u0006\u0003\u0002x\t%\u0002b\u0002B\u0016o\u0001\u0007\u0011QD\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019!wnV8sWR\u0011\u0011qO\u0001\u0015iJL8\t\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4\u0015\u0005\tU\u0002c\u0001-\u00038%\u0019!\u0011H-\u0003\u000f\t{w\u000e\\3b]\u0006\t2\r\\3b]\u001aKG\u000e\u001e5jKN$Hj\\4)\u000bi\u0012yDa\u0013\u0011\u000ba\u0013\tE!\u0012\n\u0007\t\r\u0013L\u0001\u0004uQJ|wo\u001d\t\u0005\u0003W\u00119%C\u0002\u0003JE\u0013A\u0003T8h\u00072,\u0017M\\5oO\u0016C8-\u001a9uS>t7E\u0001B#\u0003!\u0019G.Z1o\u0019><G\u0003BA<\u0005#BqAa\u0015<\u0001\u0004\u0011)&A\u0005dY\u0016\fg.\u00192mKB!\u00111\u0006B,\u0013\r\u0011I&\u0015\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u0003:fG>\u0014Hm\u0015;biN$B\"a\u001e\u0003`\t\r$q\rB9\u0005kBqA!\u0019=\u0001\u0004\ti-\u0001\u0002jI\"9!Q\r\u001fA\u0002\u0005m\u0017\u0001\u00028b[\u0016DqA!\u001b=\u0001\u0004\u0011Y'\u0001\u0003ge>l\u0007c\u0001-\u0003n%\u0019!qN-\u0003\t1{gn\u001a\u0005\b\u0005gb\u0004\u0019\u0001B6\u0003\t!x\u000eC\u0004\u0003xq\u0002\rA!\u0001\u0002\u000bM$\u0018\r^:\u0002\u0013\rdW-\u00198feN\u0004\u0013!F7bq>3XM]\"mK\u0006tWM\u001d+ie\u0016\fGm\u001d\u000b\u0005\u0003\u001b\u0014y\bC\u0004\u0003\u0002V\u0001\rAa!\u0002\u0003\u0019\u0004r\u0001\u0017BC\u0003o\u0013I)C\u0002\u0003\bf\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007a\u0013Y)C\u0002\u0003\u000ef\u0013a\u0001R8vE2,\u0017a\u00043fC\u0012$\u0006N]3bI\u000e{WO\u001c;\u0016\u0005\u00055\u0017aB:uCJ$X\u000f]\u0001\u0011g\",H\u000fZ8x]\u000ecW-\u00198feN\f\u0001b\u001d5vi\u0012|wO\\\u0001\u000ee\u0016lwN^3NKR\u0014\u0018nY:\u0002+I,7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!q\u0014\t\u0006w\n\u0005\u00161\\\u0005\u0004\u0005Gc(aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003o\u0012I\u000bC\u0004\u0003,r\u0001\rA!,\u0002\u00139,woQ8oM&<\u0007c\u00013\u00030&\u0019!\u0011W3\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002x\t]&1\u0018\u0005\b\u0005sk\u0002\u0019\u0001BW\u0003%yG\u000eZ\"p]\u001aLw\rC\u0004\u0003,v\u0001\rA!,\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\t9H!1\t\u000f\t-b\u00041\u0001\u0002\u001e\u0005\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\r\u0005]$q\u0019Bf\u0011\u001d\u0011Im\ba\u0001\u0003\u0003\tq\u0001Z1uC\u0012K'\u000fC\u0005\u0003N~\u0001\n\u00111\u0001\u0003P\u0006\t\u0002/\u0019:uSRLwN\u001c+p%\u0016lwN^3\u0011\u000ba\u0013\t.!\b\n\u0007\tM\u0017L\u0001\u0004PaRLwN\\\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\te'\u0006\u0002Bh\u00057\\#A!8\u0011\t\t}'\u0011^\u0007\u0003\u0005CTAAa9\u0003f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005OL\u0016AC1o]>$\u0018\r^5p]&!!1\u001eBq\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002x\tE(1\u001fB|\u0011\u001d\u0011Y#\ta\u0001\u0003;AqA!>\"\u0001\u0004\t\t!\u0001\u0007t_V\u00148-\u001a'pO\u0012K'\u000fC\u0004\u0003z\u0006\u0002\r!!\u0001\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002x\t}\bbBB\u0001E\u0001\u0007\u00111\\\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t9ha\u0002\u0004\n\r-\u0001b\u0002BeG\u0001\u0007\u0011\u0011\u0001\u0005\b\u0005W\u0019\u0003\u0019AA\u000f\u0011\u001d\u0019ia\ta\u0001\u0005W\naa\u001c4gg\u0016$\u0018!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003o\u001a\u0019\u0002C\u0004\u0003,\u0011\u0002\r!!\b\u0002\u001dI,7/^7f\u00072,\u0017M\\5oOR!\u0011qOB\r\u0011\u001d\u0019Y\"\na\u0001\u0007;\tq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006w\u000e}\u0011QD\u0005\u0004\u0007Ca(\u0001C%uKJ\f'\r\\3\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0011\tU2qEB\u0015\u0007WAqAa\u000b'\u0001\u0004\ti\u0002C\u0004\u0004\u000e\u0019\u0002\rAa\u001b\t\u0013\r5b\u0005%AA\u0002\t-\u0014!C7bq^\u000b\u0017\u000e^'t\u0003Y\tw/Y5u\u00072,\u0017M\\3eI\u0011,g-Y;mi\u0012\u001aTCAB\u001aU\u0011\u0011YGa7\u0002MA\fWo]3DY\u0016\fg.\u001b8h\r>\u0014hj\u001c8D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0004:A)1pa\b\u0004<A9\u0001l!\u0010\u0002\u001e\u0005%\u0012bAB 3\n1A+\u001e9mKJ\nQbY;se\u0016tGoQ8oM&<\u0017\u0001D2mK\u0006tWM]\"pk:$\u0018A\u0003'pO\u000ecW-\u00198feB\u0019\u00111\u0006 \u0014\u0005y:FCAB$\u0003U\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\u000eG2,\u0017M\\3s\u0007>tg-[4\u0015\u0007)\u001c)\u0006C\u0004\u0002p\t\u0003\rA!,\u0002K5\u000b\u0007PQ;gM\u0016\u0014X\u000b^5mSj\fG/[8o!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,WCAB.!\u0011\u0019ifa\u0019\u000e\u0005\r}#\u0002BB1\u0003\u0013\tA\u0001\\1oO&!\u0011Q^B0\u0003\u0019j\u0015\r\u001f\"vM\u001a,'/\u0016;jY&T\u0018\r^5p]B+'oY3oi6+GO]5d\u001d\u0006lW\rI\u0001\u001f\u00072,\u0017M\\3s%\u0016\u001cw\u000e]=QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\fqd\u00117fC:,'OU3d_BL\b+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0003Yi\u0015\r_\"mK\u0006tG+[7f\u001b\u0016$(/[2OC6,\u0017aF'bq\u000ecW-\u00198US6,W*\u001a;sS\u000et\u0015-\\3!\u0003ui\u0015\r_\"p[B\f7\r^5p]\u0012+G.Y=NKR\u0014\u0018nY:OC6,\u0017AH'bq\u000e{W\u000e]1di&|g\u000eR3mCflU\r\u001e:jGNt\u0015-\\3!\u0003e!U-\u00193UQJ,\u0017\rZ\"pk:$X*\u001a;sS\u000et\u0015-\\3\u00025\u0011+\u0017\r\u001a+ie\u0016\fGmQ8v]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002\u00175+GO]5d\u001d\u0006lWm]\u000b\u0003\u0007w\u0002Ra\u001fBQ\u00077\nA\"T3ue&\u001cg*Y7fg\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCABBU\u0011\t\tEa7")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    private void shutdownCleaners() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    public void shutdown() {
        try {
            this.shutdownCleaners();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdownCleaners();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public static final /* synthetic */ int $anonfun$new$1(LogCleaner $this) {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)$this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleaner $this) {
        ArrayBuffer stats = (ArrayBuffer)$this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public static final /* synthetic */ int $anonfun$new$7(LogCleaner $this) {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)$this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public static final /* synthetic */ int $anonfun$new$9(LogCleaner $this) {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)$this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) / 1000;
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxBufferUtilizationPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$1(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$3(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCleanTimeMetricName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$7(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCompactionDelayMetricsName(), () -> BoxesRunTime.boxToInteger((int)LogCleaner.$anonfun$new$9(this)));
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), () -> BoxesRunTime.boxToInteger((int)this.deadThreadCount()));
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

