/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.ControllerDynamicThreadPool;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicClientQuotaCallback;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicProducerStateManagerConfig;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.security.PasswordEncoder;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.ClientMetricsReceiverPlugin;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0011}s!B.]\u0011\u0003\tg!B2]\u0011\u0003!\u0007\"B6\u0002\t\u0003a\u0007\u0002C7\u0002\u0005\u0004%\t\u0001\u00188\t\r}\f\u0001\u0015!\u0003p\u0011)\t\t!\u0001b\u0001\n\u0003a\u00161\u0001\u0005\t\u0003\u0017\t\u0001\u0015!\u0003\u0002\u0006!A\u0011QB\u0001C\u0002\u0013\u0005a\u000eC\u0004\u0002\u0010\u0005\u0001\u000b\u0011B8\t\u0013\u0005E\u0011A1A\u0005\n\u0005\r\u0001\u0002CA\n\u0003\u0001\u0006I!!\u0002\t\u0011\u0005U\u0011A1A\u0005\n9Dq!a\u0006\u0002A\u0003%q\u000eC\u0005\u0002\u001a\u0005\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111D\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u001e\u0005\u0011\r\u0011\"\u0003\u0002\u0004!A\u0011qD\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\"\u0005\u0011\r\u0011\"\u0001\u0002$!A\u0011QG\u0001!\u0002\u0013\t)\u0003\u0003\u0005\u00028\u0005\u0011\r\u0011\"\u0003o\u0011\u001d\tI$\u0001Q\u0001\n=Dq!a\u000f\u0002\t\u0003\ti\u0004C\u0004\u0002^\u0005!\t!a\u0018\t\u000f\u0005e\u0014\u0001\"\u0001\u0002|!9\u0011QS\u0001\u0005\n\u0005]\u0005bBAO\u0003\u0011%\u0011q\u0014\u0005\b\u0003G\u000bA\u0011BAS\u0011\u001d\tI+\u0001C\u0005\u0003WC\u0001\"a,\u0002\t\u0003a\u0016\u0011\u0017\u0005\t\u0003#\fA\u0011\u0001/\u0002T\"A\u00111\\\u0001\u0005\u0002q\u000biNB\u0003d9\u0002\t\u0019\u000f\u0003\u0006\u0002r~\u0011)\u0019!C\u0005\u0003gD!\"a? \u0005\u0003\u0005\u000b\u0011BA{\u0011\u0019Yw\u0004\"\u0001\u0002~\"Q!1A\u0010C\u0002\u0013\u0005AL!\u0002\t\u0011\t-q\u0004)A\u0005\u0005\u000fA!B!\u0004 \u0005\u0004%\t\u0001\u0018B\u0003\u0011!\u0011ya\bQ\u0001\n\t\u001d\u0001\"\u0003B\t?\t\u0007I\u0011\u0002B\n\u0011!\u00119b\bQ\u0001\n\tU\u0001\"\u0003B\r?\t\u0007I\u0011\u0002B\n\u0011!\u0011Yb\bQ\u0001\n\tU\u0001B\u0003B\u000f?\t\u0007I\u0011\u0001/\u0003 !A!QG\u0010!\u0002\u0013\u0011\t\u0003C\u0005\u00038}\u0011\r\u0011\"\u0003\u0003:!A!1I\u0010!\u0002\u0013\u0011Y\u0004C\u0005\u0003F}\u0011\r\u0011\"\u0003\u0003H!A!QK\u0010!\u0002\u0013\u0011I\u0005C\u0006\u0003X}\u0001\r\u00111A\u0005\n\te\u0003b\u0003B8?\u0001\u0007\t\u0019!C\u0005\u0005cB1Ba\u001e \u0001\u0004\u0005\t\u0015)\u0003\u0003\\!Y!\u0011P\u0010A\u0002\u0003\u0007I\u0011BAz\u0011-\u0011Yh\ba\u0001\u0002\u0004%IA! \t\u0017\t\u0005u\u00041A\u0001B\u0003&\u0011Q\u001f\u0005\n\u0005\u0007{\"\u0019!C\u0005\u0005\u000bC\u0001B!& A\u0003%!q\u0011\u0005\t\u0005/{B\u0011\u0001/\u0003\u001a\"A!\u0011W\u0010\u0005\u0002q\u0013\u0019\fC\u0004\u00036~!\tAa.\t\u000f\tUv\u0004\"\u0001\u0003D\"9!qZ\u0010\u0005\u0002\tE\u0007b\u0002Bl?\u0011\u0005!\u0011\u001c\u0005\b\u0005;|B\u0011\u0001Bp\u0011\u001d\u0011\u0019o\bC\u0005\u0005KD\u0001Ba; \t\u0003a\u00161\u001f\u0005\t\u0005[|B\u0011\u0001/\u0003p\"A!Q_\u0010\u0005\u0002q\u0013y\u000f\u0003\u0005\u0003x~!\t\u0001\u0018B-\u0011!\u0011Ip\bC\u00019\nm\bBCB\b?E\u0005I\u0011\u0001/\u0004\u0012!A1qE\u0010\u0005\u0002q\u001bI\u0003\u0003\u0006\u00040}\t\n\u0011\"\u0001]\u0007#A\u0001b!\r \t\u0003a61\u0007\u0005\b\u0007syB\u0011BB\u001e\u0011\u001d\u0019ye\bC\u0005\u0007#B\u0001ba\u0015 \t\u0003a6Q\u000b\u0005\t\u0007;zB\u0011\u0001/\u0004`!91QM\u0010\u0005\n\r\u001d\u0004bBB;?\u0011%1q\u000f\u0005\t\u0007\u007fzB\u0011\u0001/\u0004\u0002\"91qQ\u0010\u0005\n\r%\u0005\u0002CBH?\u0011\u0005Al!%\t\u000f\r]v\u0004\"\u0003\u0004:\"91Q]\u0010\u0005\n\r\u001d\bbBBw?\u0011%1q\u001e\u0005\b\u0007g|B\u0011BB{\u0011%!\u0019aHI\u0001\n\u0013\u0019\t\u0002C\u0004\u0005\u0006}!I\u0001b\u0002\t\u000f\u0011eq\u0004\"\u0003\u0005\u001c!9A\u0011I\u0010\u0005\n\u0011\r\u0013a\u0005#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<'BA/_\u0003\u0019\u0019XM\u001d<fe*\tq,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\t\fQ\"\u0001/\u0003'\u0011Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4\u0014\u0005\u0005)\u0007C\u00014j\u001b\u00059'\"\u00015\u0002\u000bM\u001c\u0017\r\\1\n\u0005)<'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\u00061B)\u001f8b[&\u001c7+Z2ve&$\u0018pQ8oM&<7/F\u0001p!\r\u0001Xo^\u0007\u0002c*\u0011!o]\u0001\b[V$\u0018M\u00197f\u0015\t!x-\u0001\u0006d_2dWm\u0019;j_:L!A^9\u0003\u0007M+G\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006!A.\u00198h\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A`=\u0003\rM#(/\u001b8h\u0003]!\u0015P\\1nS\u000e\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\b%A\u0011Es:\fW.[2Qe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-\u0006\u0002\u0002\u0006A)\u0011qAA\u0005o6\t1/\u0003\u0002wg\u0006\u0011C)\u001f8b[&\u001c\u0007K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\u001cuN\u001c4jO\u0002\n\u0011#\u00117m\tft\u0017-\\5d\u0007>tg-[4t\u0003I\tE\u000e\u001c#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u0011\u00027\rcWo\u001d;fe2+g/\u001a7MSN$XM\\3s\u0007>tg-[4t\u0003q\u0019E.^:uKJdUM^3m\u0019&\u001cH/\u001a8fe\u000e{gNZ5hg\u0002\n\u0001\u0003U3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0002#A+'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%\u0001\rMSN$XM\\3s\u001b\u0016\u001c\u0007.\u00198jg6\u001cuN\u001c4jON\f\u0011\u0004T5ti\u0016tWM]'fG\"\fg.[:n\u0007>tg-[4tA\u0005)\"+\u001a7pC\u0012\f'\r\\3GS2,7i\u001c8gS\u001e\u001c\u0018A\u0006*fY>\fG-\u00192mK\u001aKG.Z\"p]\u001aLwm\u001d\u0011\u0002'1K7\u000f^3oKJ\u001cuN\u001c4jOJ+w-\u001a=\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\t[\u0006$8\r[5oO*\u0019\u0011qF4\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003g\tICA\u0003SK\u001e,\u00070\u0001\u000bMSN$XM\\3s\u0007>tg-[4SK\u001e,\u0007\u0010I\u0001\u0017\tft\u0017-\\5d!\u0006\u001c8o^8sI\u000e{gNZ5hg\u00069B)\u001f8b[&\u001c\u0007+Y:to>\u0014HmQ8oM&<7\u000fI\u0001\u0011SN\u0004\u0016m]:x_J$7i\u001c8gS\u001e$B!a\u0010\u0002FA\u0019a-!\u0011\n\u0007\u0005\rsMA\u0004C_>dW-\u00198\t\u000f\u0005\u001dS\u00031\u0001\u0002J\u0005!a.Y7f!\u0011\tY%!\u0017\u000f\t\u00055\u0013Q\u000b\t\u0004\u0003\u001f:WBAA)\u0015\r\t\u0019\u0006Y\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]s-\u0001\u0004Qe\u0016$WMZ\u0005\u0004}\u0006m#bAA,O\u0006!\"M]8lKJ\u001cuN\u001c4jONKhn\u001c8z[N$b!!\u0019\u0002t\u0005U\u0004CBA2\u0003[\nIE\u0004\u0003\u0002f\u0005%d\u0002BA(\u0003OJ\u0011\u0001[\u0005\u0004\u0003W:\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003_\n\tH\u0001\u0003MSN$(bAA6O\"9\u0011q\t\fA\u0002\u0005%\u0003bBA<-\u0001\u0007\u0011qH\u0001\u0016[\u0006$8\r\u001b'jgR,g.\u001a:Pm\u0016\u0014(/\u001b3f\u0003=1\u0018\r\\5eCR,7i\u001c8gS\u001e\u001cHCBA?\u0003\u0007\u000b\t\nE\u0002g\u0003\u007fJ1!!!h\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015u\u00031\u0001\u0002\b\u0006)\u0001O]8qgB!\u0011\u0011RAG\u001b\t\tYIC\u0002\u00020mLA!a$\u0002\f\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005Mu\u00031\u0001\u0002@\u0005y\u0001/\u001a:Ce>\\WM]\"p]\u001aLw-\u0001\tqKJ\u0014%o\\6fe\u000e{gNZ5hgR!\u0011\u0011TAN!\u0019\t9!!\u0003\u0002J!9\u0011Q\u0011\rA\u0002\u0005\u001d\u0015!\u00058p]\u0012Kh.Y7jG\u000e{gNZ5hgR!\u0011\u0011TAQ\u0011\u001d\t))\u0007a\u0001\u0003\u000f\u000bAe]3dkJLG/_\"p]\u001aLwm],ji\"|W\u000f\u001e'jgR,g.\u001a:Qe\u00164\u0017\u000e\u001f\u000b\u0005\u00033\u000b9\u000bC\u0004\u0002\u0006j\u0001\r!a\"\u0002'Y\fG.\u001b3bi\u0016\u001cuN\u001c4jORK\b/Z:\u0015\t\u0005u\u0014Q\u0016\u0005\b\u0003\u000b[\u0002\u0019AAD\u0003E\tG\r\u001a#z]\u0006l\u0017nY\"p]\u001aLwm\u001d\u000b\u0005\u0003{\n\u0019\fC\u0004\u00026r\u0001\r!a.\u0002\u0013\r|gNZ5h\t\u00164\u0007\u0003BA]\u0003\u001bl!!a/\u000b\t\u0005u\u0016qX\u0001\u0007G>tg-[4\u000b\t\u0005\u0005\u00171Y\u0001\u0007G>lWn\u001c8\u000b\u0007}\u000b)M\u0003\u0003\u0002H\u0006%\u0017AB1qC\u000eDWM\u0003\u0002\u0002L\u0006\u0019qN]4\n\t\u0005=\u00171\u0018\u0002\n\u0007>tg-[4EK\u001a\f\u0001\u0004Z=oC6L7mQ8oM&<W\u000b\u001d3bi\u0016lu\u000eZ3t+\t\t)\u000e\u0005\u0005\u0002\n\u0006]\u0017\u0011JA%\u0013\u0011\tI.a#\u0003\u00075\u000b\u0007/\u0001\fsKN|GN^3WCJL\u0017M\u00197f\u0007>tg-[4t)\u0011\t9)a8\t\u000f\u0005\u0005h\u00041\u0001\u0002\b\u0006i\u0001O]8qg>\u0013\u0018nZ5oC2\u001cBaH3\u0002fB!\u0011q]Aw\u001b\t\tIOC\u0002\u0002lz\u000bQ!\u001e;jYNLA!a<\u0002j\n9Aj\\4hS:<\u0017aC6bM.\f7i\u001c8gS\u001e,\"!!>\u0011\u0007\t\f90C\u0002\u0002zr\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006a1.\u00194lC\u000e{gNZ5hAQ!\u0011q B\u0001!\t\u0011w\u0004C\u0004\u0002r\n\u0002\r!!>\u0002'M$\u0018\r^5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\t\u001d\u0001#\u00029\u0003\n]<\u0018bAAmc\u0006!2\u000f^1uS\u000e\u0014%o\\6fe\u000e{gNZ5hg\u0002\nAc\u001d;bi&\u001cG)\u001a4bk2$8i\u001c8gS\u001e\u001c\u0018!F:uCRL7\rR3gCVdGoQ8oM&<7\u000fI\u0001\u0015Ift\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:\u0016\u0005\tU\u0001c\u00029\u0003\n\u0005%\u0013\u0011J\u0001\u0016Ift\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ:!\u0003U!\u0017P\\1nS\u000e$UMZ1vYR\u001cuN\u001c4jON\fa\u0003Z=oC6L7\rR3gCVdGoQ8oM&<7\u000fI\u0001\u0010e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197fgV\u0011!\u0011\u0005\t\u0007\u0005G\u0011IC!\f\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0003\u0017\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\u0011YC!\n\u0003)\r{\u0007/_(o/JLG/Z!se\u0006LH*[:u!\u0011\u0011yC!\r\u000e\u0005\u0005}\u0016\u0002\u0002B\u001a\u0003\u007f\u0013aBU3d_:4\u0017nZ;sC\ndW-\u0001\tsK\u000e|gNZ5hkJ\f'\r\\3tA\u0005)\"M]8lKJ\u0014VmY8oM&<WO]1cY\u0016\u001cXC\u0001B\u001e!\u0019\u0011\u0019C!\u000b\u0003>A\u0019!Ma\u0010\n\u0007\t\u0005CL\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u0017EJ|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3tA\u0005!An\\2l+\t\u0011I\u0005\u0005\u0003\u0003L\tESB\u0001B'\u0015\u0011\u0011yE!\n\u0002\u000b1|7m[:\n\t\tM#Q\n\u0002\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW\u0006)An\\2lA\u0005AR.\u001a;sS\u000e\u001c(+Z2fSZ,'\u000f\u00157vO&tw\n\u001d;\u0016\u0005\tm\u0003#\u00024\u0003^\t\u0005\u0014b\u0001B0O\n1q\n\u001d;j_:\u0004BAa\u0019\u0003l5\u0011!Q\r\u0006\u0005\u0005O\u0012I'A\u0004nKR\u0014\u0018nY:\u000b\u0007u\u000b\u0019-\u0003\u0003\u0003n\t\u0015$aG\"mS\u0016tG/T3ue&\u001c7OU3dK&4XM\u001d)mk\u001eLg.\u0001\u000fnKR\u0014\u0018nY:SK\u000e,\u0017N^3s!2,x-\u001b8PaR|F%Z9\u0015\t\u0005u$1\u000f\u0005\n\u0005k\u0012\u0014\u0011!a\u0001\u00057\n1\u0001\u001f\u00132\u0003eiW\r\u001e:jGN\u0014VmY3jm\u0016\u0014\b\u000b\\;hS:|\u0005\u000f\u001e\u0011\u0002\u001b\r,(O]3oi\u000e{gNZ5h\u0003E\u0019WO\u001d:f]R\u001cuN\u001c4jO~#S-\u001d\u000b\u0005\u0003{\u0012y\bC\u0005\u0003vU\n\t\u00111\u0001\u0002v\u0006q1-\u001e:sK:$8i\u001c8gS\u001e\u0004\u0013\u0001\b3z]\u0006l\u0017nY\"p]\u001aLw\rU1tg^|'\u000fZ#oG>$WM]\u000b\u0003\u0005\u000f\u0003RA\u001aB/\u0005\u0013\u0003BAa#\u0003\u00126\u0011!Q\u0012\u0006\u0005\u0005\u001f\u000b\u0019-\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\u0011\u0019J!$\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJ\fQ\u0004Z=oC6L7mQ8oM&<\u0007+Y:to>\u0014H-\u00128d_\u0012,'\u000fI\u0001\u000bS:LG/[1mSj,GCBA?\u00057\u0013i\u000bC\u0004\u0003\u001ef\u0002\rAa(\u0002\u0017i\\7\t\\5f]R|\u0005\u000f\u001e\t\u0006M\nu#\u0011\u0015\t\u0005\u0005G\u0013I+\u0004\u0002\u0003&*\u0019!q\u00150\u0002\u0005i\\\u0017\u0002\u0002BV\u0005K\u0013QbS1gW\u0006T6n\u00117jK:$\bb\u0002BXs\u0001\u0007!1L\u0001\u001fG2LWM\u001c;NKR\u0014\u0018nY:SK\u000e,\u0017N^3s!2,x-\u001b8PaR\fQa\u00197fCJ$\"!! \u0002%\u0005$GMU3d_:4\u0017nZ;sC\ndWm\u001d\u000b\u0005\u0003{\u0012I\fC\u0004\u0003<n\u0002\rA!0\u0002\u0017-\fgm[1TKJ4XM\u001d\t\u0004E\n}\u0016b\u0001Ba9\nY1*\u00194lC\n\u0013xn[3s)\u0011\tiH!2\t\u000f\t\u001dG\b1\u0001\u0003J\u0006Q1m\u001c8ue>dG.\u001a:\u0011\u0007\t\u0014Y-C\u0002\u0003Nr\u0013\u0001cQ8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0002#\u0005$GMU3d_:4\u0017nZ;sC\ndW\r\u0006\u0003\u0002~\tM\u0007b\u0002Bk{\u0001\u0007!QF\u0001\u000fe\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003]\tG\r\u001a\"s_.,'OU3d_:4\u0017nZ;sC\ndW\r\u0006\u0003\u0002~\tm\u0007b\u0002Bk}\u0001\u0007!QH\u0001\u0015e\u0016lwN^3SK\u000e|gNZ5hkJ\f'\r\\3\u0015\t\u0005u$\u0011\u001d\u0005\b\u0005+|\u0004\u0019\u0001B\u0017\u0003m1XM]5gsJ+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgR!\u0011Q\u0010Bt\u0011\u001d\u0011I\u000f\u0011a\u0001\u00033\u000b1bY8oM&<g*Y7fg\u0006\u00112-\u001e:sK:$8*\u00194lC\u000e{gNZ5h\u0003m\u0019WO\u001d:f]R$\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5hgV\u0011!\u0011\u001f\t\t\u0003\u000f\u0011\u00190!\u0013\u0002J%\u0019\u0011\u0011\\:\u00029\r,(O]3oi\u0012Kh.Y7jG\u0012+g-Y;mi\u000e{gNZ5hg\u0006Y2\r\\5f]RlU\r\u001e:jGN\u0014VmY3jm\u0016\u0014\b\u000b\\;hS:\f!#\u001e9eCR,'I]8lKJ\u001cuN\u001c4jORA\u0011Q\u0010B\u007f\u0007\u000f\u0019Y\u0001C\u0004\u0003\u0000\u0016\u0003\ra!\u0001\u0002\u0011\t\u0014xn[3s\u0013\u0012\u00042AZB\u0002\u0013\r\u0019)a\u001a\u0002\u0004\u0013:$\bbBB\u0005\u000b\u0002\u0007\u0011qQ\u0001\u0010a\u0016\u00148/[:uK:$\bK]8qg\"I1QB#\u0011\u0002\u0003\u0007\u0011qH\u0001\u0006I>dunZ\u0001\u001dkB$\u0017\r^3Ce>\\WM]\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019\u0019B\u000b\u0003\u0002@\rU1FAB\f!\u0011\u0019Iba\t\u000e\u0005\rm!\u0002BB\u000f\u0007?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u0005r-\u0001\u0006b]:|G/\u0019;j_:LAa!\n\u0004\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002'U\u0004H-\u0019;f\t\u00164\u0017-\u001e7u\u0007>tg-[4\u0015\r\u0005u41FB\u0017\u0011\u001d\u0019Ia\u0012a\u0001\u0003\u000fC\u0011b!\u0004H!\u0003\u0005\r!a\u0010\u0002;U\u0004H-\u0019;f\t\u00164\u0017-\u001e7u\u0007>tg-[4%I\u00164\u0017-\u001e7uII\nQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\t\u0005u4Q\u0007\u0005\b\u0007oI\u0005\u0019AAD\u0003!qWm\u001e)s_B\u001c\u0018AG7bs\n,7I]3bi\u0016\u0004\u0016m]:x_J$WI\\2pI\u0016\u0014H\u0003\u0002BD\u0007{Aqaa\u0010K\u0001\u0004\u0019\t%\u0001\u0004tK\u000e\u0014X\r\u001e\t\u0006M\nu31\t\t\u0005\u0007\u000b\u001aY%\u0004\u0002\u0004H)!1\u0011JA^\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0019iea\u0012\u0003\u0011A\u000b7o]<pe\u0012\fq\u0002]1tg^|'\u000fZ#oG>$WM]\u000b\u0003\u0005\u0013\u000b\u0011\u0003^8QKJ\u001c\u0018n\u001d;f]R\u0004&o\u001c9t)\u0019\t9ia\u0016\u0004\\!91\u0011\f'A\u0002\u0005\u001d\u0015aC2p]\u001aLw\r\u0015:paNDq!a%M\u0001\u0004\ty$A\nge>l\u0007+\u001a:tSN$XM\u001c;Qe>\u00048\u000f\u0006\u0004\u0002\b\u000e\u000541\r\u0005\b\u0007\u0013i\u0005\u0019AAD\u0011\u001d\t\u0019*\u0014a\u0001\u0003\u007f\ta#\\1zE\u0016\u0014V-\u00128d_\u0012,\u0007+Y:to>\u0014Hm\u001d\u000b\u0007\u0003\u000f\u001bIga\u001b\t\u000f\r%a\n1\u0001\u0002\b\"91Q\u000e(A\u0002\r=\u0014!D1e[&t'l[\"mS\u0016tG\u000f\u0005\u0003\u0003$\u000eE\u0014\u0002BB:\u0005K\u0013Q\"\u00113nS:T6n\u00117jK:$\u0018a\u0005<bY&$\u0017\r^3e\u0017\u000647.\u0019)s_B\u001cHC\u0002By\u0007s\u001ai\bC\u0004\u0004|=\u0003\r!a\"\u0002\u001bA\u0014x\u000e]:Pm\u0016\u0014(/\u001b3f\u0011\u001d\t\u0019j\u0014a\u0001\u0003\u007f\t\u0001B^1mS\u0012\fG/\u001a\u000b\u0007\u0003{\u001a\u0019i!\"\t\u000f\u0005\u0015\u0005\u000b1\u0001\u0002\b\"9\u00111\u0013)A\u0002\u0005}\u0012\u0001\u0006:f[>4X-\u00138wC2LGmQ8oM&<7\u000f\u0006\u0004\u0002~\r-5Q\u0012\u0005\b\u0003\u000b\u000b\u0006\u0019AAD\u0011\u001d\t\u0019*\u0015a\u0001\u0003\u007f\t\u0001#\\1zE\u0016\u0014VmY8oM&<WO]3\u0015\u0011\u0005u41SBK\u00073CqA!6S\u0001\u0004\u0011i\u0003C\u0004\u0004\u0018J\u0003\r!!>\u0002\u0013=dGmQ8oM&<\u0007bBBN%\u0002\u00071QT\u0001\n]\u0016<8i\u001c8gS\u001e\u0004Daa(\u0004&BA\u0011\u0011RAl\u0003\u0013\u001a\t\u000b\u0005\u0003\u0004$\u000e\u0015F\u0002\u0001\u0003\r\u0007O\u001bI*!A\u0001\u0002\u000b\u00051\u0011\u0016\u0002\u0004?\u0012\n\u0014\u0003BBV\u0007c\u00032AZBW\u0013\r\u0019yk\u001a\u0002\b\u001d>$\b.\u001b8h!\r171W\u0005\u0004\u0007k;'aA!os\u0006qQ\u000f\u001d3bi\u0016$7i\u001c8gS\u001e\u001cHCBB^\u0007\u0017\u001c9\u000eE\u0004g\u0007{\u001b\t-!'\n\u0007\r}vM\u0001\u0004UkBdWM\r\u0019\u0005\u0007\u0007\u001c9\rE\u0004q\u0005\u0013\tIe!2\u0011\t\r\r6q\u0019\u0003\f\u0007\u0013\u001c\u0016\u0011!A\u0001\u0006\u0003\u0019IKA\u0002`IQBqaa\u000eT\u0001\u0004\u0019i\r\r\u0003\u0004P\u000eM\u0007\u0003CAE\u0003/\fIe!5\u0011\t\r\r61\u001b\u0003\r\u0007+\u001cY-!A\u0001\u0002\u000b\u00051\u0011\u0016\u0002\u0004?\u0012\u0012\u0004bBBm'\u0002\u000711\\\u0001\rGV\u0014(/\u001a8u!J|\u0007o\u001d\u0019\u0005\u0007;\u001c\t\u000f\u0005\u0005\u0002\n\u0006]\u0017\u0011JBp!\u0011\u0019\u0019k!9\u0005\u0019\r\r8q[A\u0001\u0002\u0003\u0015\ta!+\u0003\u0007}#3'A\u0007pm\u0016\u0014(/\u001b3f!J|\u0007o\u001d\u000b\u0007\u0003{\u001aIoa;\t\u000f\u0005\u0015E\u000b1\u0001\u0003\u0016!911\u0010+A\u0002\tU\u0011aE;qI\u0006$XmQ;se\u0016tGoQ8oM&<G\u0003BA?\u0007cDqa!\u0004V\u0001\u0004\ty$\u0001\fqe>\u001cWm]:SK\u000e|gNZ5hkJ\fG/[8o)!\u00199pa?\u0004~\u0012\u0005\u0001c\u00024\u0004>\u0006U8\u0011 \t\u0007\u0003G\niG!\u0010\t\u000f\r]b\u000b1\u0001\u0003r\"91q ,A\u0002\u0005}\u0012\u0001\u0004<bY&$\u0017\r^3P]2L\b\"CB\u0007-B\u0005\t\u0019AA \u0003\u0001\u0002(o\\2fgN\u0014VmY8oM&<WO]1uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0002)9,W\rZ:SK\u000e|gNZ5hkJ\fG/[8o)!\ty\u0004\"\u0003\u0005\u0012\u0011U\u0001b\u0002C\u00061\u0002\u0007AQB\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t!\u0019\tI\tb\u0004\u0002J%\u0019a/a#\t\u000f\u0011M\u0001\f1\u0001\u0002\u001a\u0006YQ\u000f\u001d3bi\u0016$7*Z=t\u0011\u001d!9\u0002\u0017a\u0001\u00033\u000b1\u0002Z3mKR,GmS3zg\u0006i\u0002O]8dKN\u001cH*[:uK:,'OU3d_:4\u0017nZ;sC\ndW\r\u0006\u0007\u0002~\u0011uAQ\u0006C\u0018\tw!i\u0004C\u0004\u0005 e\u0003\r\u0001\"\t\u0002-1L7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016\u0004B\u0001b\t\u0005*5\u0011AQ\u0005\u0006\u0005\tO\ty,A\u0004oKR<xN]6\n\t\u0011-BQ\u0005\u0002\u0017\u0019&\u001cH/\u001a8feJ+7m\u001c8gS\u001e,(/\u00192mK\"911T-A\u0002\u0005U\bb\u0002C\u00193\u0002\u0007A1G\u0001\u000eGV\u001cHo\\7D_:4\u0017nZ:\u0011\u0011\u0005%\u0015q[A%\tk\u00012\u0001\u001fC\u001c\u0013\r!I$\u001f\u0002\u0007\u001f\nTWm\u0019;\t\u000f\r}\u0018\f1\u0001\u0002@!9AqH-A\u0002\u0005}\u0012A\u0003:fY>\fGm\u00148ms\u0006)\u0002O]8dKN\u001c(+Z2p]\u001aLw-\u001e:bE2,G\u0003DA?\t\u000b\"9\u0005b\u0013\u0005Z\u0011u\u0003b\u0002Bk5\u0002\u0007!Q\u0006\u0005\b\t\u0013R\u0006\u0019AAM\u0003I)\b\u000fZ1uK\u0012\u001cuN\u001c4jO:\u000bW.Z:\t\u000f\u00115#\f1\u0001\u0005P\u0005i\u0011\r\u001c7OK^\u001cuN\u001c4jON\u0004D\u0001\"\u0015\u0005VAA\u0011\u0011RAl\u0003\u0013\"\u0019\u0006\u0005\u0003\u0004$\u0012UC\u0001\u0004C,\t\u0017\n\t\u0011!A\u0003\u0002\r%&aA0%k!9A1\f.A\u0002\u0011M\u0012\u0001\u00058fo\u000e+8\u000f^8n\u0007>tg-[4t\u0011\u001d\u0019yP\u0017a\u0001\u0003\u007f\u0001")
public class DynamicBrokerConfig
implements Logging {
    private final KafkaConfig kafkaConfig;
    private final scala.collection.mutable.Map<String, String> staticBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> staticDefaultConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicBrokerConfigs;
    private final scala.collection.mutable.Map<String, String> dynamicDefaultConfigs;
    private final CopyOnWriteArrayList<Reconfigurable> reconfigurables;
    private final CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables;
    private final ReentrantReadWriteLock lock;
    private Option<ClientMetricsReceiverPlugin> metricsReceiverPluginOpt;
    private KafkaConfig currentConfig;
    private final Option<PasswordEncoder> dynamicConfigPasswordEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void validateConfigs(Properties properties, boolean bl) {
        DynamicBrokerConfig$.MODULE$.validateConfigs(properties, bl);
    }

    public static List<String> brokerConfigSynonyms(String string, boolean bl) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, bl);
    }

    public static boolean isPasswordConfig(String string) {
        return DynamicBrokerConfig$.MODULE$.isPasswordConfig(string);
    }

    public static Regex ListenerConfigRegex() {
        return DynamicBrokerConfig$.MODULE$.ListenerConfigRegex();
    }

    public static scala.collection.mutable.Set<String> AllDynamicConfigs() {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    public scala.collection.mutable.Map<String, String> staticBrokerConfigs() {
        return this.staticBrokerConfigs;
    }

    public scala.collection.mutable.Map<String, String> staticDefaultConfigs() {
        return this.staticDefaultConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicBrokerConfigs() {
        return this.dynamicBrokerConfigs;
    }

    private scala.collection.mutable.Map<String, String> dynamicDefaultConfigs() {
        return this.dynamicDefaultConfigs;
    }

    public CopyOnWriteArrayList<Reconfigurable> reconfigurables() {
        return this.reconfigurables;
    }

    private CopyOnWriteArrayList<BrokerReconfigurable> brokerReconfigurables() {
        return this.brokerReconfigurables;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private Option<ClientMetricsReceiverPlugin> metricsReceiverPluginOpt() {
        return this.metricsReceiverPluginOpt;
    }

    private void metricsReceiverPluginOpt_$eq(Option<ClientMetricsReceiverPlugin> x$1) {
        this.metricsReceiverPluginOpt = x$1;
    }

    private KafkaConfig currentConfig() {
        return this.currentConfig;
    }

    private void currentConfig_$eq(KafkaConfig x$1) {
        this.currentConfig = x$1;
    }

    private Option<PasswordEncoder> dynamicConfigPasswordEncoder() {
        return this.dynamicConfigPasswordEncoder;
    }

    public void initialize(Option<KafkaZkClient> zkClientOpt, Option<ClientMetricsReceiverPlugin> clientMetricsReceiverPluginOpt) {
        this.currentConfig_$eq(new KafkaConfig(this.kafkaConfig().props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$));
        this.metricsReceiverPluginOpt_$eq(clientMetricsReceiverPluginOpt);
        zkClientOpt.foreach((Function1 & Serializable & scala.Serializable)zkClient -> {
            DynamicBrokerConfig.$anonfun$initialize$1(this, zkClient);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.dynamicBrokerConfigs().clear();
        this.dynamicDefaultConfigs().clear();
        this.reconfigurables().clear();
        this.brokerReconfigurables().clear();
    }

    public void addReconfigurables(KafkaBroker kafkaServer) {
        Authorizer authz;
        Option<Authorizer> option = kafkaServer.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        this.addReconfigurable((Reconfigurable)kafkaServer.kafkaYammerMetrics());
        this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().brokerId(), kafkaServer.config(), kafkaServer.metrics(), kafkaServer.clusterId()));
        this.addReconfigurable(new DynamicClientQuotaCallback(kafkaServer.quotaManagers(), kafkaServer.config()));
        this.addBrokerReconfigurable(new BrokerDynamicThreadPool(kafkaServer));
        this.addBrokerReconfigurable(new DynamicLogConfig(kafkaServer.logManager(), kafkaServer));
        this.addBrokerReconfigurable(new DynamicListenerConfig(kafkaServer));
        this.addBrokerReconfigurable(kafkaServer.socketServer());
        this.addBrokerReconfigurable(new DynamicProducerStateManagerConfig(kafkaServer.logManager().producerStateManagerConfig()));
        this.addBrokerReconfigurable(new DynamicRemoteLogConfig(kafkaServer));
    }

    public void addReconfigurables(ControllerServer controller) {
        Authorizer authz;
        Option<Authorizer> option = controller.authorizer();
        if (option instanceof Some && (authz = (Authorizer)((Some)option).value()) instanceof Reconfigurable) {
            this.addReconfigurable((Reconfigurable)authz);
        }
        if (!this.kafkaConfig().processRoles().contains((Object)ProcessRole.BrokerRole)) {
            this.addReconfigurable((Reconfigurable)controller.kafkaYammerMetrics());
            this.addReconfigurable(new DynamicMetricsReporters(this.kafkaConfig().nodeId(), controller.config(), controller.metrics(), controller.clusterId()));
        }
        this.addReconfigurable(new DynamicClientQuotaCallback(controller.quotaManagers(), controller.config()));
        this.addBrokerReconfigurable(new ControllerDynamicThreadPool(controller));
        this.addBrokerReconfigurable(controller.socketServer());
    }

    /*
     * WARNING - void declaration
     */
    public void addReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBrokerReconfigurable(BrokerReconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$addBrokerReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeReconfigurable(Reconfigurable reconfigurable) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$removeReconfigurable$1(this, reconfigurable);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyReconfigurableConfigs(Set<String> configNames) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$1(configNames);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public KafkaConfig currentKafkaConfig() {
        KafkaConfig kafkaConfig;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            kafkaConfig = this.currentConfig();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return kafkaConfig;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicBrokerConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicBrokerConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> currentDynamicDefaultConfigs() {
        scala.collection.mutable.Map map;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            map = DynamicBrokerConfig.$anonfun$currentDynamicDefaultConfigs$1(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<ClientMetricsReceiverPlugin> clientMetricsReceiverPlugin() {
        Option option;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            option = this.metricsReceiverPluginOpt();
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void updateBrokerConfig(int brokerId, Properties persistentProps, boolean doLog) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateBrokerConfig$1(this, persistentProps, doLog, brokerId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateBrokerConfig$default$3() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void updateDefaultConfig(Properties persistentProps, boolean doLog) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$updateDefaultConfig$1(this, persistentProps, doLog);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public boolean updateDefaultConfig$default$2() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void reloadUpdatedFilesWithoutConfigChange(Properties newProps) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$1(this, newProps);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private Option<PasswordEncoder> maybeCreatePasswordEncoder(Option<Password> secret2) {
        return secret2.map((Function1 & Serializable & scala.Serializable)secret -> PasswordEncoder.encrypting((Password)secret, (String)this.kafkaConfig().passwordEncoderKeyFactoryAlgorithm(), (String)this.kafkaConfig().passwordEncoderCipherAlgorithm(), (int)Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderKeyLength()), (int)Predef$.MODULE$.Integer2int(this.kafkaConfig().passwordEncoderIterations())));
    }

    private PasswordEncoder passwordEncoder() {
        return (PasswordEncoder)this.dynamicConfigPasswordEncoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ConfigException("Password encoder secret not configured");
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties toPersistentProps(Properties configProps, boolean perBrokerConfig) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)configProps.clone();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$toPersistentProps$1(this, perBrokerConfig, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configProps).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public Properties fromPersistentProps(Properties persistentProps, boolean perBrokerConfig) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = (Properties)persistentProps.clone();
        this.removeInvalidConfigs(props, perBrokerConfig);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$nonDynamicConfigs(props), "Non-dynamic configs configured in ZooKeeper will be ignored", props);
        this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$securityConfigsWithoutListenerPrefix(props), "Security configs can be dynamically updated only using listener prefix, base configs will be ignored", props);
        if (!perBrokerConfig) {
            this.removeInvalidProps$1(DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$perBrokerConfigs(props), "Per-broker configs defined at default cluster level will be ignored", props);
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> {
            DynamicBrokerConfig.$anonfun$fromPersistentProps$5(this, props, name, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return props;
    }

    private Properties maybeReEncodePasswords(Properties persistentProps, AdminZkClient adminZkClient) {
        Properties props = (Properties)persistentProps.clone();
        if (((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).keySet().exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)))) {
            this.maybeCreatePasswordEncoder(this.kafkaConfig().passwordEncoderOldSecret()).foreach((Function1 & Serializable & scala.Serializable)passwordDecoder -> {
                DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$2(this, persistentProps, props, adminZkClient, passwordDecoder);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    private Map<String, String> validatedKafkaProps(Properties propsOverride, boolean perBrokerConfig) {
        Properties propsResolved = DynamicBrokerConfig$.MODULE$.resolveVariableConfigs(propsOverride);
        DynamicBrokerConfig$.MODULE$.validateConfigs(propsResolved, perBrokerConfig);
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        if (perBrokerConfig) {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
        } else {
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, (scala.collection.mutable.Map<String, String>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(propsResolved).asScala()));
            this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        }
        return newProps;
    }

    /*
     * WARNING - void declaration
     */
    public void validate(Properties props, boolean perBrokerConfig) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            DynamicBrokerConfig.$anonfun$validate$1(this, props, perBrokerConfig);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void removeInvalidConfigs(Properties props, boolean perBrokerConfig) {
        try {
            DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props);
            CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala();
            return;
        }
        catch (Exception e) {
            scala.collection.mutable.Map invalidProps = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$removeInvalidConfigs$1(x0$1)));
            invalidProps.keys().foreach((Function1 & Serializable & scala.Serializable)x$1 -> props.remove(x$1));
            String configSource = perBrokerConfig ? "broker" : "default cluster";
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Dynamic ").append(configSource).append(" config contains invalid values in: ").append(invalidProps.keys()).append(", these configs will be ignored").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public void maybeReconfigure(Reconfigurable reconfigurable, KafkaConfig oldConfig, java.util.Map<String, ?> newConfig) {
        if (((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable.reconfigurableConfigs()).asScala()).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$maybeReconfigure$1(oldConfig, newConfig, key)))) {
            reconfigurable.reconfigure(newConfig);
            return;
        }
    }

    private Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> updatedConfigs(java.util.Map<String, ?> newProps, java.util.Map<String, ?> currentProps) {
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(newProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$1(currentProps, x0$1)));
        Set deletedKeySet = ((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(currentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$updatedConfigs$2(newProps, x0$2)))).keySet();
        return new Tuple2((Object)changeMap, (Object)deletedKeySet);
    }

    /*
     * WARNING - void declaration
     */
    private void overrideProps(scala.collection.mutable.Map<String, String> props, scala.collection.mutable.Map<String, String> propsOverride) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(k, v) -> {
            DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms((String)k, false).foreach((Function1 & Serializable & scala.Serializable)key -> props.remove(key));
            return props.put(k, v);
        };
        Map<String, String> map = Implicits$.MODULE$.MapExtensionMethods(propsOverride);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private void updateCurrentConfig(boolean doLog) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map newProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        newProps.$plus$plus$eq(this.staticBrokerConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicDefaultConfigs());
        this.overrideProps((scala.collection.mutable.Map<String, String>)newProps, this.dynamicBrokerConfigs());
        KafkaConfig oldConfig = this.currentConfig();
        Tuple2<KafkaConfig, List<BrokerReconfigurable>> tuple2 = this.processReconfiguration((Map<String, String>)newProps, false, doLog);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig newConfig = (KafkaConfig)tuple2._1();
        List brokerReconfigurablesToUpdate = (List)tuple2._2();
        void newConfig2 = var5_5;
        void brokerReconfigurablesToUpdate2 = var6_6;
        if (newConfig2 != this.currentConfig()) {
            this.currentConfig_$eq((KafkaConfig)newConfig2);
            this.kafkaConfig().updateCurrentConfig((KafkaConfig)newConfig2);
            brokerReconfigurablesToUpdate2.foreach(arg_0 -> DynamicBrokerConfig.$anonfun$updateCurrentConfig$1$adapted(oldConfig, (KafkaConfig)newConfig2, arg_0));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<KafkaConfig, List<BrokerReconfigurable>> processReconfiguration(Map<String, String> newProps, boolean validateOnly, boolean doLog) {
        void var7_7;
        void var6_6;
        KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(newProps).asJava(), doLog, (Option<DynamicBrokerConfig>)None$.MODULE$);
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newConfig.originalsFromThisConfig(), this.currentConfig().originals());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeySet = (Set)tuple2._2();
        void changeMap2 = var6_6;
        void deletedKeySet2 = var7_7;
        if (changeMap2.nonEmpty() || deletedKeySet2.nonEmpty()) {
            try {
                HashMap<String, Object> customConfigs = new HashMap<String, Object>(newConfig.originalsFromThisConfig());
                newConfig.valuesFromThisConfig().keySet().forEach(k -> customConfigs.remove(k));
                this.reconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$2(this, newConfig, customConfigs, validateOnly, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, arg_0));
                Buffer brokerReconfigurablesToUpdate = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.brokerReconfigurables().forEach(arg_0 -> DynamicBrokerConfig.$anonfun$processReconfiguration$3(this, (scala.collection.mutable.Map)changeMap2, (Set)deletedKeySet2, newConfig, validateOnly, brokerReconfigurablesToUpdate, arg_0));
                return new Tuple2((Object)newConfig, (Object)brokerReconfigurablesToUpdate.toList());
            }
            catch (Exception e) {
                if (!validateOnly) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Failed to update broker configuration with configs : ").append(ConfigUtils.configMapToRedactedString(newConfig.originalsFromThisConfig(), (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                throw new ConfigException("Invalid dynamic configuration", (Object)e);
            }
        }
        return new Tuple2((Object)this.currentConfig(), (Object)List$.MODULE$.empty());
    }

    private boolean processReconfiguration$default$3() {
        return false;
    }

    private boolean needsReconfiguration(java.util.Set<String> reconfigurableConfigs, Set<String> updatedKeys, Set<String> deletedKeys) {
        return ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(updatedKeys)).nonEmpty() || ((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurableConfigs).asScala()).intersect(deletedKeys)).nonEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private void processListenerReconfigurable(ListenerReconfigurable listenerReconfigurable, KafkaConfig newConfig, java.util.Map<String, Object> customConfigs, boolean validateOnly, boolean reloadOnly) {
        void var11_11;
        void var10_10;
        ListenerName listenerName = listenerReconfigurable.listenerName();
        java.util.Map<String, Object> oldValues = this.currentConfig().valuesWithPrefixOverride(listenerName.configPrefix());
        java.util.Map<String, Object> newValues = newConfig.valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        Tuple2<scala.collection.mutable.Map<String, ?>, Set<String>> tuple2 = this.updatedConfigs(newValues, oldValues);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Map changeMap = (scala.collection.mutable.Map)tuple2._1();
        Set deletedKeys = (Set)tuple2._2();
        void changeMap2 = var10_10;
        void deletedKeys2 = var11_11;
        Set updatedKeys = changeMap2.keySet();
        boolean configsChanged = this.needsReconfiguration(listenerReconfigurable.reconfigurableConfigs(), (Set<String>)updatedKeys, (Set<String>)deletedKeys2);
        if (reloadOnly != configsChanged) {
            this.processReconfigurable((Reconfigurable)listenerReconfigurable, (Set<String>)updatedKeys, newValues, customConfigs, validateOnly);
            return;
        }
    }

    private void processReconfigurable(Reconfigurable reconfigurable, Set<String> updatedConfigNames, java.util.Map<String, ?> allNewConfigs, java.util.Map<String, Object> newCustomConfigs, boolean validateOnly) {
        HashMap<String, Object> newConfigs = new HashMap<String, Object>();
        allNewConfigs.forEach((k, v) -> newConfigs.put((String)k, v));
        newConfigs.putAll(newCustomConfigs);
        try {
            reconfigurable.validateReconfiguration(newConfigs);
        }
        catch (ConfigException configException) {
            throw configException;
        }
        catch (Exception exception) {
            throw new ConfigException(new StringBuilder(58).append("Validation of dynamic config update of ").append(updatedConfigNames).append(" failed with class ").append(reconfigurable.getClass()).toString());
        }
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Reconfiguring ").append(reconfigurable).append(", updated configs: ").append(updatedConfigNames).append(" ").append("custom configs: ").append(ConfigUtils.configMapToRedactedString((java.util.Map)newCustomConfigs, (ConfigDef)KafkaConfig$.MODULE$.configDef())).toString());
            reconfigurable.reconfigure(newConfigs);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initialize$1(DynamicBrokerConfig $this, KafkaZkClient zkClient) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        $this.updateDefaultConfig(adminZkClient.fetchEntityConfig("brokers", "<default>"), false);
        Properties props = adminZkClient.fetchEntityConfig("brokers", Integer.toString($this.kafkaConfig().brokerId()));
        Properties brokerConfig = $this.maybeReEncodePasswords(props, adminZkClient);
        $this.updateBrokerConfig($this.kafkaConfig().brokerId(), brokerConfig, $this.updateBrokerConfig$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$addReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$1) {
        $this.verifyReconfigurableConfigs((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(reconfigurable$1.reconfigurableConfigs()).asScala()));
        return $this.reconfigurables().add(reconfigurable$1);
    }

    public static final /* synthetic */ boolean $anonfun$addBrokerReconfigurable$1(DynamicBrokerConfig $this, BrokerReconfigurable reconfigurable$2) {
        $this.verifyReconfigurableConfigs(reconfigurable$2.reconfigurableConfigs());
        return $this.brokerReconfigurables().add(reconfigurable$2);
    }

    public static final /* synthetic */ boolean $anonfun$removeReconfigurable$1(DynamicBrokerConfig $this, Reconfigurable reconfigurable$3) {
        return $this.reconfigurables().remove(reconfigurable$3);
    }

    public static final /* synthetic */ boolean $anonfun$verifyReconfigurableConfigs$2(String elem) {
        return DynamicConfig$Broker$.MODULE$.nonDynamicProps().contains((Object)elem);
    }

    public static final /* synthetic */ void $anonfun$verifyReconfigurableConfigs$1(Set configNames$1) {
        Set nonDynamic = (Set)configNames$1.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$verifyReconfigurableConfigs$2(elem)));
        Predef$.MODULE$.require(nonDynamic.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Reconfigurable contains non-dynamic configs ").append(nonDynamic).toString());
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicBrokerConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicBrokerConfigs().clone();
    }

    public static final /* synthetic */ scala.collection.mutable.Map $anonfun$currentDynamicDefaultConfigs$1(DynamicBrokerConfig $this) {
        return $this.dynamicDefaultConfigs().clone();
    }

    public static final /* synthetic */ void $anonfun$updateBrokerConfig$1(DynamicBrokerConfig $this, Properties persistentProps$1, boolean doLog$1, int brokerId$1) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$1, true);
            $this.dynamicBrokerConfigs().clear();
            $this.dynamicBrokerConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig(doLog$1);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Per-broker configs of ").append(brokerId$1).append(" could not be applied: ").append(persistentProps$1.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateDefaultConfig$1(DynamicBrokerConfig $this, Properties persistentProps$2, boolean doLog$2) {
        try {
            Properties props = $this.fromPersistentProps(persistentProps$2, false);
            $this.dynamicDefaultConfigs().clear();
            $this.dynamicDefaultConfigs().$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala());
            $this.updateCurrentConfig(doLog$2);
            return;
        }
        catch (Exception e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cluster default configs could not be applied: ").append(persistentProps$2.keys()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$reloadUpdatedFilesWithoutConfigChange$2(Reconfigurable reconfigurable) {
        return DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$ReloadableFileConfigs().exists(arg_0 -> DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(reconfigurable.reconfigurableConfigs(), arg_0));
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$4(DynamicBrokerConfig $this, Properties newProps$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            Map<String, String> kafkaProps = $this.validatedKafkaProps(newProps$1, true);
            KafkaConfig newConfig = new KafkaConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(kafkaProps).asJava(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig, Collections.emptyMap(), false, true);
            return;
        }
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Files will not be reloaded without config change for ").append(x0$1).toString());
    }

    public static final /* synthetic */ void $anonfun$reloadUpdatedFilesWithoutConfigChange$1(DynamicBrokerConfig $this, Properties newProps$1) {
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter($this.reconfigurables()).asScala()).filter((Function1 & Serializable & scala.Serializable)reconfigurable -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$2(reconfigurable)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DynamicBrokerConfig.$anonfun$reloadUpdatedFilesWithoutConfigChange$4($this, newProps$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void encodePassword$1(String configName, String value, boolean perBrokerConfig$1, Properties props$3) {
        if (value != null) {
            if (!perBrokerConfig$1) {
                throw new ConfigException("Password config can be defined only at broker level");
            }
            props$3.setProperty(configName, this.passwordEncoder().encode(new Password(value)));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$toPersistentProps$1(DynamicBrokerConfig $this, boolean perBrokerConfig$1, Properties props$3, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.encodePassword$1(name, value, perBrokerConfig$1, props$3);
            return;
        }
    }

    private final void removeInvalidProps$1(Set invalidPropNames, String errorMessage, Properties props$4) {
        if (invalidPropNames.nonEmpty()) {
            invalidPropNames.foreach((Function1 & Serializable & scala.Serializable)x$1 -> props$4.remove(x$1));
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(2).append(errorMessage).append(": ").append(invalidPropNames).toString());
            return;
        }
    }

    private final void decodePassword$1(String configName, String value, Properties props$4) {
        if (value != null) {
            try {
                props$4.setProperty(configName, this.passwordEncoder().decode(value).value());
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Dynamic password config ").append(configName).append(" could not be decoded, ignoring.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                props$4.remove(configName);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$fromPersistentProps$5(DynamicBrokerConfig $this, Properties props$4, String name, String value) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)) {
            $this.decodePassword$1(name, value, props$4);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$3(DynamicBrokerConfig $this, PasswordEncoder passwordDecoder$1, Properties props$5, String configName, String value2) {
        if (DynamicBrokerConfig$.MODULE$.isPasswordConfig(configName) && value2 != null) {
            Some some;
            try {
                some = new Some((Object)passwordDecoder$1.decode(value2).value());
            }
            catch (Exception exception) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(88).append("Dynamic password config ").append(configName).append(" could not be decoded using old secret, new secret will be used.").toString());
                some = None$.MODULE$;
            }
            some.foreach((Function1 & Serializable & scala.Serializable)value -> props$5.put(configName, $this.passwordEncoder().encode(new Password(value))));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeReEncodePasswords$2(DynamicBrokerConfig $this, Properties persistentProps$3, Properties props$5, AdminZkClient adminZkClient$1, PasswordEncoder passwordDecoder) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(configName, value) -> {
            DynamicBrokerConfig.$anonfun$maybeReEncodePasswords$3($this, passwordDecoder, props$5, configName, value);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$3).asScala());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        adminZkClient$1.changeBrokerConfig((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)$this.kafkaConfig().brokerId())), props$5);
    }

    public static final /* synthetic */ Tuple2 $anonfun$validate$1(DynamicBrokerConfig $this, Properties props$6, boolean perBrokerConfig$2) {
        Map<String, String> newProps = $this.validatedKafkaProps(props$6, perBrokerConfig$2);
        return $this.processReconfiguration(newProps, true, $this.processReconfiguration$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$removeInvalidConfigs$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Properties props1 = new Properties();
            props1.put(k, v);
            try {
                DynamicBrokerConfig$.MODULE$.kafka$server$DynamicBrokerConfig$$validateConfigTypes(props1);
                return false;
            }
            catch (Exception exception) {
                return true;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeReconfigure$1(KafkaConfig oldConfig$1, java.util.Map newConfig$1, String key) {
        return !BoxesRunTime.equals((Object)oldConfig$1.originals().get(key), newConfig$1.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$1(java.util.Map currentProps$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return !BoxesRunTime.equals((Object)x0$1._2(), currentProps$1.get(k));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$updatedConfigs$2(java.util.Map newProps$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            return !newProps$2.containsKey(k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$2(DynamicBrokerConfig $this, KafkaConfig newConfig$3, HashMap customConfigs$1, boolean validateOnly$1, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, Reconfigurable x0$1) {
        if (x0$1 instanceof ListenerReconfigurable) {
            ListenerReconfigurable listenerReconfigurable = (ListenerReconfigurable)x0$1;
            $this.processListenerReconfigurable(listenerReconfigurable, newConfig$3, customConfigs$1, validateOnly$1, false);
            return;
        }
        if ($this.needsReconfiguration(x0$1.reconfigurableConfigs(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            $this.processReconfigurable(x0$1, (Set<String>)changeMap$1.keySet(), newConfig$3.valuesFromThisConfig(), customConfigs$1, validateOnly$1);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processReconfiguration$3(DynamicBrokerConfig $this, scala.collection.mutable.Map changeMap$1, Set deletedKeySet$1, KafkaConfig newConfig$3, boolean validateOnly$1, Buffer brokerReconfigurablesToUpdate$1, BrokerReconfigurable reconfigurable) {
        if ($this.needsReconfiguration((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(reconfigurable.reconfigurableConfigs()).asJava(), (Set<String>)changeMap$1.keySet(), (Set<String>)deletedKeySet$1)) {
            reconfigurable.validateReconfiguration(newConfig$3);
            if (!validateOnly$1) {
                brokerReconfigurablesToUpdate$1.$plus$eq((Object)reconfigurable);
                return;
            }
            return;
        }
    }

    public DynamicBrokerConfig(KafkaConfig kafkaConfig) {
        Option<PasswordEncoder> option;
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
        this.staticBrokerConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(kafkaConfig.originalsFromThisConfig())).asScala();
        this.staticDefaultConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(KafkaConfig$.MODULE$.defaultValues()).asJava()))).asScala();
        this.dynamicBrokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dynamicDefaultConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.reconfigurables = new CopyOnWriteArrayList();
        this.brokerReconfigurables = new CopyOnWriteArrayList();
        this.lock = new ReentrantReadWriteLock();
        if (kafkaConfig.processRoles().isEmpty()) {
            option = this.maybeCreatePasswordEncoder(kafkaConfig.passwordEncoderSecret());
        } else {
            Option<PasswordEncoder> option2;
            option = option2;
            super((Object)PasswordEncoder.NOOP);
        }
        this.dynamicConfigPasswordEncoder = option;
    }

    public static final /* synthetic */ Object $anonfun$updateCurrentConfig$1$adapted(KafkaConfig oldConfig$2, KafkaConfig newConfig$2, BrokerReconfigurable x$3) {
        x$3.reconfigure(oldConfig$2, newConfig$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$reloadUpdatedFilesWithoutConfigChange$3$adapted(java.util.Set eta$0$1$1, Object x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

