/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerBrokerStateInfo;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.QueueItem;
import kafka.controller.RequestSendThread;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ux!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%Ia\r\u0005\u0007y\u0005\u0001\u000b\u0011\u0002\u001b\t\u000fu\n!\u0019!C\u0005g!1a(\u0001Q\u0001\nQBqaP\u0001\u0012\u0002\u0013\u0005\u0001I\u0002\u0003)C\u0001A\u0006\u0002C0\t\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\u0019D!\u0011!Q\u0001\n\u001dD\u0001\"\u001c\u0005\u0003\u0002\u0003\u0006IA\u001c\u0005\tu\"\u0011\t\u0011)A\u0005w\"Q\u0011\u0011\u0001\u0005\u0003\u0002\u0003\u0006I!a\u0001\t\u0013\u0005%\u0001B!A!\u0002\u0013\u0011\u0005B\u0002\u0019\t\t\u0003\tY\u0001C\u0005\u0002\u001c!\u0011\r\u0011\"\u0003\u0002\u001e!A\u00111\u0006\u0005!\u0002\u0013\ty\u0002C\u0005\u0002.!\u0011\r\u0011\"\u0005\u00020!A\u0011q\t\u0005!\u0002\u0013\t\t\u0004C\u0005\u0002J!\u0011\r\u0011\"\u0003\u0002L!A\u00111\u000b\u0005!\u0002\u0013\ti\u0005C\u0004\u0002V!!\t!a\u0016\t\u000f\u0005]\u0004\u0002\"\u0001\u0002z!9\u00111\u0010\u0005\u0005\u0002\u0005u\u0004\"CAb\u0011E\u0005I\u0011AAc\u0011\u001d\tI\r\u0003C\u0001\u0003\u0017Dq!!5\t\t\u0003\t\u0019\u000eC\u0004\u0002X\"!I!!7\t\u000f\u0005u\u0007\u0002\"\u0003\u0002`\"9\u0011q\u001e\u0005\u0005\n\u0005E\bbBA|\u0011\u0011%\u0011\u0011`\u0001\u0019\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014(B\u0001\u0012$\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002I\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0014\u0002\u001b\u0005\t#\u0001G\"p]R\u0014x\u000e\u001c7fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feN\u0011\u0011A\u000b\t\u0003W9j\u0011\u0001\f\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0013aE)vKV,7+\u001b>f\u001b\u0016$(/[2OC6,W#\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u00027b]\u001eT\u0011!O\u0001\u0005U\u00064\u0018-\u0003\u0002<m\t11\u000b\u001e:j]\u001e\fA#U;fk\u0016\u001c\u0016N_3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0017A\t*fcV,7\u000f\u001e*bi\u0016\fe\u000eZ)vKV,G+[7f\u001b\u0016$(/[2OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0002\u0003*\u0012!i\u0014\t\u0004W\r+\u0015B\u0001#-\u0005\u0019y\u0005\u000f^5p]B\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001\u0013\u0017\u000e\u0003%S!AS\u0013\u0002\rq\u0012xn\u001c;?\u0013\taE&\u0001\u0004Qe\u0016$WMZ\u0005\u0003w9S!\u0001\u0014\u0017,\u0003A\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0013Ut7\r[3dW\u0016$'BA+-\u0003)\tgN\\8uCRLwN\\\u0005\u0003/J\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f'\rA!&\u0017\t\u00035vk\u0011a\u0017\u0006\u00039\u000e\nQ!\u001e;jYNL!AX.\u0003\u000f1{wmZ5oO\u0006y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eE\u0002,C\u000eL!A\u0019\u0017\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA\u0016e\u0013\t)GFA\u0002J]R\faaY8oM&<\u0007C\u00015l\u001b\u0005I'B\u00016$\u0003\u0019\u0019XM\u001d<fe&\u0011A.\u001b\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0003uS6,\u0007CA8y\u001b\u0005\u0001(B\u0001/r\u0015\t\u00118/\u0001\u0004d_6lwN\u001c\u0006\u0003IQT!!\u001e<\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0018aA8sO&\u0011\u0011\u0010\u001d\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\u0005qtX\"A?\u000b\u0005i\f\u0018BA@~\u0005\u001diU\r\u001e:jGN\f\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s!\r9\u0013QA\u0005\u0004\u0003\u000f\t#!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u000b\u000f\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r!\t9\u0003\u0002C\u0003`\u001f\u0001\u0007\u0001\rC\u0003g\u001f\u0001\u0007q\rC\u0003n\u001f\u0001\u0007a\u000eC\u0003{\u001f\u0001\u00071\u0010C\u0004\u0002\u0002=\u0001\r!a\u0001\t\u0011\u0005%q\u0002%AA\u0002\t\u000bA\"\\3ue&\u001c7o\u0012:pkB,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1A_A\u0013\u0015\tQ7/\u0003\u0003\u0002*\u0005\r\"!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\nqB\u0019:pW\u0016\u00148\u000b^1uK&sgm\\\u000b\u0003\u0003c\u0001r!a\r\u0002>\r\f\t%\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u001diW\u000f^1cY\u0016T1!a\u000f-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\t)DA\u0004ICNDW*\u00199\u0011\u0007\u001d\n\u0019%C\u0002\u0002F\u0005\u0012\u0011dQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:Ti\u0006$X-\u00138g_\u0006\u0001\"M]8lKJ\u001cF/\u0019;f\u0013:4w\u000eI\u0001\u000bEJ|7.\u001a:M_\u000e\\WCAA'!\r)\u0014qJ\u0005\u0004\u0003#2$AB(cU\u0016\u001cG/A\u0006ce>\\WM\u001d'pG.\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0005\u00033\ny\u0006E\u0002,\u00037J1!!\u0018-\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005d\u00031\u0001\u0002d\u0005q\u0011N\\5uS\u0006d'I]8lKJ\u001c\bCBA3\u0003O\nY'\u0004\u0002\u0002:%!\u0011\u0011NA\u001d\u0005\r\u0019V\r\u001e\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O\u0012\u0002\u000f\rdWo\u001d;fe&!\u0011QOA8\u0005\u0019\u0011%o\\6fe\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002Z\u0005Y1/\u001a8e%\u0016\fX/Z:u)!\tI&a \u0002\u0004\u0006M\u0006BBAA1\u0001\u00071-\u0001\u0005ce>\\WM]%e\u0011\u001d\t)\t\u0007a\u0001\u0003\u000f\u000bqA]3rk\u0016\u001cH\u000f\r\u0003\u0002\n\u0006\u0005\u0006CBAF\u0003/\u000biJ\u0004\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t*]\u0001\te\u0016\fX/Z:ug&!\u0011QSAH\u0003Y\t%m\u001d;sC\u000e$8i\u001c8ue>d'+Z9vKN$\u0018\u0002BAM\u00037\u0013qAQ;jY\u0012,'O\u0003\u0003\u0002\u0016\u0006=\u0005\u0003BAP\u0003Cc\u0001\u0001\u0002\u0007\u0002$\u0006\r\u0015\u0011!A\u0001\u0006\u0003\t)KA\u0002`IE\nB!a*\u0002.B\u00191&!+\n\u0007\u0005-FFA\u0004O_RD\u0017N\\4\u0011\t\u00055\u0015qV\u0005\u0005\u0003c\u000byI\u0001\fBEN$(/Y2u\u0007>tGO]8m%\u0016\fX/Z:u\u0011%\t)\f\u0007I\u0001\u0002\u0004\t9,\u0001\u0005dC2d'-Y2l!\u001dY\u0013\u0011XA_\u00033J1!a/-\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\u000e\u0006}\u0016\u0002BAa\u0003\u001f\u0013\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002+M,g\u000e\u001a*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0019\u0016\u0004\u0003o{\u0015!C1eI\n\u0013xn[3s)\u0011\tI&!4\t\u000f\u0005='\u00041\u0001\u0002l\u00051!M]8lKJ\fAB]3n_Z,'I]8lKJ$B!!\u0017\u0002V\"1\u0011\u0011Q\u000eA\u0002\r\fA\"\u00193e\u001d\u0016<(I]8lKJ$B!!\u0017\u0002\\\"9\u0011q\u001a\u000fA\u0002\u0005-\u0014\u0001\u00052s_.,'/T3ue&\u001cG+Y4t)\u0011\t\t/!<\u0011\r\u0005\r\u0018\u0011\u001e\u001b5\u001b\t\t)OC\u0002\u0002hb\nA!\u001e;jY&!\u00111^As\u0005\ri\u0015\r\u001d\u0005\u0007\u0003\u0003k\u0002\u0019A2\u0002)I,Wn\u001c<f\u000bbL7\u000f^5oO\n\u0013xn[3s)\u0011\tI&a=\t\u000f\u0005Uh\u00041\u0001\u0002B\u0005Y!M]8lKJ\u001cF/\u0019;f\u0003Y\u0019H/\u0019:u%\u0016\fX/Z:u'\u0016tG\r\u00165sK\u0006$G\u0003BA-\u0003wDa!!! \u0001\u0004\u0019\u0007")
public class ControllerChannelManager
implements Logging {
    private final Function0<Object> controllerEpoch;
    private final KafkaConfig config;
    private final Time time;
    private final Metrics metrics;
    private final StateChangeLogger stateChangeLogger;
    private final Option<String> threadNamePrefix;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo;
    private final Object brokerLock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$6() {
        return ControllerChannelManager$.MODULE$.$lessinit$greater$default$6();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<Object, ControllerBrokerStateInfo> brokerStateInfo() {
        return this.brokerStateInfo;
    }

    private Object brokerLock() {
        return this.brokerLock;
    }

    public void startup(Set<Broker> initialBrokers) {
        initialBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            this.addNewBroker(broker);
            return BoxedUnit.UNIT;
        });
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.startRequestSendThread(brokerState._1$mcI$sp());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void shutdown() {
        Object object = this.brokerLock();
        synchronized (object) {
            this.brokerStateInfo().values().toList().foreach((Function1 & Serializable & scala.Serializable)brokerState -> {
                this.removeExistingBroker(brokerState);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
        Object object = this.brokerLock();
        synchronized (object) {
            Option stateInfoOpt = this.brokerStateInfo().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (stateInfoOpt instanceof Some) {
                ((ControllerBrokerStateInfo)((Some)stateInfoOpt).value()).messageQueue().put(new QueueItem(request.apiKey(), request, callback, this.time.milliseconds()));
            } else if (None$.MODULE$.equals(stateInfoOpt)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("Not sending request ").append(request$1.apiKey().name).append(" with controllerId=").append(request.controllerId()).append(", ").append("controllerEpoch=").append(request.controllerEpoch()).append(", brokerEpoch=").append(request.brokerEpoch()).append(" ").append("to broker ").append(brokerId).append(", since it is offline.").toString());
            } else {
                throw new MatchError((Object)stateInfoOpt);
            }
            return;
        }
    }

    public Function1<AbstractResponse, BoxedUnit> sendRequest$default$3() {
        return null;
    }

    public void addBroker(Broker broker) {
        Object object = this.brokerLock();
        synchronized (object) {
            if (!this.brokerStateInfo().contains((Object)BoxesRunTime.boxToInteger((int)broker.id()))) {
                this.addNewBroker(broker);
                this.startRequestSendThread(broker.id());
            }
            return;
        }
    }

    public void removeBroker(int brokerId) {
        Object object = this.brokerLock();
        synchronized (object) {
            this.removeExistingBroker((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addNewBroker(Broker broker) {
        String string;
        void var11_11;
        void var10_10;
        void var8_8;
        None$ none$;
        LinkedBlockingQueue<QueueItem> messageQueue = new LinkedBlockingQueue<QueueItem>();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Controller ").append($this.config.brokerId()).append(" trying to connect to broker ").append(broker.id()).toString());
        ListenerName controllerToBrokerListenerName = (ListenerName)this.config.controlPlaneListenerName().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerListenerName());
        SecurityProtocol controllerToBrokerSecurityProtocol = (SecurityProtocol)this.config.controlPlaneSecurityProtocol().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.config.interBrokerSecurityProtocol());
        Node brokerNode = broker.node(controllerToBrokerListenerName);
        LogContext logContext = new LogContext(new StringBuilder(34).append("[Controller id=").append(this.config.brokerId()).append(", targetBrokerId=").append(brokerNode.idString()).append("] ").toString());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerToBrokerSecurityProtocol, (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerToBrokerListenerName, (String)this.config.saslMechanismInterBrokerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)logContext);
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
            none$ = new Some((Object)channelBuilder);
        } else {
            none$ = None$.MODULE$;
        }
        None$ reconfigurableChannelBuilder = none$;
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, "controller-channel", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)brokerNode.idString())}))).asJava(), false, channelBuilder, logContext);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)brokerNode, (List)Nil$.MODULE$)).asJava()), Integer.toString(this.config.brokerId()), 1, 0L, 0L, -1, -1, Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
        Option reconfigurableChannelBuilder2 = (Option)var8_8;
        void networkClient2 = var10_10;
        void reconfigurableChannelBuilder3 = var11_11;
        Option<String> option = this.threadNamePrefix;
        if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(34).append("Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else if (option instanceof Some) {
            String name = (String)((Some)option).value();
            string = new StringBuilder(35).append(name).append(":Controller-").append(this.config.brokerId()).append("-to-broker-").append(broker.id()).append("-send-thread").toString();
        } else {
            throw new MatchError(option);
        }
        String threadName = string;
        Timer requestRateAndQueueTimeMetrics = this.metricsGroup().newTimer(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$RequestRateAndQueueTimeMetricName(), TimeUnit.MILLISECONDS, TimeUnit.SECONDS, this.brokerMetricTags(broker.id()));
        RequestSendThread requestThread = new RequestSendThread(this.config.brokerId(), this.controllerEpoch, messageQueue, (NetworkClient)networkClient2, brokerNode, this.config, this.time, requestRateAndQueueTimeMetrics, this.stateChangeLogger, threadName);
        requestThread.setDaemon(false);
        Gauge queueSizeGauge = this.metricsGroup().newGauge(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$QueueSizeMetricName(), (Gauge)new Gauge<Object>(this, messageQueue){
            private final /* synthetic */ ControllerChannelManager $outer;
            private final LinkedBlockingQueue messageQueue$1;

            public final int value() {
                return ControllerChannelManager.kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(this.messageQueue$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageQueue$1 = messageQueue$1;
            }
        }, this.brokerMetricTags(broker.id()));
        this.brokerStateInfo().put((Object)BoxesRunTime.boxToInteger((int)broker.id()), (Object)new ControllerBrokerStateInfo((NetworkClient)networkClient2, brokerNode, messageQueue, requestThread, (Gauge<Object>)queueSizeGauge, requestRateAndQueueTimeMetrics, (Option<Reconfigurable>)reconfigurableChannelBuilder3));
    }

    private java.util.Map<String, String> brokerMetricTags(int brokerId) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broker-id"), (Object)Integer.toString(brokerId))}))).asJava();
    }

    private void removeExistingBroker(ControllerBrokerStateInfo brokerState) {
        try {
            brokerState.reconfigurableChannelBuilder().foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                this.config.removeReconfigurable(reconfigurable);
                return BoxedUnit.UNIT;
            });
            brokerState.requestSendThread().shutdown();
            brokerState.networkClient().close();
            brokerState.messageQueue().clear();
            this.metricsGroup().removeMetric(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$QueueSizeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.metricsGroup().removeMetric(ControllerChannelManager$.MODULE$.kafka$controller$ControllerChannelManager$$RequestRateAndQueueTimeMetricName(), this.brokerMetricTags(brokerState.brokerNode().id()));
            this.brokerStateInfo().remove((Object)BoxesRunTime.boxToInteger((int)brokerState.brokerNode().id()));
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while removing broker by the controller", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            return;
        }
    }

    private void startRequestSendThread(int brokerId) {
        block7: {
            RequestSendThread requestThread;
            block6: {
                Thread.State state;
                Thread.State state2;
                block5: {
                    requestThread = ((ControllerBrokerStateInfo)this.brokerStateInfo().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).requestSendThread();
                    state2 = requestThread.getState();
                    state = Thread.State.NEW;
                    if (state2 != null) break block5;
                    if (state != null) {
                        return;
                    }
                    break block6;
                }
                if (!((Object)((Object)state2)).equals((Object)state)) break block7;
            }
            requestThread.start();
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$new$2(ControllerBrokerStateInfo x$1) {
        return x$1.messageQueue().size();
    }

    public final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$new$1() {
        Object object = this.brokerLock();
        synchronized (object) {
            int n = BoxesRunTime.unboxToInt((Object)this.brokerStateInfo().values().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ControllerChannelManager.$anonfun$new$2(x$1))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return n;
        }
    }

    public static final /* synthetic */ int kafka$controller$ControllerChannelManager$$$anonfun$addNewBroker$4(LinkedBlockingQueue messageQueue$1) {
        return messageQueue$1.size();
    }

    public ControllerChannelManager(Function0<Object> controllerEpoch, KafkaConfig config, Time time, Metrics metrics, StateChangeLogger stateChangeLogger, Option<String> threadNamePrefix) {
        this.controllerEpoch = controllerEpoch;
        this.config = config;
        this.time = time;
        this.metrics = metrics;
        this.stateChangeLogger = stateChangeLogger;
        this.threadNamePrefix = threadNamePrefix;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.brokerStateInfo = new HashMap();
        this.brokerLock = new Object();
        this.logIdent_$eq(new StringBuilder(34).append("[Channel manager on controller ").append(config.brokerId()).append("]: ").toString());
        this.metricsGroup().newGauge("TotalQueueSize", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ ControllerChannelManager $outer;

            public final int value() {
                return this.$outer.kafka$controller$ControllerChannelManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

