/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import kafka.log.UnifiedLog;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.VerificationGuard;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r%c\u0001\u0002\u001a4\u0001iB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!!\u0007A!A!\u0002\u0013)\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011B7\t\u000bI\u0004A\u0011A:\u0006\tm\u0004A\u0001 \u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wA\u0001\"!\u0013\u0001A\u0003%\u0011Q\b\u0005\u000b\u0003\u0017\u0002!\u0019!C\u0001g\u00055\u0003\u0002CA3\u0001\u0001\u0006I!a\u0014\t\u0015\u0005\u001d\u0004A1A\u0005\u0002M\nI\u0007\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA6\u0011-\tI\b\u0001a\u0001\u0002\u0004%I!a\u001f\t\u0017\u0005\r\u0005\u00011AA\u0002\u0013%\u0011Q\u0011\u0005\f\u0003\u0017\u0003\u0001\u0019!A!B\u0013\ti\bC\u0006\u0002\u000e\u0002\u0001\r\u00111A\u0005\n\u0005=\u0005bCAI\u0001\u0001\u0007\t\u0019!C\u0005\u0003'C!\"a&\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%\t\t\u000b\u0001b\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAS\u0011!\ti\u000b\u0001C\u0001g\u0005=\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDqAa\u0002\u0001\t\u0013\u0011I\u0001\u0003\u0005\u0002\\\u0002!\ta\rB\u0010\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\u0010\u0001\t\u0003\u0011y\u0002C\u0004\u0003@\u0001!\tA!\u0011\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BP\u0001\u0011%!\u0011\u0015\u0005\b\u0005W\u0003A\u0011\u0001BW\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005kCqAa0\u0001\t\u0003\u0011\t\rC\u0004\u0003F\u0002!IAa2\t\u0011\tU\u0007\u0001\"\u00014\u0005/DqAa9\u0001\t\u0003\u0011)\u000fC\u0004\u0003t\u0002!\tA!>\t\u000f\tM\b\u0001\"\u0001\u0003z\"9!q \u0001\u0005\n\t}\u0001bBB\u0001\u0001\u0011\u000511\u0001\u0005\n\u0007O\u0001\u0011\u0013!C\u0001\u0007SAqaa\u0010\u0001\t\u0003\u0019\t\u0005C\u0004\u0004H\u0001!\tAa\b\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014(B\u0001\u001b6\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005Y:\u0014aC2p_J$\u0017N\\1u_JT\u0011\u0001O\u0001\u0006W\u000647.Y\u0002\u0001'\r\u00011(\u0011\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t+U\"A\"\u000b\u0005\u0011;\u0014!B;uS2\u001c\u0018B\u0001$D\u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003y%K!AS\u001f\u0003\u0007%sG/A\u0005tG\",G-\u001e7feB\u0011QjV\u0007\u0002\u001d*\u0011q\nU\u0001\u0005kRLGN\u0003\u0002R%\u000611/\u001a:wKJT!\u0001O*\u000b\u0005Q+\u0016AB1qC\u000eDWMC\u0001W\u0003\ry'oZ\u0005\u00031:\u0013\u0011bU2iK\u0012,H.\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u00111,X\u0007\u00029*\u0011\u0011kN\u0005\u0003=r\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\u0004d_:4\u0017n\u001a\t\u0003C\nl\u0011aM\u0005\u0003GN\u0012\u0011\u0003\u0016:b]N\f7\r^5p]\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0005\u0019TW\"A4\u000b\u0005\u0011C'BA5S\u0003\u0019\u0019w.\\7p]&\u00111n\u001a\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\u00059\u0004X\"A8\u000b\u00051D\u0017BA9p\u0005\u001diU\r\u001e:jGN\fa\u0001P5oSRtDc\u0002;vm^D\u0018P\u001f\t\u0003C\u0002AQaR\u0004A\u0002!CQaS\u0004A\u00021CQ!W\u0004A\u0002iCQaX\u0004A\u0002\u0001DQ\u0001Z\u0004A\u0002\u0015DQ\u0001\\\u0004A\u00025\u0014acU3oIRCh.T1sW\u0016\u00148oQ1mY\n\f7m\u001b\t\u000byuDu0a\u0003\u0002\u0012\u0005]\u0011B\u0001@>\u0005%1UO\\2uS>tG\u0007\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001[\u0001\te\u0016\fX/Z:ug&!\u0011\u0011BA\u0002\u0005E!&/\u00198tC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\t\u0004C\u00065\u0011bAA\bg\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCB\u0019\u0011-a\u0005\n\u0007\u0005U1G\u0001\nUq:$&/\u00198tSRlU\r^1eCR\f\u0007c\u0001\u001f\u0002\u001a%\u0019\u00111D\u001f\u0003\tUs\u0017\u000e^\u0001\rg\",H\u000f^5oO\u0012{wO\\\u000b\u0003\u0003C\u0001B!a\t\u000245\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003W\ti#\u0001\u0006d_:\u001cWO\u001d:f]RT1aTA\u0018\u0015\t\t\t$\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003K\u0011Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D:ikR$\u0018N\\4E_^t\u0007%A\u0005ti\u0006$X\rT8dWV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u00111IA\u0015\u0003\u0015awnY6t\u0013\u0011\t9%!\u0011\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\f!b\u001d;bi\u0016dunY6!\u0003Eaw.\u00193j]\u001e\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u001f\u0002b!!\u0015\u0002\\\u0005}SBAA*\u0015\u0011\t)&a\u0016\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011L\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002^\u0005M#aA*fiB\u0019\u0011-!\u0019\n\u0007\u0005\r4G\u0001\u0012Ue\u0006t7/Y2uS>t\u0007+\u0019:uSRLwN\\!oI2+\u0017\rZ3s\u000bB|7\r[\u0001\u0013Y>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\rue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\"!a\u001b\u0011\u000f\u0005E\u0013Q\u000e%\u0002r%!\u0011qNA*\u0005\ri\u0015\r\u001d\t\u0004C\u0006M\u0014bAA;g\t)B\u000b\u001f8NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z#oiJL\u0018!\u0007;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f7)Y2iK\u0002\naE]3ue&,g/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\ti\b\u0005\u0003=\u0003\u007fB\u0015bAAA{\tIa)\u001e8di&|g\u000eM\u0001+e\u0016$(/[3wKR\u0013\u0018M\\:bGRLwN\u001c+pa&\u001c\u0007+\u0019:uSRLwN\\\"pk:$x\fJ3r)\u0011\t9\"a\"\t\u0013\u0005%%#!AA\u0002\u0005u\u0014a\u0001=%c\u00059#/\u001a;sS\u00164X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;!\u0003y!(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/F\u0001I\u0003\t\"(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtGo\u0018\u0013fcR!\u0011qCAK\u0011!\tI)FA\u0001\u0002\u0004A\u0015a\b;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA!\u001aa#a'\u0011\u0007q\ni*C\u0002\u0002 v\u0012\u0001B^8mCRLG.Z\u0001\u0014a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN]\u000b\u0003\u0003K\u00032A\\AT\u0013\r\tIk\u001c\u0002\u0007'\u0016t7o\u001c:\u0002)A\f'\u000f^5uS>tGj\\1e'\u0016t7o\u001c:!\u0003M\tG\r\u001a'pC\u0012Lgn\u001a)beRLG/[8o)\u0019\t9\"!-\u00026\"1\u00111W\rA\u0002!\u000b1\u0002]1si&$\u0018n\u001c8JI\"1\u0011qW\rA\u0002!\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)QLW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\t\ti\f\u0005\u0004\u0002@\u0006=\u0017Q\u001b\b\u0005\u0003\u0003\fYM\u0004\u0003\u0002D\u0006%WBAAc\u0015\r\t9-O\u0001\u0007yI|w\u000e\u001e \n\u0003yJ1!!4>\u0003\u001d\u0001\u0018mY6bO\u0016LA!!5\u0002T\nA\u0011\n^3sC\ndWMC\u0002\u0002Nv\u00022!YAl\u0013\r\tIn\r\u0002\")J\fgn]1di&|g.\u00197JI\u0006sG\r\u0015:pIV\u001cWM]%e\u000bB|7\r[\u0001\u001ee\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%egR1\u0011qCAp\u0003WDq!!9\u001c\u0001\u0004\t\u0019/\u0001\u000bue\u0006t7/Y2uS>t\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003K\f9/D\u0001i\u0013\r\tI\u000f\u001b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tio\u0007a\u0001\u0003c\nQ\u0003\u001e=o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3F]R\u0014\u00180\u0001\u0007tQ>,H\u000eZ#ya&\u0014X\r\u0006\u0004\u0002t\u0006e\u0018Q \t\u0004y\u0005U\u0018bAA|{\t9!i\\8mK\u0006t\u0007bBA~9\u0001\u0007\u00111B\u0001\fibtW*\u001a;bI\u0006$\u0018\rC\u0004\u0002\u0000r\u0001\rA!\u0001\u0002\u001b\r,(O]3oiRKW.Z't!\ra$1A\u0005\u0004\u0005\u000bi$\u0001\u0002'p]\u001e\fQ#\\1zE\u0016\f\u0005\u000f]3oI\u0016C\b/\u001b:bi&|g\u000e\u0006\u0005\u0002t\n-!Q\u0002B\u000f\u0011\u001d\tY0\ba\u0001\u0003\u0017AqAa\u0004\u001e\u0001\u0004\u0011\t\"\u0001\bsK\u000e|'\u000fZ:Ck&dG-\u001a:\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006i\u0003\u0019\u0011XmY8sI&!!1\u0004B\u000b\u0005QiU-\\8ssJ+7m\u001c:eg\n+\u0018\u000e\u001c3fe\"9\u0011q`\u000fA\u0002\t\u0005ACAA\f\u0003%:(/\u001b;f)>l'm\u001d;p]\u0016\u001chi\u001c:FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%egRA\u0011q\u0003B\u0013\u0005O\u0011\u0019\u0004C\u0004\u0002b~\u0001\r!a9\t\u000f\t%r\u00041\u0001\u0003,\u0005\u0019R\r\u001f9je\u0016$gi\u001c:QCJ$\u0018\u000e^5p]B1\u0011qXAh\u0005[\u00012!\u0019B\u0018\u0013\r\u0011\td\r\u0002+)J\fgn]1di&|g.\u00197JI\u000e{wN\u001d3j]\u0006$xN]#q_\u000eD\u0017I\u001c3NKR\fG-\u0019;b\u0011\u001d\u0011)d\ba\u0001\u0005o\t\u0001\u0003^8nEN$xN\\3SK\u000e|'\u000fZ:\u0011\t\tM!\u0011H\u0005\u0005\u0005w\u0011)BA\u0007NK6|'/\u001f*fG>\u0014Hm]\u0001 K:\f'\r\\3Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>t\u0017aE4fiR\u0013\u0018M\\:bGRLwN\\*uCR,G\u0003\u0002B\"\u0005C\u0002\u0002\"a0\u0003F\t%#QK\u0005\u0005\u0005\u000f\n\u0019N\u0001\u0004FSRDWM\u001d\t\u0005\u0005\u0017\u0012\t&\u0004\u0002\u0003N)\u0019!q\n5\u0002\u0011A\u0014x\u000e^8d_2LAAa\u0015\u0003N\t1QI\u001d:peN\u0004R\u0001\u0010B,\u00057J1A!\u0017>\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011M!\u0018\n\u0007\t}3G\u0001\u0010D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG\r\u0016=o\u001b\u0016$\u0018\rZ1uC\"9!1M\u0011A\u0002\t\u0015\u0014a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0011\t\t\u001d$q\u000e\b\u0005\u0005S\u0012Y\u0007E\u0002\u0002DvJ1A!\u001c>\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u000fB:\u0005\u0019\u0019FO]5oO*\u0019!QN\u001f\u0002=A,H\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3JM:{G/\u0012=jgR\u001cH\u0003\u0002B=\u0005w\u0002\u0002\"a0\u0003F\t%#1\f\u0005\b\u0003w\u0014\u0003\u0019AA\u0006\u0003Ua\u0017n\u001d;Ue\u0006t7/Y2uS>t7\u000b^1uKN$\u0002B!!\u0003\u000e\nU%1\u0014\t\u0005\u0005\u0007\u0013I)\u0004\u0002\u0003\u0006*\u0019!q\u00115\u0002\u000f5,7o]1hK&!!1\u0012BC\u0005qa\u0015n\u001d;Ue\u0006t7/Y2uS>t7OU3ta>t7/\u001a#bi\u0006DqAa$$\u0001\u0004\u0011\t*A\tgS2$XM\u001d)s_\u0012,8-\u001a:JIN\u0004bAa\u001a\u0003\u0014\n\u0005\u0011\u0002BA/\u0005gBqAa&$\u0001\u0004\u0011I*\u0001\tgS2$XM]*uCR,g*Y7fgB1!q\rBJ\u0005KBqA!($\u0001\u0004\u0011\t!\u0001\tgS2$XM\u001d#ve\u0006$\u0018n\u001c8Ng\u0006qr-\u001a;B]\u0012l\u0015-\u001f2f\u0003\u0012$GK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0007\u0005\u0007\u0012\u0019K!*\t\u000f\t\rD\u00051\u0001\u0003f!9!q\u0015\u0013A\u0002\t%\u0016!F2sK\u0006$X\r\u001a+y]6+G/\u00193bi\u0006|\u0005\u000f\u001e\t\u0006y\t]\u00131B\u0001\u001dm\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t)\u0011\t\u0019Pa,\t\r\tEV\u00051\u0001I\u00031!\bP\u001c+j[\u0016|W\u000f^'t\u0003]!(/\u00198tC\u000e$\u0018n\u001c8U_BL7mQ8oM&<7/\u0006\u0002\u00038B!!\u0011\u0018B^\u001b\t\ti#\u0003\u0003\u0003>\u00065\"A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u0019\u0001Ja1\t\u000f\t\rt\u00051\u0001\u0003f\u00059Bn\\1e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0007\u0005\u0013\u0014yMa5\u0011\u000f\t\u0013YM!\u001a\u0002\f%\u0019!QZ\"\u0003\tA{w\u000e\u001c\u0005\b\u0005#D\u0003\u0019AAr\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Da!a.)\u0001\u0004A\u0015\u0001H1eI2{\u0017\rZ3e)J\fgn]1di&|gn\u001d+p\u0007\u0006\u001c\u0007.\u001a\u000b\t\u0003/\u0011IN!8\u0003`\"1!1\\\u0015A\u0002!\u000b\u0011\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\t9,\u000ba\u0001\u0011\"9!\u0011]\u0015A\u0002\t%\u0017A\u00057pC\u0012,G\r\u0016:b]N\f7\r^5p]N\fA\u0005\\8bIR\u0013\u0018M\\:bGRLwN\\:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\t\u0003/\u00119O!;\u0003l\"1\u00111\u0017\u0016A\u0002!Ca!a.+\u0001\u0004A\u0005b\u0002BwU\u0001\u0007!q^\u0001\u000fg\u0016tG\r\u0016=o\u001b\u0006\u00148.\u001a:t!\r\u0011\t\u0010C\u0007\u0002\u0001\u00051#/Z7pm\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005]!q\u001f\u0005\u0007\u0003g[\u0003\u0019\u0001%\u0015\r\u0005]!1 B\u007f\u0011\u0019\t\u0019\f\fa\u0001\u0011\"1\u0011q\u0017\u0017A\u0002!\u000baF^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0013N\u001cF/\u00192mK\u00061\u0012\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{w\r\u0006\b\u0002\u0018\r\u00151qAB\u0005\u0007\u001b\u00199b!\b\t\u000f\t\rd\u00061\u0001\u0003f!1\u0011q\u0017\u0018A\u0002!Cqaa\u0003/\u0001\u0004\t\t\"A\u0006oK^lU\r^1eCR\f\u0007bBB\b]\u0001\u00071\u0011C\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004r\u0001PB\n\u0005\u0013\n9\"C\u0002\u0004\u0016u\u0012\u0011BR;oGRLwN\\\u0019\t\u0013\rea\u0006%AA\u0002\rm\u0011\u0001\u0004:fiJLxJ\\#se>\u0014\bc\u0002\u001f\u0004\u0014\t%\u00131\u001f\u0005\b\u0007?q\u0003\u0019AB\u0011\u00031\u0011X-];fgRdunY1m!\rY61E\u0005\u0004\u0007Ka&\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017\u0001I1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4%I\u00164\u0017-\u001e7uIU*\"aa\u000b+\t\rm1QF\u0016\u0003\u0007_\u0001Ba!\r\u0004<5\u001111\u0007\u0006\u0005\u0007k\u00199$A\u0005v]\u000eDWmY6fI*\u00191\u0011H\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004>\rM\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000691\u000f^1siV\u0004HCBA\f\u0007\u0007\u001a)\u0005C\u0004\u0002zA\u0002\r!! \t\u000f\tu\u0002\u00071\u0001\u0002t\u0006A1\u000f[;uI><h\u000e")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    /*
     * WARNING - void declaration
     */
    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        Iterable iterable;
        void inReadLock_lock;
        long now = this.time.milliseconds();
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void removeExpiredTransactionalIds() {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", () -> this.removeExpiredTransactionalIds(), (long)this.config.removeExpiredTransactionalIdsIntervalMs(), (long)this.config.removeExpiredTransactionalIdsIntervalMs());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable & scala.Serializable)x$1 -> (CoordinatorEpochAndTxnMetadata)x$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    /*
     * WARNING - void declaration
     */
    public ListTransactionsResponseData listTransactionStates(scala.collection.immutable.Set<Object> filterProducerIds, scala.collection.immutable.Set<String> filterStateNames, long filterDurationMs) {
        ListTransactionsResponseData listTransactionsResponseData;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            listTransactionsResponseData = TransactionStateManager.$anonfun$listTransactionStates$1(this, filterStateNames, filterProducerIds, filterDurationMs);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return listTransactionsResponseData;
    }

    /*
     * WARNING - void declaration
     */
    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    public Properties transactionTopicConfigs() {
        Properties props = new Properties();
        props.put("unclean.leader.election.enable", "false");
        props.put("compression.type", BrokerCompressionType.UNCOMPRESSED.name);
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put("segment.bytes", Integer.toString(this.config.transactionLogSegmentBytes()));
        return props;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    /*
     * WARNING - void declaration
     */
    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<UnifiedLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            UnifiedLog log = (UnifiedLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    void inReadLock_lock;
                    ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchIsolation.LOG_END, true);
                    readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                    Records records = fetchDataInfo.records;
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(this, loadedTransactions, currOffset, batch, topicPartition, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable & scala.Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.scheduleOnce(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), () -> {
            void loadTransactions$1_inWriteLock_lock;
            long loadTransactions$1_schedulerTimeMs = $this.time.milliseconds() - scheduleStartMs;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
            this.validateTransactionTopicPartitionCountIsStable();
            Pool<String, TransactionMetadata> loadTransactions$1_loadedTransactions = this.loadTransactionMetadata(topicPartition, coordinatorEpoch);
            long loadTransactions$1_endTimeMs = $this.time.milliseconds();
            long loadTransactions$1_totalLoadingTimeMs = loadTransactions$1_endTimeMs - scheduleStartMs;
            this.partitionLoadSensor().record((double)loadTransactions$1_totalLoadingTimeMs, loadTransactions$1_endTimeMs, false);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadTransactions$1_loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(loadTransactions$1_totalLoadingTimeMs).append(" milliseconds, of which ").append(loadTransactions$1_schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
            ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock loadTransactions$1_inWriteLock_inLock_lock = loadTransactions$1_inWriteLock_lock.writeLock();
            loadTransactions$1_inWriteLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$4(this, partitionAndLeaderEpoch, topicPartition, coordinatorEpoch, loadTransactions$1_loadedTransactions, partitionId, sendTxnMarkers);
            }
            finally {
                loadTransactions$1_inWriteLock_inLock_lock.unlock();
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, RequestLocal requestLocal) {
        void inReadLock_lock;
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((Compression)TransactionLog$.MODULE$.EnforcedCompression(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$appendTransactionToLog$13(this, transactionalId, responseCallback, coordinatorEpoch, newMetadata, recordsPerPartition, requestLocal, topicPartition, retryOnError);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
            return;
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                return false;
            }
            TransactionState transactionState = txnMetadata.state();
            if (Ongoing$.MODULE$.equals(transactionState)) {
                return txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (Iterable)((TraversableLike)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        String txnId = (String)x0$3._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                        return new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                    }
                    throw new MatchError(null);
                }, Iterable$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            int maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = (ListBuffer)ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(scala.math.package$.MODULE$.min(16384, maxBatchSize)), (Compression)TransactionLog$.MODULE$.EnforcedCompression(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)maxBatchSize);
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(156).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        };
        Map<Object, TxnMetadataCacheEntry> map = Implicits$.MODULE$.MapExtensionMethods($this.transactionMetadataCache());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = $this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(responses);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        boolean x$3 = true;
        AppendOrigin x$4 = AppendOrigin.COORDINATOR;
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable & scala.Serializable x$6 = (Function1 & Serializable & scala.Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal$.MODULE$.NoCaching();
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordValidationStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        ActionQueue x$10 = $this.replicaManager.appendRecords$default$10();
        Map<TopicPartition, VerificationGuard> x$11 = $this.replicaManager.appendRecords$default$11();
        $this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7, x$10, x$11);
    }

    private static final boolean shouldInclude$1(TransactionMetadata txnMetadata, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, long filterDurationMs$1, long now$2) {
        TransactionState transactionState = txnMetadata.state();
        Dead$ dead$ = Dead$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(dead$) : dead$ != null)) {
            return false;
        }
        if (filterProducerIds$1.nonEmpty() && !filterProducerIds$1.contains((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()))) {
            return false;
        }
        if (filterStateNames$1.nonEmpty() && !filterStates$1.contains((Object)txnMetadata.state())) {
            return false;
        }
        return filterDurationMs$1 < 0L || now$2 - txnMetadata.txnStartTimestamp() > filterDurationMs$1;
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$3(ArrayList states$1, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, long filterDurationMs$1, long now$2, int x$2, TxnMetadataCacheEntry cache) {
        cache.metadataPerTransactionalId().values().foreach((Function1 & Serializable & scala.Serializable)txnMetadata -> txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
            if (TransactionStateManager.shouldInclude$1(txnMetadata, filterProducerIds$1, filterStateNames$1, filterStates$1, filterDurationMs$1, now$2)) {
                return BoxesRunTime.boxToBoolean((boolean)states$1.add(new ListTransactionsResponseData.TransactionState().setTransactionalId(txnMetadata.transactionalId()).setProducerId(txnMetadata.producerId()).setTransactionState(txnMetadata.state().name())));
            }
            return BoxedUnit.UNIT;
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ListTransactionsResponseData $anonfun$listTransactionStates$1(TransactionStateManager $this, scala.collection.immutable.Set filterStateNames$1, scala.collection.immutable.Set filterProducerIds$1, long filterDurationMs$1) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        if ($this.loadingPartitions().nonEmpty()) {
            return response.setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        }
        Set filterStates = Set$.MODULE$.empty();
        filterStateNames$1.foreach((Function1 & Serializable & scala.Serializable)stateName -> {
            Option<TransactionState> option = TransactionState$.MODULE$.fromName((String)stateName);
            if (option instanceof Some) {
                TransactionState state = (TransactionState)((Some)option).value();
                return filterStates.$plus$eq((Object)state);
            }
            if (None$.MODULE$.equals(option)) {
                return BoxesRunTime.boxToBoolean((boolean)response.unknownStateFilters().add(stateName));
            }
            throw new MatchError(option);
        });
        long now = $this.time.milliseconds();
        ArrayList states = new ArrayList();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$2, cache) -> {
            TransactionStateManager.$anonfun$listTransactionStates$3(states, filterProducerIds$1, filterStateNames$1, filterStates, filterDurationMs$1, now, BoxesRunTime.unboxToInt((Object)x$2), cache);
            return BoxedUnit.UNIT;
        };
        Map<Object, TxnMetadataCacheEntry> map = Implicits$.MODULE$.MapExtensionMethods($this.transactionMetadataCache());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return response.setErrorCode(Errors.NONE.code()).setTransactionStates(states);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
            return scala.package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$4 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$4)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        }
        throw new MatchError((Object)option);
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(TransactionStateManager $this, Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, TopicPartition topicPartition$2, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        BaseKey baseKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        if (baseKey instanceof TxnKey) {
            String transactionalId = ((TxnKey)baseKey).transactionalId();
            Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            if (None$.MODULE$.equals(option)) {
                TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
            } else if (option instanceof Some) {
                TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
                loadedTransactions$1.put(transactionalId, txnMetadata);
            } else {
                throw new MatchError(option);
            }
            currOffset$1.elem = batch$1.nextOffset();
            return;
        }
        if (baseKey instanceof UnknownKey) {
            UnknownKey unknownKey = (UnknownKey)baseKey;
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Unknown message key with version ").append(unknownKey.version()).append(" while loading transaction state from ").append(topicPartition$2).append(". Ignoring it. ").append("It could be a left over from an aborted upgrade.").toString());
            return;
        }
        throw new MatchError((Object)baseKey);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$7(TransactionStateManager $this, int partitionId$2, Function4 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Sending txn markers for ").append(txnTransitMetadata).append(" after loading partition ").append(partitionId$2).toString());
        sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, int partitionId$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError(null);
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Sending txn markers for ").append(txnTransitMetadata).append(" after loading partition ").append(partitionId$2).toString());
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, int partitionId$2, Function4 sendTxnMarkers$1) {
        void inWriteLock_lock;
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadTransactions$1_loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(loadTransactions$1_totalLoadingTimeMs).append(" milliseconds, of which ").append(loadTransactions$1_schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$4(this, partitionAndLeaderEpoch$2, topicPartition$3, coordinatorEpoch$3, loadedTransactions, partitionId$2, sendTxnMarkers$1);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$3, TransactionPartitionAndLeaderEpoch x$5) {
        return x$5.txnPartitionId() == partitionId$3;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$3, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((TraversableOnce)$this.loadingPartitions().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$3, x$5))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3)).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$4, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$4));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var11_10 = status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            err = (Errors)((Left)var15_15).value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var23_23 instanceof Left) {
                error = (Errors)((Left)var23_23).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$appendTransactionToLog$15(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = updateCacheCallback$1_status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)updateCacheCallback$1_status));
                                var11_10 = updateCacheCallback$1_status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)updateCacheCallback$1_responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = $this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            updateCacheCallback$1_err = (Errors)((Left)var15_15).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)updateCacheCallback$1_err));
                            updateCacheCallback$1_responseError.elem = updateCacheCallback$1_err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = $this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError));
            } else if (var23_23 instanceof Left) {
                updateCacheCallback$1_error = (Errors)((Left)var23_23).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (Errors)updateCacheCallback$1_error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)updateCacheCallback$1_responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, RequestLocal requestLocal$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                boolean x$3 = true;
                AppendOrigin x$4 = AppendOrigin.COORDINATOR;
                Function1 & Serializable & scala.Serializable x$6 = arg_0 -> TransactionStateManager.$anonfun$appendTransactionToLog$15$adapted($this, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1, arg_0);
                Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
                Function1<Map<TopicPartition, RecordValidationStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
                ActionQueue x$10 = $this.replicaManager.appendRecords$default$10();
                Map<TopicPartition, VerificationGuard> x$11 = $this.replicaManager.appendRecords$default$11();
                $this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, requestLocal$1, x$10, x$11);
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor("TransactionsPartitionLoadTime");
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec"), (MeasurableStat)new Max());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec"), (MeasurableStat)new Avg());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$15$adapted(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_status));
                                var11_10 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = $this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err = (Errors)((Left)var15_15).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_err));
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = $this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError));
            } else if (var23_23 instanceof Left) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_error = (Errors)((Left)var23_23).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem));
        return BoxedUnit.UNIT;
    }
}

