/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.fault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.trogdor.fault.DegradedNetworkFaultWorker;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;

public class DegradedNetworkFaultSpec
extends TaskSpec {
    private final Map<String, NodeDegradeSpec> nodeSpecs;

    @JsonCreator
    public DegradedNetworkFaultSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="nodeSpecs") Map<String, NodeDegradeSpec> nodeSpecs) {
        super(startMs, durationMs);
        this.nodeSpecs = nodeSpecs == null ? Collections.emptyMap() : Collections.unmodifiableMap(nodeSpecs);
    }

    @Override
    public TaskController newController(String id) {
        return topology -> this.nodeSpecs.keySet();
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new DegradedNetworkFaultWorker(id, this.nodeSpecs);
    }

    @JsonProperty(value="nodeSpecs")
    public Map<String, NodeDegradeSpec> nodeSpecs() {
        return this.nodeSpecs;
    }

    public static class NodeDegradeSpec {
        private final String networkDevice;
        private final int latencyMs;
        private final int rateLimitKbit;

        public NodeDegradeSpec(@JsonProperty(value="networkDevice") String networkDevice, @JsonProperty(value="latencyMs") Integer latencyMs, @JsonProperty(value="rateLimitKbit") Integer rateLimitKbit) {
            this.networkDevice = networkDevice == null ? "" : networkDevice;
            this.latencyMs = latencyMs == null ? 0 : latencyMs;
            this.rateLimitKbit = rateLimitKbit == null ? 0 : rateLimitKbit;
        }

        @JsonProperty(value="networkDevice")
        public String networkDevice() {
            return this.networkDevice;
        }

        @JsonProperty(value="latencyMs")
        public int latencyMs() {
            return this.latencyMs;
        }

        @JsonProperty(value="rateLimitKbit")
        public int rateLimitKbit() {
            return this.rateLimitKbit;
        }

        public String toString() {
            return "NodeDegradeSpec{networkDevice='" + this.networkDevice + '\'' + ", latencyMs=" + this.latencyMs + ", rateLimitKbit=" + this.rateLimitKbit + '}';
        }
    }
}

