/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Set;
import org.apache.juneau.bean.swagger.Contact;
import org.apache.juneau.bean.swagger.License;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Info
extends SwaggerElement {
    private String siteName;
    private String title;
    private String description;
    private String termsOfService;
    private String version;
    private Contact contact;
    private License license;

    public Info() {
    }

    public Info(Info copyFrom) {
        super(copyFrom);
        this.contact = copyFrom.contact == null ? null : copyFrom.contact.copy();
        this.description = copyFrom.description;
        this.license = copyFrom.license == null ? null : copyFrom.license.copy();
        this.siteName = copyFrom.siteName;
        this.termsOfService = copyFrom.termsOfService;
        this.title = copyFrom.title;
        this.version = copyFrom.version;
    }

    public Info copy() {
        return new Info(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "contact" -> ConverterUtils.toType(this.getContact(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "license" -> ConverterUtils.toType(this.getLicense(), type);
            case "siteName" -> ConverterUtils.toType(this.getSiteName(), type);
            case "termsOfService" -> ConverterUtils.toType(this.getTermsOfService(), type);
            case "title" -> ConverterUtils.toType(this.getTitle(), type);
            case "version" -> ConverterUtils.toType(this.getVersion(), type);
            default -> super.get(property, type);
        };
    }

    public Contact getContact() {
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public License getLicense() {
        return this.license;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.contact), "contact").addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.license), "license").addIf(Utils.nn(this.siteName), "siteName").addIf(Utils.nn(this.termsOfService), "termsOfService").addIf(Utils.nn(this.title), "title").addIf(Utils.nn(this.version), "version").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Info set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "contact" -> this.setContact(ConverterUtils.toType(value, Contact.class));
            case "description" -> this.setDescription(Utils.s(value));
            case "license" -> this.setLicense(ConverterUtils.toType(value, License.class));
            case "siteName" -> this.setSiteName(Utils.s(value));
            case "termsOfService" -> this.setTermsOfService(Utils.s(value));
            case "title" -> this.setTitle(Utils.s(value));
            case "version" -> this.setVersion(Utils.s(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Info setContact(Contact value) {
        this.contact = value;
        return this;
    }

    public Info setDescription(String value) {
        this.description = value;
        return this;
    }

    public Info setLicense(License value) {
        this.license = value;
        return this;
    }

    public Info setSiteName(String value) {
        this.siteName = value;
        return this;
    }

    public Info setTermsOfService(String value) {
        this.termsOfService = value;
        return this;
    }

    public Info setTitle(String value) {
        this.title = value;
        return this;
    }

    public Info setVersion(String value) {
        this.version = value;
        return this;
    }

    @Override
    public Info strict() {
        super.strict();
        return this;
    }

    @Override
    public Info strict(Object value) {
        super.strict(value);
        return this;
    }
}

