/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.logging;

import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.Enablement;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.logging.RestLoggerRule;
import org.apache.juneau.rest.logging.RestLoggingDetail;
import org.apache.juneau.rest.stats.ThrownStats;
import org.apache.juneau.rest.stats.ThrownStore;
import org.apache.juneau.rest.util.CachingHttpServletRequest;
import org.apache.juneau.rest.util.CachingHttpServletResponse;

public class BasicRestLogger
implements RestLogger {
    private static final RestLoggerRule DEFAULT_RULE = (RestLoggerRule)RestLoggerRule.create(BeanStore.INSTANCE).build();
    private final Logger logger;
    private final ThrownStore thrownStore;
    private final RestLoggerRule[] normalRules;
    private final RestLoggerRule[] debugRules;
    private final Enablement enabled;
    private final Predicate<HttpServletRequest> enabledTest;
    private final Level level;
    private final RestLoggingDetail requestDetail;
    private final RestLoggingDetail responseDetail;

    public BasicRestLogger(RestLogger.Builder builder) {
        this.logger = builder.logger;
        this.thrownStore = builder.thrownStore;
        this.normalRules = builder.normalRules.toArray(new RestLoggerRule[builder.normalRules.size()]);
        this.debugRules = builder.debugRules.toArray(new RestLoggerRule[builder.debugRules.size()]);
        this.enabled = builder.enabled;
        this.enabledTest = builder.enabledTest;
        this.requestDetail = builder.requestDetail;
        this.responseDetail = builder.responseDetail;
        this.level = builder.level;
    }

    @Override
    public void log(HttpServletRequest req, HttpServletResponse res) {
        RestLoggerRule rule = this.getRule(req, res);
        if (!this.isEnabled(rule, req)) {
            return;
        }
        Level level = (Level)ObjectUtils.firstNonNull((Object[])new Level[]{rule.getLevel(), this.level});
        if (level == Level.OFF) {
            return;
        }
        Throwable e = (Throwable)ObjectUtils.castOrNull((Object)req.getAttribute("Exception"), Throwable.class);
        Long execTime = (Long)ObjectUtils.castOrNull((Object)req.getAttribute("ExecTime"), Long.class);
        RestLoggingDetail reqd = (RestLoggingDetail)((Object)ObjectUtils.firstNonNull((Object[])new RestLoggingDetail[]{rule.getRequestDetail(), this.requestDetail}));
        RestLoggingDetail resd = (RestLoggingDetail)((Object)ObjectUtils.firstNonNull((Object[])new RestLoggingDetail[]{rule.getResponseDetail(), this.responseDetail}));
        String method = req.getMethod();
        int status = res.getStatus();
        String uri = req.getRequestURI();
        byte[] reqContent = this.getRequestContent(req);
        byte[] resContent = this.getResponseContent(req, res);
        StringBuilder sb = new StringBuilder();
        if (reqd != RestLoggingDetail.STATUS_LINE || resd != RestLoggingDetail.STATUS_LINE) {
            sb.append("\n=== HTTP Call (incoming) ======================================================\n");
        }
        ThrownStats sti = this.getThrownStats(e);
        sb.append('[').append(status);
        if (sti != null) {
            int count = sti.getCount();
            sb.append(',').append(StringUtils.toHex8((long)sti.getHash())).append('.').append(count);
            if (count > 1) {
                e = null;
            }
        }
        sb.append("] ");
        sb.append("HTTP ").append(method).append(' ').append(uri);
        if (reqd != RestLoggingDetail.STATUS_LINE || resd != RestLoggingDetail.STATUS_LINE) {
            Enumeration hh;
            String qs;
            if (reqd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY) && (qs = req.getQueryString()) != null) {
                sb.append('?').append(qs);
            }
            if (reqContent != null && reqd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY)) {
                sb.append("\n\tRequest length: ").append(reqContent.length).append(" bytes");
            }
            if (resd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY)) {
                sb.append("\n\tResponse code: ").append(status);
            }
            if (resContent != null && resd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY)) {
                sb.append("\n\tResponse length: ").append(resContent.length).append(" bytes");
            }
            if (execTime != null && resd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY)) {
                sb.append("\n\tExec time: ").append(execTime).append("ms");
            }
            if (reqd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY) && (hh = req.getHeaderNames()).hasMoreElements()) {
                sb.append("\n---Request Headers---");
                while (hh.hasMoreElements()) {
                    String h = (String)hh.nextElement();
                    sb.append("\n\t").append(h).append(": ").append(req.getHeader(h));
                }
            }
            if (resd.isOneOf(RestLoggingDetail.HEADER, RestLoggingDetail.ENTITY) && (hh = res.getHeaderNames()).size() > 0) {
                sb.append("\n---Response Headers---");
                for (String h : hh) {
                    sb.append("\n\t").append(h).append(": ").append(res.getHeader(h));
                }
            }
            if (reqContent != null && reqContent.length > 0 && reqd == RestLoggingDetail.ENTITY) {
                try {
                    sb.append("\n---Request Content UTF-8---");
                    sb.append("\n").append(new String(reqContent, IOUtils.UTF8));
                    sb.append("\n---Request Content Hex---");
                    sb.append("\n").append(StringUtils.toSpacedHex((byte[])reqContent));
                }
                catch (Exception e1) {
                    sb.append("\n").append(e1.getLocalizedMessage());
                }
            }
            if (resContent != null && resContent.length > 0 && resd == RestLoggingDetail.ENTITY) {
                try {
                    sb.append("\n---Response Content UTF-8---");
                    sb.append("\n").append(new String(resContent, IOUtils.UTF8));
                    sb.append("\n---Response Content Hex---");
                    sb.append("\n").append(StringUtils.toSpacedHex((byte[])resContent));
                }
                catch (Exception e1) {
                    sb.append(e1.getLocalizedMessage());
                }
            }
            sb.append("\n=== END ======================================================================");
        }
        if (rule.isLogStackTrace() && e == null) {
            e = new Throwable("Stacktrace");
        }
        this.log(level, sb.toString(), e);
    }

    protected RestLoggerRule getRule(HttpServletRequest req, HttpServletResponse res) {
        for (RestLoggerRule r : this.isDebug(req) ? this.debugRules : this.normalRules) {
            if (!r.matches(req, res)) continue;
            return r;
        }
        return DEFAULT_RULE;
    }

    protected boolean isDebug(HttpServletRequest req) {
        return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{(Boolean)ObjectUtils.castOrNull((Object)req.getAttribute("Debug"), Boolean.class), false});
    }

    protected boolean isEnabled(RestLoggerRule rule, HttpServletRequest req) {
        Enablement enabled = (Enablement)ObjectUtils.firstNonNull((Object[])new Enablement[]{rule.getEnabled(), this.enabled});
        Predicate enabledTest = (Predicate)ObjectUtils.firstNonNull((Object[])new Predicate[]{rule.getEnabledTest(), this.enabledTest});
        return enabled.isEnabled(enabledTest.test(req));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected void log(Level level, String msg, Throwable e) {
        this.getLogger().log(level, msg, e);
    }

    private byte[] getRequestContent(HttpServletRequest req) {
        if (req instanceof CachingHttpServletRequest) {
            return ((CachingHttpServletRequest)req).getContent();
        }
        return (byte[])ObjectUtils.castOrNull((Object)req.getAttribute("RequestContent"), byte[].class);
    }

    private byte[] getResponseContent(HttpServletRequest req, HttpServletResponse res) {
        if (res instanceof CachingHttpServletResponse) {
            return ((CachingHttpServletResponse)res).getContent();
        }
        return (byte[])ObjectUtils.castOrNull((Object)req.getAttribute("ResponseContent"), byte[].class);
    }

    private ThrownStats getThrownStats(Throwable e) {
        if (e == null || this.thrownStore == null) {
            return null;
        }
        return this.thrownStore.getStats(e).orElse(null);
    }

    public String toString() {
        return JsonMap.filteredMap().append("logger", (Object)this.logger).append("thrownStore", (Object)this.thrownStore).append("enabled", (Object)this.enabled).append("level", (Object)this.level).append("requestDetail", (Object)this.requestDetail).append("responseDetail", (Object)this.responseDetail).append("normalRules", (Object)(this.normalRules.length == 0 ? null : this.normalRules)).append("debugRules", (Object)(this.debugRules.length == 0 ? null : this.debugRules)).asReadableString();
    }
}

