/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.Set;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.http.annotation.AnnotationUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.utils.ASet;

public class SchemaUtils {
    public static ObjectMap asMap(Schema a) throws ParseException {
        if (a == null) {
            return ObjectMap.EMPTY_MAP;
        }
        ObjectMap om = new ObjectMap();
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.appendSkipEmpty("additionalProperties", SchemaUtils.toObjectMap(a.additionalProperties())).appendSkipEmpty("allOf", StringUtils.joinnl(a.allOf())).appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", StringUtils.joinnl(a._default())).appendSkipEmpty("discriminator", a.discriminator()).appendSkipEmpty("description", StringUtils.joinnl(a.description())).appendSkipEmpty("enum", SchemaUtils.toSet(a._enum())).appendSkipEmpty("examples", SchemaUtils.parseMap(a.examples())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("externalDocs", SchemaUtils.merge(om.getObjectMap("externalDocs"), a.externalDocs())).appendSkipEmpty("format", a.format()).appendSkipEmpty("ignore", a.ignore() ? "true" : null).appendSkipEmpty("items", SchemaUtils.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipMinusOne("maxProperties", a.maxProperties()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipMinusOne("minProperties", a.minProperties()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipEmpty("properties", SchemaUtils.toObjectMap(a.properties())).appendSkipFalse("readOnly", a.readOnly()).appendSkipFalse("required", a.required()).appendSkipEmpty("title", a.title()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("xml", StringUtils.joinnl(a.xml())).appendSkipEmpty("x-example", StringUtils.joinnl(a.example())).appendSkipEmpty("$ref", a.$ref());
    }

    private static ObjectMap toObjectMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = StringUtils.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isObjectMap(s, true)) {
            s = "{" + s + "}";
        }
        return new ObjectMap(s);
    }

    private static ObjectMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = StringUtils.joinnl((String[])o);
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s)) {
                return new ObjectMap().append("ignore", true);
            }
            if (!StringUtils.isObjectMap(s, true)) {
                s = "{" + s + "}";
            }
            return new ObjectMap(s);
        }
        if (o instanceof ObjectMap) {
            return (ObjectMap)o;
        }
        throw new ParseException("Unexpected data type ''{0}''.  Expected ObjectMap or String.", o.getClass().getName());
    }

    private static Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = StringUtils.joinnl(ss);
        if (s.isEmpty()) {
            return null;
        }
        ASet<String> set = new ASet<String>();
        for (Object o : StringUtils.parseListOrCdl(s)) {
            set.add(o.toString());
        }
        return set;
    }

    private static ObjectMap merge(ObjectMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", StringUtils.joinnl(a._default())).appendSkipEmpty("enum", SchemaUtils.toSet(a._enum())).appendSkipEmpty("format", a.format()).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("items", SchemaUtils.merge(om.getObjectMap("items"), a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("type", a.type()).appendSkipEmpty("$ref", a.$ref());
    }

    private static ObjectMap merge(ObjectMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.appendSkipEmpty("collectionFormat", a.collectionFormat()).appendSkipEmpty("default", StringUtils.joinnl(a._default())).appendSkipEmpty("enum", SchemaUtils.toSet(a._enum())).appendSkipFalse("exclusiveMaximum", a.exclusiveMaximum()).appendSkipFalse("exclusiveMinimum", a.exclusiveMinimum()).appendSkipEmpty("format", a.format()).appendSkipEmpty("items", SchemaUtils.toObjectMap(a.items())).appendSkipEmpty("maximum", a.maximum()).appendSkipMinusOne("maxItems", a.maxItems()).appendSkipMinusOne("maxLength", a.maxLength()).appendSkipEmpty("minimum", a.minimum()).appendSkipMinusOne("minItems", a.minItems()).appendSkipMinusOne("minLength", a.minLength()).appendSkipEmpty("multipleOf", a.multipleOf()).appendSkipEmpty("pattern", a.pattern()).appendSkipEmpty("type", a.type()).appendSkipFalse("uniqueItems", a.uniqueItems()).appendSkipEmpty("$ref", a.$ref());
    }

    private static ObjectMap merge(ObjectMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.appendSkipEmpty("description", StringUtils.joinnl(a.description())).appendSkipEmpty("url", a.url());
    }
}

