/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.serializer.WriterSerializer;

public class JuneauLogger
extends Logger {
    private static final WriterSerializer serializer = JsonSerializer.create().ssq().build();
    private static final ConcurrentHashMap<Class<?>, String> rbMap = new ConcurrentHashMap();
    private final ResourceBundle rb;
    private final Logger innerLogger;

    public static JuneauLogger getLogger(Class<?> forClass) {
        return JuneauLogger.getLogger(forClass.getName());
    }

    public static JuneauLogger getLogger(String loggerName) {
        return new JuneauLogger(Logger.getLogger(loggerName));
    }

    public static JuneauLogger getLogger(Class<?> forClass, String resourceBundleName) {
        return new JuneauLogger(Logger.getLogger(forClass.getName(), JuneauLogger.resolveResourceBundleName(forClass, resourceBundleName)));
    }

    public static synchronized JuneauLogger getLogger(String name, String resourceBundleName) {
        return new JuneauLogger(Logger.getLogger(name, resourceBundleName));
    }

    protected JuneauLogger(Logger innerLogger) {
        super(innerLogger.getName(), innerLogger.getResourceBundleName());
        this.innerLogger = innerLogger;
        this.rb = this.getResourceBundle();
    }

    public void severe(String msg, Object ... args) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, msg, args);
        }
    }

    public void warning(String msg, Object ... args) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg, args);
        }
    }

    public void info(String msg, Object ... args) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg, args);
        }
    }

    public void config(String msg, Object ... args) {
        if (this.isLoggable(Level.CONFIG)) {
            this.log(Level.CONFIG, msg, args);
        }
    }

    public void fine(String msg, Object ... args) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg, args);
        }
    }

    public void finer(String msg, Object ... args) {
        if (this.isLoggable(Level.FINER)) {
            this.log(Level.FINER, msg, args);
        }
    }

    public void finest(String msg, Object ... args) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, msg, args);
        }
    }

    public void severe(Throwable t) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, t.getLocalizedMessage(), t);
        }
    }

    public void warning(Throwable t) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, t.getLocalizedMessage(), t);
        }
    }

    public void severe(Throwable t, String msg, Object ... args) {
        if (this.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, this.getMessage(msg, args), t);
        }
    }

    public void warning(Throwable t, String msg, Object ... args) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, this.getMessage(msg, args), t);
        }
    }

    public void info(Throwable t, String msg, Object ... args) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, this.getMessage(msg, args), t);
        }
    }

    @Override
    public void log(LogRecord record) {
        this.innerLogger.log(record);
    }

    public void log(Level level, Throwable cause, String msg, Object ... args) {
        if (this.isLoggable(level)) {
            this.log(level, this.getMessage(msg, args), cause);
        }
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.innerLogger.isLoggable(level);
    }

    public void logObjects(Level level, String msg, Object ... args) {
        if (this.isLoggable(level)) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = serializer.toStringObject(args[i]);
            }
            this.log(level, msg, args);
        }
    }

    private String getMessage(String msg, Object ... args) {
        if (args.length == 0) {
            return msg;
        }
        if (this.rb != null && this.rb.containsKey(msg)) {
            msg = this.rb.getString(msg);
        }
        return StringUtils.format(msg, args);
    }

    private static String resolveResourceBundleName(Class<?> forClass, String path) {
        if (StringUtils.isEmpty(path)) {
            return null;
        }
        String rb = rbMap.get(forClass);
        if (rb == null) {
            if ((path = path.replace('/', '.')).startsWith(".")) {
                path = path.substring(1);
            }
            ClassLoader cl = forClass.getClassLoader();
            try {
                ResourceBundle.getBundle(path, Locale.getDefault(), cl);
                rbMap.putIfAbsent(forClass, path);
            }
            catch (MissingResourceException e) {
                try {
                    path = forClass.getPackage().getName() + '.' + path;
                    ResourceBundle.getBundle(path, Locale.getDefault(), cl);
                    rbMap.putIfAbsent(forClass, path);
                }
                catch (MissingResourceException e2) {
                    rbMap.putIfAbsent(forClass, "");
                }
            }
            rb = rbMap.get(forClass);
        }
        return "".equals(rb) ? null : rb;
    }
}

