/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.ConfigException;
import org.apache.juneau.internal.ClassUtils;

public interface PropertyConverter<T> {
    public static final PropertyConverter<String> STRING_CONVERTER = new PropertyConverter<String>(){

        @Override
        public String convert(Object o) {
            return ClassUtils.toString(o);
        }
    };
    public static final PropertyConverter<Integer> INTEGER_CONVERTER = new PropertyConverter<Integer>(){

        @Override
        public Integer convert(Object o) {
            try {
                if (o instanceof Integer) {
                    return (Integer)o;
                }
                return Integer.valueOf(o.toString());
            }
            catch (Exception e) {
                throw new ConfigException("Value ''{0}'' ({1}) cannot be converted to an Integer.", o, o.getClass().getSimpleName());
            }
        }
    };
    public static final PropertyConverter<Boolean> BOOLEAN_CONVERTER = new PropertyConverter<Boolean>(){

        @Override
        public Boolean convert(Object o) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.parseBoolean(o.toString());
        }
    };
    public static final PropertyConverter<Class<?>> CLASS_CONVERTER = new PropertyConverter<Class<?>>(){

        @Override
        public Class<?> convert(Object o) {
            try {
                if (o instanceof Class) {
                    return (Class)o;
                }
                throw new ConfigException("Value ''{0}'' ({1}) cannot be converted to a Class.", o, o.getClass().getSimpleName());
            }
            catch (Exception e) {
                throw new ConfigException("Value ''{0}'' ({1}) cannot be converted to a Class.", o, o.getClass().getSimpleName());
            }
        }
    };
    public static final PropertyConverter<Object> OBJECT_CONVERTER = new PropertyConverter<Object>(){

        @Override
        public Object convert(Object o) {
            return o;
        }
    };

    public T convert(Object var1);
}

