/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui;

import com.github.weisj.darklaf.color.ColorUtil;
import com.github.weisj.darklaf.platform.DecorationsHandler;
import com.github.weisj.darklaf.uiresource.DarkColorUIResource;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.Pair;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;

public class DarkPopupFactory
extends PopupFactory {
    private static final Logger LOGGER = LogUtil.getLogger(DarkPopupFactory.class);
    public static final String KEY_NO_DECORATION = "JPopupFactory.noDecorations";
    public static final String KEY_FOCUSABLE_POPUP = "JPopupFactory.focusablePopup";
    public static final String KEY_FORCE_HEAVYWEIGHT = "JPopupFactory.forceHeavyweight";
    public static final String KEY_OPAQUE = "JPopupFactory.opaque";
    public static final String KEY_START_HIDDEN = "JPopupFactory.startHidden";
    public static final String KEY_DOUBLE_BUFFERED = "JPopupFactory.doubleBuffered";
    private HeavyWeightParent heavyWeightParent;

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        Pair<Popup, PopupType> result = this.getEffectivePopup(owner, contents, x, y);
        Popup popup = (Popup)result.getFirst();
        PopupType type = (PopupType)((Object)result.getSecond());
        this.setupPopup(type, contents, x, y);
        return popup;
    }

    protected Pair<Popup, PopupType> getEffectivePopup(Component owner, Component contents, int x, int y) {
        Popup popup = super.getPopup(owner, contents, x, y);
        PopupType type = DarkPopupFactory.getPopupType(popup);
        boolean forceHeavy = type != PopupType.HEAVY_WEIGHT && PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_FORCE_HEAVYWEIGHT);
        LOGGER.fine("Received popup of type " + (Object)((Object)type) + "  but requested a heavy weight popup.");
        if (forceHeavy) {
            LOGGER.fine("Forcing heavy weight popup");
            Window targetWindow = DarkUIUtil.getWindow(owner);
            popup = super.getPopup(this.getHeavyWeightParent(targetWindow), contents, x, y);
            type = PopupType.HEAVY_WEIGHT;
        }
        if (type == PopupType.HEAVY_WEIGHT) {
            Window window = DarkUIUtil.getWindow(contents);
            if (owner != null && window != null && !Objects.equals(window.getGraphicsConfiguration(), owner.getGraphicsConfiguration())) {
                window.setFocusableWindowState(true);
                popup = super.getPopup(this.getHeavyWeightParent(DarkUIUtil.getWindow(owner)), contents, x, y);
                window = DarkUIUtil.getWindow(contents);
            }
            if (window != null) {
                window.setLocation(x, y);
            }
        }
        return new Pair((Object)popup, (Object)type);
    }

    public static PopupType getPopupType(Popup popup) {
        String popupClassName = popup.getClass().getSimpleName();
        if (popupClassName.endsWith("LightWeightPopup")) {
            return PopupType.LIGHT_WEIGHT;
        }
        if (popupClassName.endsWith("MediumWeightPopup")) {
            return PopupType.MEDIUM_WEIGHT;
        }
        return PopupType.HEAVY_WEIGHT;
    }

    protected void setupPopup(PopupType type, Component contents, int x, int y) {
        Window window;
        if (type == PopupType.MEDIUM_WEIGHT) {
            JRootPane rootPane = SwingUtilities.getRootPane(contents);
            if (rootPane != null) {
                rootPane.putClientProperty("JRootPane.noDecorationsUpdate", true);
            }
        } else if (type == PopupType.HEAVY_WEIGHT && (window = SwingUtilities.getWindowAncestor(contents)) != null) {
            LOGGER.fine(() -> "Configuring popup for " + contents);
            boolean isFocusable = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_FOCUSABLE_POPUP);
            boolean startHidden = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_START_HIDDEN);
            this.setupHeavyWeightWindow(window, contents, isFocusable, startHidden);
            window.setLocation(x, y);
        }
    }

    protected void setupHeavyWeightWindow(Window window, Component contents, boolean isFocusable, boolean startHidden) {
        JRootPane rootPane;
        boolean noDecorations = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_NO_DECORATION);
        boolean opaque = PropertyUtil.getBooleanProperty((Component)contents, (String)KEY_OPAQUE, (boolean)true);
        LOGGER.fine("Popup config [noDecorations: " + noDecorations + ", opaque: " + opaque + "]");
        JRootPane jRootPane = rootPane = window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)window)).getRootPane() : null;
        if (rootPane != null && contents instanceof Container) {
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add(contents);
            rootPane.setContentPane(contentPane);
        }
        this.setupFocusableWindowState(isFocusable, window);
        this.setupWindowBackground(window, rootPane, contents, opaque, !noDecorations);
        this.setupWindowDecorations(window, rootPane, noDecorations);
        this.setupWindowOpacity(startHidden, window);
    }

    protected void setupWindowBackground(Window window, JRootPane rootPane, Component content, boolean opaque, boolean decorations) {
        if (rootPane == null) {
            return;
        }
        Color bg = opaque ? ColorUtil.toAlpha((Color)rootPane.getBackground(), (int)255) : this.getTranslucentPopupBackground(decorations);
        Container p = content.getParent();
        if (!opaque) {
            boolean doubleBufferHint = PropertyUtil.getBooleanProperty((Component)content, (String)KEY_DOUBLE_BUFFERED);
            LOGGER.fine("Content wants to be double buffered = " + doubleBufferHint);
            this.setupDoubleBuffering(rootPane, doubleBufferHint);
        }
        while (p != null && p != window) {
            p.setBackground(bg);
            if (p instanceof JComponent) {
                ((JComponent)p).setOpaque(opaque);
            }
            p = p.getParent();
        }
        window.setBackground(bg);
    }

    private void setupDoubleBuffering(JRootPane rootPane, boolean doubleBufferHint) {
        boolean isLinuxJava8 = !SystemInfo.isJava9OrGreater && SystemInfo.isLinux;
        boolean useDoubleBuffering = (isLinuxJava8 || doubleBufferHint) && DarkPopupFactory.canApplyRootPaneFix();
        LOGGER.fine("Content can use double buffering = " + useDoubleBuffering);
        rootPane.setDoubleBuffered(useDoubleBuffering);
        this.setUseDoubleBuffer(rootPane, useDoubleBuffering);
        this.setUseDoubleBuffer(rootPane.getGlassPane(), useDoubleBuffering);
        this.setUseDoubleBuffer(rootPane.getLayeredPane(), useDoubleBuffering);
        this.setUseDoubleBuffer(rootPane.getContentPane(), useDoubleBuffering);
        if (useDoubleBuffering && DarkPopupFactory.canApplyRootPaneFix()) {
            LOGGER.fine("Applying linux double buffer fix");
            try {
                Method method = JRootPane.class.getDeclaredMethod("setUseTrueDoubleBuffering", Boolean.TYPE);
                method.setAccessible(true);
                method.invoke((Object)rootPane, true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void setUseDoubleBuffer(Component c, boolean enabled) {
        if (c instanceof JComponent) {
            this.setUseDoubleBuffer((JComponent)c, enabled);
        }
    }

    private void setUseDoubleBuffer(JComponent c, boolean enabled) {
        if (c != null) {
            c.setDoubleBuffered(enabled);
        }
    }

    public static boolean canApplyRootPaneFix() {
        return !SystemInfo.isJava9OrGreater;
    }

    protected void setupFocusableWindowState(boolean isFocusable, Window window) {
        if (isFocusable && !window.getFocusableWindowState()) {
            LOGGER.fine("Window isn't focusable but needs to be. Disposing the window");
            window.dispose();
            window.setFocusableWindowState(true);
        }
    }

    protected void setupWindowDecorations(Window window, JRootPane rootPane, boolean noDecorations) {
        if (rootPane != null) {
            rootPane.putClientProperty("Window.shadow", !noDecorations);
        }
        if (noDecorations) {
            DecorationsHandler.getSharedInstance().uninstallPopupWindow(window);
        } else if (DecorationsHandler.getSharedInstance().isCustomDecorationSupported()) {
            DecorationsHandler.getSharedInstance().installPopupWindow(window);
        }
    }

    protected void setupWindowOpacity(boolean startHidden, Window window) {
        boolean translucencySupported = GraphicsUtil.supportsTransparency((Window)window);
        LOGGER.fine("Window supports opacity (translucency + per pixel translucency) = " + translucencySupported);
        if (startHidden && translucencySupported) {
            try {
                window.setOpacity(0.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected HeavyWeightParent getHeavyWeightParent(Container owner) {
        if (this.heavyWeightParent == null) {
            Box box = Box.createHorizontalBox();
            super.getPopup(null, box, 0, 0);
            this.heavyWeightParent = new HeavyWeightParent(DarkUIUtil.getWindow(box));
        }
        this.heavyWeightParent.setOwner(owner);
        return this.heavyWeightParent;
    }

    protected Color getTranslucentPopupBackground(boolean decorated) {
        Color c = UIManager.getColor("PopupMenu.translucentBackground");
        if (!decorated) {
            c = new DarkColorUIResource(ColorUtil.toAlpha((Color)c, (int)0));
        }
        return c;
    }

    public static enum PopupType {
        LIGHT_WEIGHT,
        MEDIUM_WEIGHT,
        HEAVY_WEIGHT;

    }

    private static class HeavyWeightParent
    extends JComponent {
        private int parentRequestCount = 0;
        private final Window heavyWeightParent;
        private Container owner;

        private HeavyWeightParent(Window heavyWeightParent) {
            this.heavyWeightParent = heavyWeightParent;
        }

        public void setOwner(Container owner) {
            this.parentRequestCount = 0;
            this.owner = owner;
        }

        @Override
        public GraphicsConfiguration getGraphicsConfiguration() {
            return super.getGraphicsConfiguration();
        }

        @Override
        public Container getParent() {
            if (this.parentRequestCount == 0) {
                ++this.parentRequestCount;
                return this.heavyWeightParent;
            }
            return this.owner;
        }
    }

    private static class WrapperRootPane
    extends JRootPane
    implements RootPaneContainer {
        private WrapperRootPane() {
        }

        @Override
        public void updateUI() {
            this.setUI(new RootPaneUI(){});
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public JRootPane getRootPane() {
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
        }

        @Override
        public void doLayout() {
            int w = this.getWidth();
            int h = this.getHeight();
            this.layout(this.getLayeredPane(), w, h);
            this.layout(this.getGlassPane(), w, h);
            this.layout(this.getContentPane(), w, h);
        }

        private void layout(Component c, int w, int h) {
            c.setBounds(0, 0, w, h);
            c.doLayout();
        }
    }
}

