/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.sql.Date;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.exparity.hamcrest.date.core.TemporalConversionException;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.exparity.hamcrest.date.core.types.DayOfMonth;
import org.exparity.hamcrest.date.core.types.Hour;
import org.exparity.hamcrest.date.core.types.Millisecond;
import org.exparity.hamcrest.date.core.types.Minute;
import org.exparity.hamcrest.date.core.types.Second;

public class TemporalProviders {
    private TemporalProviders() {
    }

    public static TemporalProvider<Date> sqlDate(java.util.Date date) {
        if (date instanceof Date) {
            return TemporalProviders.sqlDate((Date)date);
        }
        return z -> new Date(date.getTime());
    }

    public static TemporalProvider<Date> sqlDate(Date date) {
        return z -> date;
    }

    public static TemporalProvider<java.util.Date> javaDate(java.util.Date date) {
        if (date instanceof Date) {
            return zone -> new java.util.Date(date.getTime());
        }
        return zone -> java.util.Date.from(TemporalProviders.instant(date).apply(zone));
    }

    public static TemporalProvider<java.util.Date> javaDate(Date date) {
        throw new TemporalConversionException("java.sql.Date does not support time-based comparisons. Prefer SqlDateMatchers for java.sql.Date appropriate matchers");
    }

    public static TemporalProvider<Instant> instant(java.util.Date date) {
        return zone -> TemporalProviders.zonedDateTime(date).apply(zone).toInstant();
    }

    public static TemporalProvider<Instant> instant(Instant instant) {
        return zone -> zone.map(z -> instant.atZone((ZoneId)z).toInstant()).orElse(instant);
    }

    public static TemporalProvider<Instant> instant(Date date) {
        throw new TemporalConversionException("java.sql.Date does not support time-based comparisons. Prefer SqlDateMatchers for java.sql.Date appropriate matchers");
    }

    public static TemporalProvider<LocalDate> localDate(LocalDate date) {
        return zone -> date;
    }

    public static TemporalProvider<LocalDate> localDate(Instant date) {
        return zone -> TemporalConverters.INSTANT_AS_LOCALDATE.apply(date, zone);
    }

    public static TemporalProvider<LocalDate> localDate(ZonedDateTime date) {
        return zone -> TemporalProviders.zonedDateTime(date).apply(zone).toLocalDate();
    }

    public static TemporalProvider<LocalDate> localDate(OffsetDateTime date) {
        return zone -> TemporalProviders.offsetDateTime(date).apply(zone).toLocalDate();
    }

    public static TemporalProvider<LocalDate> localDate(LocalDateTime date) {
        return zone -> TemporalProviders.localDateTime(date).apply(zone).toLocalDate();
    }

    public static TemporalProvider<LocalDate> localDate(java.util.Date date) {
        if (date instanceof Date) {
            return zone -> ((Date)date).toLocalDate();
        }
        return zone -> TemporalProviders.zonedDateTime(date).apply(zone).toLocalDate();
    }

    public static TemporalProvider<LocalDateTime> localDateTime(LocalDateTime date) {
        return zone -> date;
    }

    public static TemporalProvider<ZonedDateTime> zonedDateTime(ZonedDateTime date) {
        return zone -> zone.map(z -> date.withZoneSameInstant((ZoneId)z)).orElse(date);
    }

    public static TemporalProvider<ZonedDateTime> zonedDateTime(java.util.Date date) {
        if (date instanceof Date) {
            return TemporalProviders.zonedDateTime((Date)date);
        }
        return zone -> TemporalProviders.zonedDateTime(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault())).apply(zone);
    }

    public static TemporalProvider<ZonedDateTime> zonedDateTime(Date date) {
        throw new TemporalConversionException("java.sql.Date does not support time-based comparisons. Prefer SqlDateMatchers for java.sql.Date appropriate matchers");
    }

    public static TemporalProvider<OffsetDateTime> offsetDateTime(OffsetDateTime date) {
        return zone -> zone.map(z -> date.withOffsetSameInstant(z.getRules().getOffset(date.toLocalDateTime()))).orElse(date);
    }

    public static TemporalProvider<OffsetDateTime> offsetDateTime(java.util.Date date) {
        if (date instanceof Date) {
            return TemporalProviders.offsetDateTime((Date)date);
        }
        return zone -> TemporalProviders.offsetDateTime(OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault())).apply(zone);
    }

    public static TemporalProvider<OffsetDateTime> offsetDateTime(Date date) {
        throw new TemporalConversionException("java.sql.Date does not support time-based comparisons. Prefer SqlDateMatchers for java.sql.Date appropriate matchers");
    }

    public static TemporalProvider<LocalTime> localTime(LocalTime time) {
        return zone -> time;
    }

    public static TemporalProvider<Year> year(ZonedDateTime date) {
        return zone -> Year.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Year> year(OffsetDateTime date) {
        return zone -> Year.from(TemporalProviders.offsetDateTime(date).apply(zone));
    }

    public static TemporalProvider<Year> year(LocalDateTime date) {
        return zone -> Year.from(date);
    }

    public static TemporalProvider<Year> year(LocalDate date) {
        return zone -> Year.from(date);
    }

    public static TemporalProvider<Year> year(Integer year) {
        return zone -> Year.of(year);
    }

    public static TemporalProvider<Year> year(Instant instant) {
        return zone -> TemporalConverters.INSTANT_AS_YEAR.apply(instant, zone);
    }

    public static TemporalProvider<Year> year(java.util.Date date) {
        return zone -> Year.from(TemporalProviders.localDate(date).apply(zone));
    }

    public static TemporalProvider<Month> month(OffsetDateTime date) {
        return zone -> TemporalProviders.offsetDateTime(date).apply(zone).getMonth();
    }

    public static TemporalProvider<Month> month(Instant date) {
        return zone -> TemporalConverters.INSTANT_AS_MONTH.apply(date, zone);
    }

    public static TemporalProvider<Month> month(ZonedDateTime date) {
        return zone -> TemporalProviders.zonedDateTime(date).apply(zone).getMonth();
    }

    public static TemporalProvider<Month> month(LocalDateTime date) {
        return zone -> date.getMonth();
    }

    public static TemporalProvider<Month> month(LocalDate date) {
        return zone -> date.getMonth();
    }

    public static TemporalProvider<Month> month(Month month) {
        return zone -> month;
    }

    public static TemporalProvider<Month> month(java.util.Date date) {
        return zone -> TemporalProviders.localDate(date).apply(zone).getMonth();
    }

    public static TemporalProvider<List<DayOfWeek>> dayOfWeek(ZonedDateTime date) {
        return zone -> Arrays.asList(TemporalProviders.zonedDateTime(date).apply(zone).getDayOfWeek());
    }

    public static TemporalProvider<List<DayOfWeek>> daysOfWeek(LocalDateTime date) {
        return zone -> Arrays.asList(date.getDayOfWeek());
    }

    public static TemporalProvider<List<DayOfWeek>> daysOfWeek(LocalDate date) {
        return zone -> Arrays.asList(date.getDayOfWeek());
    }

    public static TemporalProvider<List<DayOfWeek>> daysOfWeek(DayOfWeek ... dayOfWeek) {
        return zone -> Arrays.asList(dayOfWeek);
    }

    public static TemporalProvider<List<DayOfWeek>> daysOfWeek(DayOfWeek dayOfWeek) {
        return zone -> Arrays.asList(dayOfWeek);
    }

    public static TemporalProvider<List<DayOfWeek>> daysOfWeek(java.util.Date date) {
        return zone -> Arrays.asList(TemporalProviders.localDate(date).apply(zone).getDayOfWeek());
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(ZonedDateTime date) {
        return zone -> DayOfMonth.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(Instant date) {
        return zone -> TemporalConverters.INSTANT_AS_DAYOFMONTH.apply(date, zone);
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(OffsetDateTime date) {
        return zone -> DayOfMonth.from(TemporalProviders.offsetDateTime(date).apply(zone));
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(int dayOfMonth) {
        return zone -> DayOfMonth.of(dayOfMonth);
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(LocalDateTime date) {
        return zone -> DayOfMonth.from(date);
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(LocalDate date) {
        return zone -> DayOfMonth.from(date);
    }

    public static TemporalProvider<DayOfMonth> dayOfMonth(java.util.Date date) {
        return zone -> DayOfMonth.from(TemporalProviders.localDate(date).apply(zone));
    }

    public static TemporalProvider<Hour> hour(java.util.Date date) {
        return zone -> Hour.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Hour> hour(Instant date) {
        return zone -> TemporalConverters.INSTANT_AS_HOUR.apply(date, zone);
    }

    public static TemporalProvider<Hour> hour(int hour) {
        return zone -> Hour.of(hour);
    }

    public static TemporalProvider<Hour> hour(LocalDateTime date) {
        return zone -> Hour.from(date);
    }

    public static TemporalProvider<Hour> hour(ZonedDateTime date) {
        return zone -> Hour.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Hour> hour(OffsetDateTime date) {
        return zone -> Hour.from(TemporalProviders.offsetDateTime(date).apply(zone));
    }

    public static TemporalProvider<Hour> hour(LocalTime time) {
        return zone -> Hour.from(time);
    }

    public static TemporalProvider<Minute> minute(java.util.Date date) {
        return zone -> Minute.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Minute> minute(int minute) {
        return zone -> Minute.of(minute);
    }

    public static TemporalProvider<Minute> minute(LocalDateTime date) {
        return zone -> Minute.from(date);
    }

    public static TemporalProvider<Minute> minute(ZonedDateTime date) {
        return zone -> Minute.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Minute> minute(OffsetDateTime date) {
        return zone -> Minute.from(TemporalProviders.offsetDateTime(date).apply(zone));
    }

    public static TemporalProvider<Minute> minute(LocalTime time) {
        return zone -> Minute.from(time);
    }

    public static TemporalProvider<Minute> minute(Instant date) {
        return zone -> TemporalConverters.INSTANT_AS_MINUTE.apply(date, zone);
    }

    public static TemporalProvider<Second> second(java.util.Date date) {
        return zone -> Second.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Second> second(Instant date) {
        return zone -> TemporalConverters.INSTANT_AS_SECOND.apply(date, zone);
    }

    public static TemporalProvider<Second> second(Integer second) {
        return zone -> Second.of(second);
    }

    public static TemporalProvider<Second> second(LocalTime time) {
        return zone -> Second.from(time);
    }

    public static TemporalProvider<Second> second(LocalDateTime date) {
        return zone -> Second.from(date);
    }

    public static TemporalProvider<Second> second(ZonedDateTime date) {
        return zone -> Second.from(TemporalProviders.zonedDateTime(date).apply(zone));
    }

    public static TemporalProvider<Second> second(OffsetDateTime date) {
        return zone -> Second.from(TemporalProviders.offsetDateTime(date).apply(zone));
    }

    public static TemporalProvider<Millisecond> millisecondOfMinute(java.util.Date date) {
        return zone -> Millisecond.from(TemporalProviders.instant(date).apply(zone));
    }

    public static TemporalProvider<Millisecond> millisecondOfMinute(int millisecond) {
        return zone -> Millisecond.of(millisecond);
    }
}

