/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2;

import org.jdom2.Content;
import org.jdom2.IllegalDataException;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.jdom2.Verifier;

public class CDATA
extends Text {
    private static final long serialVersionUID = 200L;

    protected CDATA() {
        super(Content.CType.CDATA);
    }

    public CDATA(String string) {
        super(Content.CType.CDATA);
        this.setText(string);
    }

    public CDATA setText(String str2) {
        if (str2 == null || "".equals(str2)) {
            this.value = "";
            return this;
        }
        String reason = Verifier.checkCDATASection(str2);
        if (reason != null) {
            throw new IllegalDataException(str2, "CDATA section", reason);
        }
        this.value = str2;
        return this;
    }

    public void append(String str2) {
        if (str2 == null || "".equals(str2)) {
            return;
        }
        String tmpValue = this.value == "" ? str2 : this.value + str2;
        String reason = Verifier.checkCDATASection(tmpValue);
        if (reason != null) {
            throw new IllegalDataException(str2, "CDATA section", reason);
        }
        this.value = tmpValue;
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.append(text.getText());
    }

    public String toString() {
        return new StringBuilder(64).append("[CDATA: ").append(this.getText()).append("]").toString();
    }

    public CDATA clone() {
        return (CDATA)super.clone();
    }

    public CDATA detach() {
        return (CDATA)super.detach();
    }

    protected CDATA setParent(Parent parent) {
        return (CDATA)super.setParent(parent);
    }
}

