/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.EnumSet;
import java.util.Set;

public enum FunctionProperty {
    INVERTIBLE,
    INJECTIVE,
    SURJECTIVE,
    ORDER_PRESERVING,
    ORDER_REVERSING,
    VOLATILE;

    private static final EnumSet<FunctionProperty> BIJECTIVE;
    private static final EnumSet<FunctionProperty> CONSTANT;

    public static boolean isBijective(Set<FunctionProperty> properties) {
        return properties.containsAll(BIJECTIVE);
    }

    public static boolean isMonotonic(Set<FunctionProperty> properties) {
        return properties.contains((Object)ORDER_PRESERVING) || properties.contains((Object)ORDER_REVERSING);
    }

    public static boolean isConstant(Set<FunctionProperty> properties) {
        return properties.containsAll(CONSTANT);
    }

    public static EnumSet<FunctionProperty> concatenate(Set<FunctionProperty> step1, Set<FunctionProperty> step2) {
        EnumSet<FunctionProperty> properties = EnumSet.noneOf(FunctionProperty.class);
        properties.addAll(step1);
        properties.retainAll(step2);
        if (step1.contains((Object)VOLATILE) || step2.contains((Object)VOLATILE)) {
            properties.add(VOLATILE);
        }
        if (!properties.contains((Object)ORDER_PRESERVING)) {
            boolean r2;
            boolean r1 = step1.contains((Object)ORDER_REVERSING);
            if (r1 & (r2 = step2.contains((Object)ORDER_REVERSING))) {
                properties.add(ORDER_PRESERVING);
            } else if (r1 && step2.contains((Object)ORDER_PRESERVING) || r2 && step1.contains((Object)ORDER_PRESERVING)) {
                properties.add(ORDER_REVERSING);
            }
        }
        return properties;
    }

    static {
        BIJECTIVE = EnumSet.of(INJECTIVE, SURJECTIVE);
        CONSTANT = EnumSet.of(ORDER_PRESERVING, ORDER_REVERSING);
    }
}

