/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterProcessBinding;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterAddTripleTerm
extends QueryIterProcessBinding {
    private final Triple triple;
    private final Var var;

    public QueryIterAddTripleTerm(QueryIterator chain, Var var, Triple triple, ExecutionContext execContext) {
        super(chain, execContext);
        this.triple = triple;
        this.var = var;
    }

    @Override
    public Binding accept(Binding binding) {
        return QueryIterAddTripleTerm.convert(this.var, this.triple, binding);
    }

    private static Binding convert(Var var, Triple triple, Binding binding) {
        Triple matchedTriple = Substitute.substitute(triple, binding);
        if (!matchedTriple.isConcrete()) {
            return null;
        }
        Node nt = NodeFactory.createTripleTerm(matchedTriple);
        if (binding.contains(var)) {
            Node nt2 = binding.get(var);
            if (!nt.equals(nt2)) {
                return null;
            }
            return binding;
        }
        Binding b = BindingFactory.binding(binding, var, nt);
        return b;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(this.getClass().getSimpleName() + ": [" + String.valueOf(this.var) + "] " + String.valueOf(this.triple));
    }
}

