/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;

public interface OntID
extends OntObject {
    public String getVersionIRI();

    public OntID setVersionIRI(String var1) throws OntJenaException;

    public OntID addImport(String var1) throws OntJenaException;

    public OntID removeImport(String var1);

    public Stream<String> imports();

    default public boolean sameAs(OntID other) {
        return this.equals(other) && Objects.equals(this.getVersionIRI(), other.getVersionIRI());
    }

    default public String getImportsIRI() {
        String res = this.getVersionIRI();
        if (res != null) {
            return res;
        }
        return this.getURI();
    }

    @Override
    default public OntID addComment(String txt) {
        return this.addComment(txt, null);
    }

    @Override
    default public OntID addComment(String txt, String lang) {
        return this.annotate(this.getModel().getRDFSComment(), txt, lang);
    }

    default public OntID addVersionInfo(String txt) {
        return this.addVersionInfo(txt, null);
    }

    default public OntID addVersionInfo(String txt, String lang) {
        return this.annotate(this.getModel().getAnnotationProperty((Resource)OWL2.versionInfo), txt, lang);
    }

    default public String getVersionInfo() {
        return this.getVersionInfo(null);
    }

    default public String getVersionInfo(String lang) {
        try (Stream<String> res = this.annotationValues(this.getModel().getAnnotationProperty((Resource)OWL2.versionInfo), lang);){
            String string = res.findFirst().orElse(null);
            return string;
        }
    }

    @Override
    default public OntID annotate(OntAnnotationProperty predicate, String txt, String lang) {
        return this.annotate(predicate, (RDFNode)this.getModel().createLiteral(txt, lang));
    }

    @Override
    default public OntID annotate(OntAnnotationProperty predicate, RDFNode value) {
        this.addAnnotation(predicate, value);
        return this;
    }
}

