/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.ontapi.GraphMaker;
import org.apache.jena.ontapi.impl.repositories.DocumentGraphRepository;
import org.apache.jena.ontapi.impl.repositories.PersistentGraphRepository;

public interface GraphRepository {
    public static DocumentGraphRepository createGraphDocumentRepositoryMem() {
        return GraphRepository.createGraphDocumentRepository(GraphMemFactory::createDefaultGraph);
    }

    public static DocumentGraphRepository createGraphDocumentRepository(Supplier<Graph> factory) {
        return new DocumentGraphRepository(Objects.requireNonNull(factory, "Null graph factory"));
    }

    public static PersistentGraphRepository createPersistentGraphRepository(GraphMaker maker) {
        return new PersistentGraphRepository(Objects.requireNonNull(maker));
    }

    public Graph get(String var1);

    public Stream<String> ids();

    public Graph put(String var1, Graph var2);

    public Graph remove(String var1);

    public void clear();

    default public long count() {
        return this.ids().count();
    }

    default public Stream<Graph> graphs() {
        return this.ids().map(this::get).filter(Objects::nonNull);
    }

    default public boolean contains(String id) {
        Objects.requireNonNull(id);
        return this.ids().anyMatch(id::equals);
    }
}

