/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import cats.Applicative;
import cats.implicits$;
import com.google.common.io.CountingOutputStream;
import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.internal.WitnessAs$;
import eu.timepit.refined.numeric;
import eu.timepit.refined.package$;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.mail.Charset;
import org.apache.james.jmap.mail.Charset$;
import org.apache.james.jmap.mail.ClientCid$;
import org.apache.james.jmap.mail.Disposition;
import org.apache.james.jmap.mail.EmailBodyPart;
import org.apache.james.jmap.mail.EmailHeader;
import org.apache.james.jmap.mail.EmailHeader$;
import org.apache.james.jmap.mail.Languages;
import org.apache.james.jmap.mail.Languages$;
import org.apache.james.jmap.mail.Location;
import org.apache.james.jmap.mail.Location$;
import org.apache.james.jmap.mail.Name;
import org.apache.james.jmap.mail.Name$;
import org.apache.james.jmap.mail.PartId;
import org.apache.james.jmap.mail.Type;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple13;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import shapeless.Witness$;
import shapeless._0;
import shapeless.ops.nat;

public final class EmailBodyPart$
implements Serializable {
    public static final EmailBodyPart$ MODULE$ = new EmailBodyPart$();
    private static final String TEXT_PLAIN = "text/plain";
    private static final String TEXT_HTML = "text/html";
    private static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    private static final String FILENAME_PREFIX = "name";
    private static final Properties defaultProperties = Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"partId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"blobId")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"size")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"type")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"charset")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"disposition")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"cid")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"language")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"location")).value()))}));
    private static final Properties allowedProperties = MODULE$.defaultProperties().$plus$plus(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"subParts")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"headers")).value()))})));

    public String TEXT_PLAIN() {
        return TEXT_PLAIN;
    }

    public String TEXT_HTML() {
        return TEXT_HTML;
    }

    public String MULTIPART_ALTERNATIVE() {
        return MULTIPART_ALTERNATIVE;
    }

    public String FILENAME_PREFIX() {
        return FILENAME_PREFIX;
    }

    public Properties defaultProperties() {
        return defaultProperties;
    }

    public Properties allowedProperties() {
        return allowedProperties;
    }

    public Try<EmailBodyPart> of(MessageId messageId, MessageResult message) {
        DefaultMessageBuilder defaultMessageBuilder = new DefaultMessageBuilder();
        defaultMessageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        defaultMessageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        Try mime4JMessage = Try$.MODULE$.apply((Function0 & Serializable)() -> defaultMessageBuilder.parseMessage(message.getFullContent().getInputStream()));
        return mime4JMessage.flatMap((Function1 & Serializable)x$1 -> MODULE$.of(messageId, (Message)x$1));
    }

    public Try<EmailBodyPart> of(MessageId messageId, Message message) {
        return this.of(messageId, new PartId((Integer)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToInteger((int)1))).value()), (Entity)message).map((Function1 & Serializable)x$2 -> (EmailBodyPart)x$2._1());
    }

    private Try<Tuple2<EmailBodyPart, PartId>> of(MessageId messageId, PartId partId, Entity entity2) {
        Body body = entity2.getBody();
        if (body instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            Try scanResults = (Try)implicits$.MODULE$.toTraverseOps(CollectionConverters$.MODULE$.ListHasAsScala(multipart.getBodyParts()).asScala().toList().scanLeft((Object)new Success((Object)new Tuple2((Object)None$.MODULE$, (Object)partId)), (Function2 & Serializable)(acc, entity) -> MODULE$.traverse(messageId, (Try<Tuple2<Option<EmailBodyPart>, PartId>>)acc, (Entity)entity)), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry());
            Try highestPartIdValidation = scanResults.map((Function1 & Serializable)list -> (PartId)list.map((Function1 & Serializable)x$3 -> (PartId)x$3._2()).reverse().headOption().getOrElse((Function0 & Serializable)() -> partId));
            Try childrenValidation = scanResults.map((Function1 & Serializable)list -> list.flatMap((Function1 & Serializable)x$4 -> (Option)x$4._1()));
            return this.zip(childrenValidation, highestPartIdValidation).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    List children = (List)tuple2._1();
                    PartId highestPartId = (PartId)tuple2._2();
                    return MODULE$.of((Option<BlobId>)None$.MODULE$, partId, entity2, (Option<List<EmailBodyPart>>)new Some((Object)children)).map((Function1 & Serializable)part -> new Tuple2(part, (Object)highestPartId));
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return BlobId$.MODULE$.of(messageId, partId).flatMap((Function1 & Serializable)blobId -> MODULE$.of((Option<BlobId>)new Some(blobId), partId, entity2, (Option<List<EmailBodyPart>>)None$.MODULE$)).map((Function1 & Serializable)part -> new Tuple2(part, (Object)partId));
    }

    private Try<Tuple2<Option<EmailBodyPart>, PartId>> traverse(MessageId messageId, Try<Tuple2<Option<EmailBodyPart>, PartId>> acc, Entity entity) {
        return acc.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PartId previousPartId = (PartId)tuple2._2();
                PartId partId = previousPartId.next();
                return MODULE$.of(messageId, partId, entity).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        EmailBodyPart part = (EmailBodyPart)tuple2._1();
                        PartId partId = (PartId)tuple2._2();
                        return new Tuple2((Object)new Some((Object)part), (Object)partId);
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Try<EmailBodyPart> of(Option<BlobId> blobId, PartId partId, Entity entity, Option<List<EmailBodyPart>> subParts) {
        return this.size(entity).map((Function1 & Serializable)size -> EmailBodyPart$.$anonfun$of$14(partId, blobId, entity, subParts, (Long)((Refined)size).value()));
    }

    private Option<String> headerValue(Entity entity, String headerName) {
        return CollectionConverters$.MODULE$.ListHasAsScala(entity.getHeader().getFields(headerName)).asScala().headOption().map((Function1 & Serializable)x$7 -> x$7.getBody());
    }

    private Try<Refined<Object, boolean.Not<numeric.Less<_0>>>> size(Entity entity) {
        CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
        DefaultMessageWriter writer = new DefaultMessageWriter();
        writer.writeBody(entity.getBody(), (OutputStream)countingOutputStream);
        Either either = package$.MODULE$.refineV().apply((Object)BoxesRunTime.boxToLong((long)countingOutputStream.getCount()), boolean.Not$.MODULE$.notValidate(numeric.Less$.MODULE$.lessValidate(WitnessAs$.MODULE$.natWitnessAs(Witness$.MODULE$.witness0(), nat.ToInt$.MODULE$.toInt0(), (Numeric)Numeric.LongIsIntegral$.MODULE$), (Numeric)Numeric.LongIsIntegral$.MODULE$)));
        if (either instanceof Right) {
            Right right = (Right)either;
            Long size = (Long)((Refined)right.value()).value();
            return new Success((Object)new Refined((Object)size));
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String e = (String)left.value();
            return new Failure((Throwable)new IllegalArgumentException(e));
        }
        throw new MatchError((Object)either);
    }

    private <A, B> Try<Tuple2<A, B>> zip(Try<A> a, Try<B> b) {
        return a.flatMap((Function1 & Serializable)aValue -> b.map((Function1 & Serializable)bValue -> new Tuple2(aValue, bValue)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public EmailBodyPart apply(PartId partId, Option blobId, List headers, Long size, Option name, String type, Option charset, Option disposition, Option cid, Option language, Option location, Option subParts, Entity entity) {
        return new EmailBodyPart(partId, blobId, headers, size, name, type, charset, disposition, cid, language, location, subParts, entity);
    }

    public Option<Tuple13<PartId, Option<BlobId>, List<EmailHeader>, Refined<Object, boolean.Not<numeric.Less<_0>>>, Option<Name>, Type, Option<Charset>, Option<Disposition>, Option<Cid>, Option<Languages>, Option<Location>, Option<List<EmailBodyPart>>, Entity>> unapply(EmailBodyPart x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple13((Object)x$0.partId(), x$0.blobId(), x$0.headers(), (Object)new Refined((Object)x$0.size()), x$0.name(), (Object)new Type(x$0.type()), x$0.charset(), x$0.disposition(), x$0.cid(), x$0.language(), x$0.location(), x$0.subParts(), (Object)x$0.entity()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(EmailBodyPart$.class);
    }

    public static final /* synthetic */ EmailBodyPart $anonfun$of$14(PartId partId$2, Option blobId$1, Entity entity$3, Option subParts$1, Long size) {
        return new EmailBodyPart(partId$2, blobId$1, CollectionConverters$.MODULE$.ListHasAsScala(entity$3.getHeader().getFields()).asScala().toList().map((Function1 & Serializable)x$5 -> EmailHeader$.MODULE$.apply((Field)x$5)), size, Name$.MODULE$.of(entity$3), entity$3.getMimeType(), Option$.MODULE$.apply((Object)entity$3.getCharset()).map((Function1)Charset$.MODULE$), Option$.MODULE$.apply((Object)entity$3.getDispositionType()).map((Function1 & Serializable)x$6 -> new Disposition(x$6)), ClientCid$.MODULE$.of(entity$3), Languages$.MODULE$.of(entity$3), MODULE$.headerValue(entity$3, "Content-Location").map((Function1)Location$.MODULE$), subParts$1, entity$3);
    }

    private EmailBodyPart$() {
    }
}

