/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import java.util.LinkedList;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.DNSAsynchLookupService;
import org.apache.james.jspf.executor.IResponseImpl;
import org.apache.james.jspf.executor.IResponseQueue;

public class DNSServiceAsynchSimulator
implements Runnable,
DNSAsynchLookupService {
    private DNSService dnsService;
    private Thread worker;
    private LinkedList<Request> queue;
    private int waitingThreads = 0;
    private boolean multiThread;

    public DNSServiceAsynchSimulator(DNSService service, boolean multiThread) {
        this.dnsService = service;
        this.multiThread = multiThread;
        this.queue = new LinkedList();
        this.worker = new Thread(this);
        this.worker.setDaemon(true);
        this.worker.setName("DNSServiceAsynchSimulator");
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecordsAsynch(DNSRequest request, int id, IResponseQueue responsePool) {
        LinkedList<Request> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(new Request(request, new Integer(id), responsePool));
            this.queue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Request req;
            LinkedList<Request> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.size() - this.waitingThreads <= 0) {
                    try {
                        ++this.waitingThreads;
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    --this.waitingThreads;
                }
                req = this.queue.removeFirst();
            }
            Runnable runnable = new Runnable(){
                private Request req;

                public void run() {
                    IResponseImpl response;
                    try {
                        response = new IResponseImpl(this.req.getId(), DNSServiceAsynchSimulator.this.dnsService.getRecords(this.req.getValue()));
                    }
                    catch (TimeoutException e) {
                        response = new IResponseImpl(this.req.getId(), e);
                    }
                    this.req.getResponseQueue().insertResponse(response);
                }

                public Runnable setRequest(Request req) {
                    this.req = req;
                    return this;
                }
            }.setRequest(req);
            if (this.multiThread) {
                new Thread(runnable).start();
                continue;
            }
            runnable.run();
        }
    }

    private static final class Request {
        private final DNSRequest value;
        private final Object id;
        private final IResponseQueue responseQueue;

        public Request(DNSRequest value, Object id, IResponseQueue responseQueue) {
            this.value = value;
            this.id = id;
            this.responseQueue = responseQueue;
        }

        public DNSRequest getValue() {
            return this.value;
        }

        public Object getId() {
            return this.id;
        }

        public IResponseQueue getResponseQueue() {
            return this.responseQueue;
        }
    }
}

