/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.Locale;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.StoreRequest;
import org.apache.james.mailbox.MessageManager;

public class StoreCommandParser
extends AbstractUidCommandParser {
    private static final String UNCHANGEDSINCE = "UNCHANGEDSINCE";

    public StoreCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.STORE_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        IdRange[] idSet = request.parseIdRange(session);
        long unchangedSince = -1L;
        char next = request.nextWordChar();
        if (next == '(') {
            request.consume();
            request.consumeWord(ImapRequestLineReader.StringMatcherCharacterValidator.ignoreCase(UNCHANGEDSINCE));
            request.consumeChar(' ');
            unchangedSince = request.number(true);
            request.consumeChar(')');
            next = request.nextWordChar();
        }
        MessageManager.FlagsUpdateMode flagsUpdateMode = this.parseFlagsUpdateMode(request, next);
        String directive = request.consumeWord(new ImapRequestLineReader.NoopCharValidator());
        boolean silent = this.parseSilent(directive);
        Flags flags = this.parseFlags(request);
        request.eol();
        return new StoreRequest(idSet, silent, flags, useUids, tag, flagsUpdateMode, unchangedSince);
    }

    private Flags parseFlags(ImapRequestLineReader request) throws DecodingException {
        Flags flags = new Flags();
        if (request.nextWordChar() == '(') {
            flags.add(request.flagList());
        } else {
            boolean moreFlags = true;
            while (moreFlags) {
                flags.add(request.flag());
                try {
                    request.consumeChar(' ');
                }
                catch (DecodingException e) {
                    moreFlags = false;
                }
            }
        }
        return flags;
    }

    private boolean parseSilent(String directive) throws DecodingException {
        switch (directive.toUpperCase(Locale.US)) {
            case "FLAGS": {
                return false;
            }
            case "FLAGS.SILENT": {
                return true;
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Invalid Store Directive: '" + directive + "'");
    }

    private MessageManager.FlagsUpdateMode parseFlagsUpdateMode(ImapRequestLineReader request, char next) throws DecodingException {
        switch (next) {
            case '+': {
                request.consume();
                return MessageManager.FlagsUpdateMode.ADD;
            }
            case '-': {
                request.consume();
                return MessageManager.FlagsUpdateMode.REMOVE;
            }
        }
        return MessageManager.FlagsUpdateMode.REPLACE;
    }
}

