/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;

public class PatternConcatenation
extends RowPattern {
    private final List<RowPattern> patterns;

    public PatternConcatenation(NodeLocation location, List<RowPattern> patterns) {
        super(location);
        this.patterns = Objects.requireNonNull(patterns, "patterns is null");
        Preconditions.checkArgument((!patterns.isEmpty() ? 1 : 0) != 0, (Object)"patterns list is empty");
    }

    public List<RowPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternConcatenation(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.copyOf(this.patterns);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatternConcatenation o = (PatternConcatenation)obj;
        return Objects.equals(this.patterns, o.patterns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("patterns", this.patterns).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return PatternConcatenation.sameClass(this, other);
    }
}

