/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public class IsNotNullPredicate
extends Expression {
    private final Expression value;

    public IsNotNullPredicate(Expression value) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public IsNotNullPredicate(NodeLocation location, Expression value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public IsNotNullPredicate(ByteBuffer byteBuffer) {
        super(null);
        this.value = Expression.deserialize(byteBuffer);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.IS_NOT_NULL_PREDICATE;
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.value, stream);
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsNotNullPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNotNullPredicate that = (IsNotNullPredicate)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return IsNotNullPredicate.sameClass(this, other);
    }
}

