/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternAggregators;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.PatternVariableRecognizer;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Instruction;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.IntList;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.IntMultimap;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.IntStack;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Jump;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.MatchLabel;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.MatchResult;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.PatternCaptures;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Program;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Split;
import org.apache.tsfile.utils.RamUsageEstimator;

public class Matcher {
    private final Program program;
    private final List<PatternAggregator> patternAggregators;

    public Matcher(Program program, List<PatternAggregator> patternAggregators) {
        this.program = program;
        this.patternAggregators = patternAggregators;
    }

    public MatchResult run(PatternVariableRecognizer patternVariableRecognizer) {
        IntList current = new IntList(this.program.size());
        IntList next = new IntList(this.program.size());
        int inputLength = patternVariableRecognizer.getInputLength();
        boolean matchingAtPartitionStart = patternVariableRecognizer.isMatchingAtPartitionStart();
        Runtime runtime = new Runtime(this.program, inputLength, matchingAtPartitionStart, this.patternAggregators);
        this.advanceAndSchedule(current, runtime.newThread(), 0, 0, runtime);
        MatchResult result = MatchResult.NO_MATCH;
        for (int index = 0; index < inputLength && current.size() != 0; ++index) {
            boolean matched = false;
            runtime.threadsAtInstructions.clear();
            runtime.killThreads();
            for (int i = 0; i < current.size(); ++i) {
                int threadId = current.get(i);
                int pointer = runtime.threads.get(threadId);
                Instruction instruction = this.program.at(pointer);
                switch (instruction.type()) {
                    case MATCH_LABEL: {
                        int label = ((MatchLabel)instruction).getLabel();
                        runtime.patternCaptures.saveLabel(threadId, label);
                        if (patternVariableRecognizer.evaluateLabel(runtime.patternCaptures.getLabels(threadId), runtime.aggregators.get(threadId))) {
                            this.advanceAndSchedule(next, threadId, pointer + 1, index + 1, runtime);
                            break;
                        }
                        runtime.scheduleKill(threadId);
                        break;
                    }
                    case DONE: {
                        matched = true;
                        result = new MatchResult(true, runtime.patternCaptures.getLabels(threadId), runtime.patternCaptures.getCaptures(threadId));
                        runtime.scheduleKill(threadId);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("not yet implemented");
                    }
                }
                if (!matched) continue;
                for (int j = i + 1; j < current.size(); ++j) {
                    runtime.scheduleKill(current.get(j));
                }
                break;
            }
            IntList temp = current;
            temp.clear();
            current = next;
            next = temp;
        }
        for (int i = 0; i < current.size(); ++i) {
            int threadId = current.get(i);
            if (this.program.at(runtime.threads.get(threadId)).type() != Instruction.Type.DONE) continue;
            result = new MatchResult(true, runtime.patternCaptures.getLabels(threadId), runtime.patternCaptures.getCaptures(threadId));
            break;
        }
        return result;
    }

    private void advanceAndSchedule(IntList next, int threadId, int pointer, int inputIndex, Runtime runtime) {
        Instruction instruction = this.program.at(pointer);
        switch (instruction.type()) {
            case MATCH_START: {
                if (inputIndex == 0 && runtime.matchingAtPartitionStart) {
                    this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                    break;
                }
                runtime.scheduleKill(threadId);
                break;
            }
            case MATCH_END: {
                if (inputIndex == runtime.inputLength) {
                    this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                    break;
                }
                runtime.scheduleKill(threadId);
                break;
            }
            case JUMP: {
                this.advanceAndSchedule(next, threadId, ((Jump)instruction).getTarget(), inputIndex, runtime);
                break;
            }
            case SPLIT: {
                int forked = runtime.forkThread(threadId);
                this.advanceAndSchedule(next, threadId, ((Split)instruction).getFirst(), inputIndex, runtime);
                this.advanceAndSchedule(next, forked, ((Split)instruction).getSecond(), inputIndex, runtime);
                break;
            }
            case SAVE: {
                runtime.patternCaptures.save(threadId, inputIndex);
                this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                break;
            }
            default: {
                runtime.threads.set(threadId, pointer);
                next.add(threadId);
            }
        }
    }

    private static class Runtime {
        private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(Runtime.class);
        private final IntMultimap threadsAtInstructions;
        private final IntList threadsToKill;
        private final IntList threads;
        private final IntStack freeThreadIds;
        private int newThreadId;
        private final int inputLength;
        private final boolean matchingAtPartitionStart;
        private final PatternCaptures patternCaptures;
        private final PatternAggregators aggregators;

        public Runtime(Program program, int inputLength, boolean matchingAtPartitionStart, List<PatternAggregator> patternAggregators) {
            int initialCapacity = 2 * program.size();
            this.threads = new IntList(initialCapacity);
            this.freeThreadIds = new IntStack(initialCapacity);
            this.patternCaptures = new PatternCaptures(initialCapacity, program.getMinSlotCount(), program.getMinLabelCount());
            this.inputLength = inputLength;
            this.matchingAtPartitionStart = matchingAtPartitionStart;
            this.aggregators = new PatternAggregators(initialCapacity, patternAggregators);
            this.threadsAtInstructions = new IntMultimap(program.size(), program.size());
            this.threadsToKill = new IntList(initialCapacity);
        }

        private int forkThread(int parent) {
            int child = this.newThread();
            this.patternCaptures.copy(parent, child);
            this.aggregators.copy(parent, child);
            return child;
        }

        private int newThread() {
            if (this.freeThreadIds.size() > 0) {
                return this.freeThreadIds.pop();
            }
            return this.newThreadId++;
        }

        private void scheduleKill(int threadId) {
            this.threadsToKill.add(threadId);
        }

        private void killThreads() {
            for (int i = 0; i < this.threadsToKill.size(); ++i) {
                this.killThread(this.threadsToKill.get(i));
            }
            this.threadsToKill.clear();
        }

        private void killThread(int threadId) {
            this.freeThreadIds.push(threadId);
            this.patternCaptures.release(threadId);
            this.aggregators.release(threadId);
        }

        private long getSizeInBytes() {
            return INSTANCE_SIZE + this.threadsAtInstructions.getSizeInBytes() + this.threadsToKill.getSizeInBytes() + this.threads.getSizeInBytes() + this.freeThreadIds.getSizeInBytes() + this.patternCaptures.getSizeInBytes();
        }
    }
}

