/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.builtin.BuiltinTimeSeriesGeneratingFunction;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.other.GroupByTimeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.BetweenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.InExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.TimeDuration;

public class ExpressionFactory {
    private ExpressionFactory() {
    }

    public static PartialPath path(String pathStr) throws IllegalPathException {
        return new PartialPath(pathStr);
    }

    public static TimeSeriesOperand timeSeries(String pathStr) throws IllegalPathException {
        MeasurementPath path = new MeasurementPath(pathStr);
        return new TimeSeriesOperand((PartialPath)path);
    }

    public static TimeSeriesOperand timeSeries(PartialPath path) {
        return new TimeSeriesOperand(path);
    }

    public static ConstantOperand constant(TSDataType dataType, String valueString) {
        return new ConstantOperand(dataType, valueString);
    }

    public static ConstantOperand intValue(String valueString) {
        return new ConstantOperand(TSDataType.INT32, valueString);
    }

    public static ConstantOperand longValue(long value) {
        return new ConstantOperand(TSDataType.INT64, String.valueOf(value));
    }

    public static TimestampOperand time() {
        return new TimestampOperand();
    }

    public static FunctionExpression function(String functionName, LinkedHashMap<String, String> functionAttributes, Expression ... inputExpression) {
        return new FunctionExpression(functionName, functionAttributes, Arrays.asList(inputExpression));
    }

    public static FunctionExpression function(String functionName, Expression ... inputExpression) {
        return new FunctionExpression(functionName, new LinkedHashMap<String, String>(), Arrays.asList(inputExpression));
    }

    public static FunctionExpression count(Expression inputExpression) {
        return new FunctionExpression(TAggregationType.COUNT.toString(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static FunctionExpression countTime(Expression inputExpression) {
        return new FunctionExpression(TAggregationType.COUNT_TIME.toString(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static FunctionExpression sum(Expression inputExpression) {
        return new FunctionExpression(TAggregationType.SUM.toString(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static FunctionExpression sin(Expression inputExpression) {
        return new FunctionExpression(BuiltinTimeSeriesGeneratingFunction.SIN.toString().toLowerCase(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static LogicAndExpression and(Expression leftExpression, Expression rightExpression) {
        return new LogicAndExpression(leftExpression, rightExpression);
    }

    public static LogicOrExpression or(Expression leftExpression, Expression rightExpression) {
        return new LogicOrExpression(leftExpression, rightExpression);
    }

    public static AdditionExpression add(Expression leftExpression, Expression rightExpression) {
        return new AdditionExpression(leftExpression, rightExpression);
    }

    public static GreaterThanExpression gt(Expression leftExpression, Expression rightExpression) {
        return new GreaterThanExpression(leftExpression, rightExpression);
    }

    public static GreaterEqualExpression gte(Expression leftExpression, Expression rightExpression) {
        return new GreaterEqualExpression(leftExpression, rightExpression);
    }

    public static LessThanExpression lt(Expression leftExpression, Expression rightExpression) {
        return new LessThanExpression(leftExpression, rightExpression);
    }

    public static LessEqualExpression lte(Expression leftExpression, Expression rightExpression) {
        return new LessEqualExpression(leftExpression, rightExpression);
    }

    public static EqualToExpression eq(Expression leftExpression, Expression rightExpression) {
        return new EqualToExpression(leftExpression, rightExpression);
    }

    public static NonEqualExpression neq(Expression leftExpression, Expression rightExpression) {
        return new NonEqualExpression(leftExpression, rightExpression);
    }

    public static WhenThenExpression whenThen(Expression whenExpression, Expression thenExpression) {
        return new WhenThenExpression(whenExpression, thenExpression);
    }

    public static LogicNotExpression not(Expression expression) {
        return new LogicNotExpression(expression);
    }

    public static InExpression in(Expression expression, LinkedHashSet<String> values) {
        return new InExpression(expression, false, values);
    }

    public static InExpression notIn(Expression expression, LinkedHashSet<String> values) {
        return new InExpression(expression, true, values);
    }

    public static IsNullExpression isNull(Expression expression) {
        return new IsNullExpression(expression, false);
    }

    public static IsNullExpression isNotNull(Expression expression) {
        return new IsNullExpression(expression, true);
    }

    public static LikeExpression like(Expression expression, String patternString) {
        return new LikeExpression(expression, patternString, false);
    }

    public static LikeExpression notLike(Expression expression, String patternString) {
        return new LikeExpression(expression, patternString, true);
    }

    public static RegularExpression regex(Expression expression, String patternString) {
        return new RegularExpression(expression, patternString, false);
    }

    public static RegularExpression notRegex(Expression expression, String patternString) {
        return new RegularExpression(expression, patternString, true);
    }

    public static BetweenExpression between(Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        return new BetweenExpression(firstExpression, secondExpression, thirdExpression, false);
    }

    public static BetweenExpression notBetween(Expression firstExpression, Expression secondExpression, Expression thirdExpression) {
        return new BetweenExpression(firstExpression, secondExpression, thirdExpression, true);
    }

    public static GroupByTimeExpression groupByTime(GroupByTimeParameter parameter) {
        long startTime = parameter.isLeftCRightO() ? parameter.getStartTime() : parameter.getStartTime() + 1L;
        long endTime = parameter.isLeftCRightO() ? parameter.getEndTime() : parameter.getEndTime() + 1L;
        return new GroupByTimeExpression(startTime, endTime, parameter.getInterval(), parameter.getSlidingStep());
    }

    public static GroupByTimeExpression groupByTime(long startTime, long endTime, long interval, long slidingStep) {
        return new GroupByTimeExpression(startTime, endTime, new TimeDuration(0, interval), new TimeDuration(0, slidingStep));
    }
}

