/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.receiver;

import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeDataNodeReceiverMetrics
implements IMetricSet {
    private static final PipeDataNodeReceiverMetrics INSTANCE = new PipeDataNodeReceiverMetrics();
    private Timer handshakeDatanodeV1Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer handshakeDatanodeV2Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTabletInsertNodeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTabletRawTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTabletBinaryTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTabletBatchTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTsFilePieceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTsFileSealTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTsFilePieceWithModTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferTsFileSealWithModTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferSchemaPlanTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferSchemaSnapshotPieceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferSchemaSnapshotSealTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferConfigPlanTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferCompressedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer transferSliceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private static final String RECEIVER = "pipeDataNodeReceiver";

    private PipeDataNodeReceiverMetrics() {
    }

    public void recordHandshakeDatanodeV1Timer(long costTimeInNanos) {
        this.handshakeDatanodeV1Timer.updateNanos(costTimeInNanos);
    }

    public void recordHandshakeDatanodeV2Timer(long costTimeInNanos) {
        this.handshakeDatanodeV2Timer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTabletInsertNodeTimer(long costTimeInNanos) {
        this.transferTabletInsertNodeTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTabletRawTimer(long costTimeInNanos) {
        this.transferTabletRawTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTabletBinaryTimer(long costTimeInNanos) {
        this.transferTabletBinaryTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTabletBatchTimer(long costTimeInNanos) {
        this.transferTabletBatchTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTsFilePieceTimer(long costTimeInNanos) {
        this.transferTsFilePieceTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTsFileSealTimer(long costTimeInNanos) {
        this.transferTsFileSealTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTsFilePieceWithModTimer(long costTimeInNanos) {
        this.transferTsFilePieceWithModTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferTsFileSealWithModTimer(long costTimeInNanos) {
        this.transferTsFileSealWithModTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferSchemaPlanTimer(long costTimeInNanos) {
        this.transferSchemaPlanTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferSchemaSnapshotPieceTimer(long costTimeInNanos) {
        this.transferSchemaSnapshotPieceTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferSchemaSnapshotSealTimer(long costTimeInNanos) {
        this.transferSchemaSnapshotSealTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferConfigPlanTimer(long costTimeInNanos) {
        this.transferConfigPlanTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferCompressedTimer(long costTimeInNanos) {
        this.transferCompressedTimer.updateNanos(costTimeInNanos);
    }

    public void recordTransferSliceTimer(long costTimeInNanos) {
        this.transferSliceTimer.updateNanos(costTimeInNanos);
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindToTimer(metricService);
    }

    private void bindToTimer(AbstractMetricService metricService) {
        this.handshakeDatanodeV1Timer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeDataNodeV1"});
        this.handshakeDatanodeV2Timer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeDataNodeV2"});
        this.transferTabletInsertNodeTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletInsertNode"});
        this.transferTabletRawTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletRaw"});
        this.transferTabletBinaryTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletBinary"});
        this.transferTabletBatchTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletBatch"});
        this.transferTsFilePieceTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFilePiece"});
        this.transferTsFileSealTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFileSeal"});
        this.transferTsFilePieceWithModTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFilePieceWithMod"});
        this.transferTsFileSealWithModTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFileSealWithMod"});
        this.transferSchemaPlanTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSchemaPlan"});
        this.transferSchemaSnapshotPieceTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSchemaSnapshotPiece"});
        this.transferSchemaSnapshotSealTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSchemaSnapshotSeal"});
        this.transferConfigPlanTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigPlan"});
        this.transferCompressedTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferCompressed"});
        this.transferSliceTimer = metricService.getOrCreateTimer(Metric.PIPE_DATANODE_RECEIVER.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSlice"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbind(metricService);
    }

    private void unbind(AbstractMetricService metricService) {
        this.handshakeDatanodeV1Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.handshakeDatanodeV2Timer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTabletInsertNodeTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTabletRawTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTabletBinaryTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTabletBatchTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTsFilePieceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTsFileSealTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTsFilePieceWithModTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferTsFileSealWithModTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferSchemaPlanTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferSchemaSnapshotPieceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferSchemaSnapshotSealTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferConfigPlanTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferCompressedTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.transferSliceTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeDatanodeV1"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "handshakeDatanodeV2"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletInsertNode"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletRaw"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletBinary"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTabletBatch"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFilePiece"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFileSeal"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFilePieceWithMod"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferTsFileSealWithMod"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSchemaPlan"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSchemaSnapshotPiece"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSchemaSnapshotSeal"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferConfigPlan"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferCompressed"});
        metricService.remove(MetricType.TIMER, Metric.PIPE_DATANODE_RECEIVER.toString(), new String[]{Tag.NAME.toString(), RECEIVER, Tag.TYPE.toString(), "transferSlice"});
    }

    public static PipeDataNodeReceiverMetrics getInstance() {
        return INSTANCE;
    }
}

