/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.statistics;

import java.util.Collections;
import java.util.Map;

public class SpecifiedInfoMergerFactory {
    private static final SpecifiedInfoMerger DEFAULT_MERGER = (first, second) -> Collections.emptyMap();
    private static final SpecifiedInfoMerger LONG_MERGER = (first, second) -> {
        first.replaceAll((k, v) -> Long.toString(Long.parseLong(v) + Long.parseLong((String)second.get(k))));
        return first;
    };

    public static SpecifiedInfoMerger getMerger(String operatorType) {
        switch (operatorType) {
            case "SortOperator": 
            case "MergeSortOperator": 
            case "FilterAndProjectOperator": {
                return LONG_MERGER;
            }
        }
        return DEFAULT_MERGER;
    }

    @FunctionalInterface
    public static interface SpecifiedInfoMerger {
        public Map<String, String> merge(Map<String, String> var1, Map<String, String> var2);
    }
}

