/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.sync;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.connector.client.IoTDBSyncClient;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventPlainBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventTsFileBatch;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBatchReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBDataNodeSyncConnector;
import org.apache.iotdb.db.pipe.connector.util.LeaderCacheUtils;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionSyncConnector
extends IoTDBDataNodeSyncConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionSyncConnector.class);
    private PipeTransferBatchReqBuilder tabletBatchBuilder;

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new PipeTransferBatchReqBuilder(parameters);
        }
    }

    protected PipeTransferFilePieceReq getTransferSingleFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferTsFilePieceReq.toTPipeTransferReq(fileName, position, payLoad);
    }

    protected PipeTransferFilePieceReq getTransferMultiFilePieceReq(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferTsFilePieceWithModReq.toTPipeTransferReq(fileName, position, payLoad);
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftSyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        try {
            if (this.isTabletBatchModeEnabled) {
                Pair<TEndPoint, PipeTabletEventBatch> endPointAndBatch = this.tabletBatchBuilder.onEvent(tabletInsertionEvent);
                if (Objects.nonNull(endPointAndBatch)) {
                    this.doTransferWrapper(endPointAndBatch);
                }
            } else if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.doTransferWrapper((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
            } else {
                this.doTransferWrapper((PipeRawTabletInsertionEvent)tabletInsertionEvent);
            }
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Failed to transfer tablet insertion event %s, because %s.", ((EnrichedEvent)tabletInsertionEvent).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftSyncConnector only support PipeTsFileInsertionEvent. Ignore {}.", (Object)tsFileInsertionEvent);
            return;
        }
        try {
            if (this.isTabletBatchModeEnabled && !this.tabletBatchBuilder.isEmpty()) {
                this.doTransferWrapper();
            }
            this.doTransferWrapper((PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (Exception e) {
            throw new PipeConnectionException(String.format("Failed to transfer tsfile insertion event %s, because %s.", ((PipeTsFileInsertionEvent)tsFileInsertionEvent).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(Event event) throws Exception {
        if (event instanceof PipeSchemaRegionWritePlanEvent) {
            this.doTransferWrapper((PipeSchemaRegionWritePlanEvent)event);
            return;
        }
        if (this.isTabletBatchModeEnabled && !this.tabletBatchBuilder.isEmpty()) {
            this.doTransferWrapper();
        }
        if (!(event instanceof PipeHeartbeatEvent) && !(event instanceof PipeTerminateEvent)) {
            LOGGER.warn("IoTDBThriftSyncConnector does not support transferring generic event: {}.", (Object)event);
        }
    }

    private void doTransferWrapper() throws IOException, WriteProcessException {
        for (Pair<TEndPoint, PipeTabletEventBatch> nonEmptyBatch : this.tabletBatchBuilder.getAllNonEmptyBatches()) {
            this.doTransferWrapper(nonEmptyBatch);
        }
    }

    private void doTransferWrapper(Pair<TEndPoint, PipeTabletEventBatch> endPointAndBatch) throws IOException, WriteProcessException {
        PipeTabletEventBatch batch = (PipeTabletEventBatch)endPointAndBatch.getRight();
        if (batch instanceof PipeTabletEventPlainBatch) {
            this.doTransfer((TEndPoint)endPointAndBatch.getLeft(), (PipeTabletEventPlainBatch)batch);
        } else if (batch instanceof PipeTabletEventTsFileBatch) {
            this.doTransfer((PipeTabletEventTsFileBatch)batch);
        } else {
            LOGGER.warn("Unsupported batch type {}.", batch.getClass());
        }
        batch.decreaseEventsReferenceCount(IoTDBDataRegionSyncConnector.class.getName(), true);
        batch.onSuccess();
    }

    private void doTransfer(TEndPoint endPoint, PipeTabletEventPlainBatch batchToTransfer) {
        TPipeTransferResp resp;
        Pair<IoTDBSyncClient, Boolean> clientAndStatus = this.clientManager.getClient(endPoint);
        try {
            PipeTransferTabletBatchReq uncompressedReq = batchToTransfer.toTPipeTransferReq();
            long uncompressedSize = uncompressedReq.getBody().length;
            TPipeTransferReq req = this.compressIfNeeded(uncompressedReq);
            long compressedSize = req.getBody().length;
            double compressionRatio = (double)compressedSize / (double)uncompressedSize;
            for (Map.Entry<Pair<String, Long>, Long> entry : batchToTransfer.getPipe2BytesAccumulated().entrySet()) {
                this.rateLimitIfNeeded((String)entry.getKey().getLeft(), (Long)entry.getKey().getRight(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), (long)((double)entry.getValue().longValue() * compressionRatio));
            }
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer tablet batch, because %s.", e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(resp.getStatus(), String.format("Transfer PipeTransferTabletBatchReq error, result status %s", resp.status), batchToTransfer.deepCopyEvents().toString());
        }
        for (Pair<String, TEndPoint> redirectPair : LeaderCacheUtils.parseRecommendedRedirections(status)) {
            this.clientManager.updateLeaderCache((String)redirectPair.getLeft(), (TEndPoint)redirectPair.getRight());
        }
    }

    private void doTransfer(PipeTabletEventTsFileBatch batchToTransfer) throws IOException, WriteProcessException {
        List<File> sealedFiles = batchToTransfer.sealTsFiles();
        Map<Pair<String, Long>, Double> pipe2WeightMap = batchToTransfer.deepCopyPipe2WeightMap();
        for (File tsFile : sealedFiles) {
            this.doTransfer(pipe2WeightMap, tsFile, null);
            try {
                RetryUtils.retryOnException(() -> {
                    FileUtils.delete((File)tsFile);
                    return null;
                });
            }
            catch (NoSuchFileException e) {
                LOGGER.info("The file {} is not found, may already be deleted.", (Object)tsFile);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to delete batch file {}, this file should be deleted manually later", (Object)tsFile);
            }
        }
    }

    private void doTransferWrapper(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException {
        if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeInsertNodeTabletInsertionEvent);
        }
        finally {
            pipeInsertNodeTabletInsertionEvent.decreaseReferenceCount(IoTDBDataRegionSyncConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair<IoTDBSyncClient, Boolean> clientAndStatus = null;
        try {
            clientAndStatus = this.clientManager.getClient(pipeInsertNodeTabletInsertionEvent.getDeviceId());
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            TPipeTransferReq req = this.compressIfNeeded(insertNode != null ? PipeTransferTabletInsertNodeReq.toTPipeTransferReq(insertNode) : PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()));
            this.rateLimitIfNeeded(pipeInsertNodeTabletInsertionEvent.getPipeName(), pipeInsertNodeTabletInsertionEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            if (clientAndStatus != null) {
                clientAndStatus.setRight((Object)false);
            }
            throw new PipeConnectionException(String.format("Network error when transfer insert node tablet insertion event, because %s.", e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer PipeInsertNodeTabletInsertionEvent %s error, result status %s", pipeInsertNodeTabletInsertionEvent.coreReportMessage(), status), pipeInsertNodeTabletInsertionEvent.toString());
        }
        if (status.isSetRedirectNode()) {
            this.clientManager.updateLeaderCache(pipeInsertNodeTabletInsertionEvent.getDeviceId(), status.getRedirectNode());
        }
    }

    private void doTransferWrapper(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException {
        if (!pipeRawTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(pipeRawTabletInsertionEvent);
        }
        finally {
            pipeRawTabletInsertionEvent.decreaseReferenceCount(IoTDBDataRegionSyncConnector.class.getName(), false);
        }
    }

    private void doTransfer(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException {
        TPipeTransferResp resp;
        Pair<IoTDBSyncClient, Boolean> clientAndStatus = this.clientManager.getClient(pipeRawTabletInsertionEvent.getDeviceId());
        try {
            TPipeTransferReq req = this.compressIfNeeded(PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned()));
            this.rateLimitIfNeeded(pipeRawTabletInsertionEvent.getPipeName(), pipeRawTabletInsertionEvent.getCreationTime(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), req.getBody().length);
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            throw new PipeConnectionException(String.format("Network error when transfer raw tablet insertion event, because %s.", e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(status, String.format("Transfer PipeRawTabletInsertionEvent %s error, result status %s", pipeRawTabletInsertionEvent.coreReportMessage(), status), pipeRawTabletInsertionEvent.toString());
        }
        if (status.isSetRedirectNode()) {
            this.clientManager.updateLeaderCache(pipeRawTabletInsertionEvent.getDeviceId(), status.getRedirectNode());
        }
    }

    private void doTransferWrapper(PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, IOException {
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(IoTDBDataRegionSyncConnector.class.getName())) {
            return;
        }
        try {
            this.doTransfer(Collections.singletonMap(new Pair((Object)pipeTsFileInsertionEvent.getPipeName(), (Object)pipeTsFileInsertionEvent.getCreationTime()), 1.0), pipeTsFileInsertionEvent.getTsFile(), pipeTsFileInsertionEvent.isWithMod() ? pipeTsFileInsertionEvent.getModFile() : null);
        }
        finally {
            pipeTsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionSyncConnector.class.getName(), false);
        }
    }

    private void doTransfer(Map<Pair<String, Long>, Double> pipeName2WeightMap, File tsFile, File modFile) throws PipeException, IOException {
        TPipeTransferResp resp;
        TPipeTransferReq req;
        Pair clientAndStatus = this.clientManager.getClient();
        if (Objects.nonNull(modFile) && this.clientManager.supportModsIfIsDataNodeReceiver()) {
            this.transferFilePieces(pipeName2WeightMap, modFile, clientAndStatus, true);
            this.transferFilePieces(pipeName2WeightMap, tsFile, clientAndStatus, true);
            try {
                req = this.compressIfNeeded((TPipeTransferReq)PipeTransferTsFileSealWithModReq.toTPipeTransferReq(modFile.getName(), modFile.length(), tsFile.getName(), tsFile.length()));
                pipeName2WeightMap.forEach((pipePair, weight) -> this.rateLimitIfNeeded((String)pipePair.getLeft(), (Long)pipePair.getRight(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), (long)((double)req.getBody().length * weight)));
                resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
            }
            catch (Exception e) {
                clientAndStatus.setRight((Object)false);
                this.clientManager.adjustTimeoutIfNecessary(e);
                throw new PipeConnectionException(String.format("Network error when seal file %s, because %s.", tsFile, e.getMessage()), (Throwable)e);
            }
        }
        this.transferFilePieces(pipeName2WeightMap, tsFile, clientAndStatus, false);
        try {
            req = this.compressIfNeeded((TPipeTransferReq)PipeTransferTsFileSealReq.toTPipeTransferReq(tsFile.getName(), tsFile.length()));
            pipeName2WeightMap.forEach((pipePair, weight) -> this.rateLimitIfNeeded((String)pipePair.getLeft(), (Long)pipePair.getRight(), ((IoTDBSyncClient)clientAndStatus.getLeft()).getEndPoint(), (long)((double)req.getBody().length * weight)));
            resp = ((IoTDBSyncClient)clientAndStatus.getLeft()).pipeTransfer(req);
        }
        catch (Exception e) {
            clientAndStatus.setRight((Object)false);
            this.clientManager.adjustTimeoutIfNecessary(e);
            throw new PipeConnectionException(String.format("Network error when seal file %s, because %s.", tsFile, e.getMessage()), (Throwable)e);
        }
        TSStatus status = resp.getStatus();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
            this.receiverStatusHandler.handle(resp.getStatus(), String.format("Seal file %s error, result status %s.", tsFile, resp.getStatus()), tsFile.getName());
        }
        LOGGER.info("Successfully transferred file {}.", (Object)tsFile);
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop, int regionId) {
        this.tabletBatchBuilder.discardEventsOfPipe(pipeNameToDrop, regionId);
    }

    public void close() {
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
        super.close();
    }
}

