/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.logtypes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.cluster.log.Log;

public class LargeTestLog
extends Log {
    private ByteBuffer data = ByteBuffer.wrap(new byte[8192]);

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeByte((byte)Log.Types.TEST_LARGE_CONTENT.ordinal());
            dataOutputStream.writeLong(this.getCurrLogIndex());
            dataOutputStream.writeLong(this.getCurrLogTerm());
            dataOutputStream.write(this.data.array());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.setCurrLogIndex(buffer.getLong());
        this.setCurrLogTerm(buffer.getLong());
        this.data.put(buffer);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LargeTestLog)) {
            return false;
        }
        LargeTestLog obj1 = (LargeTestLog)obj;
        return this.getCurrLogIndex() == obj1.getCurrLogIndex() && this.getCurrLogTerm() == obj1.getCurrLogTerm();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getCurrLogIndex(), this.getCurrLogTerm());
    }

    public String toString() {
        return "LargeTestLog{" + this.getCurrLogIndex() + "-" + this.getCurrLogTerm() + "}";
    }
}

