/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Reference;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Types;

public class NamedReference<T>
implements UnboundTerm<T>,
Reference<T> {
    private final String name;

    NamedReference(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BoundReference<T> bind(Types.StructType struct, boolean caseSensitive) {
        Schema schema = struct.asSchema();
        Types.NestedField field = caseSensitive ? schema.findField(this.name) : schema.caseInsensitiveFindField(this.name);
        ValidationException.check(field != null, "Cannot find field '%s' in struct: %s", this.name, schema.asStruct());
        return new BoundReference(field, schema.accessorForField(field.fieldId()), this.name);
    }

    @Override
    public NamedReference<T> ref() {
        return this;
    }

    public String toString() {
        return String.format("ref(name=\"%s\")", this.name);
    }
}

