/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import org.apache.ozhera.app.exception.AppException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

public class RocketMqConfig {
    private static final Logger log = LoggerFactory.getLogger(RocketMqConfig.class);
    @NacosValue(value="${rocket.mq.producer.group}", autoRefreshed=true)
    private String producerGroup;
    @NacosValue(value="${rocket.mq.srvAddr}", autoRefreshed=true)
    private String nameSrvAddr;

    @Bean
    public DefaultMQProducer getMqProducer() {
        DefaultMQProducer producer = new DefaultMQProducer(this.producerGroup, true);
        producer.setNamesrvAddr(this.nameSrvAddr);
        try {
            producer.start();
            return producer;
        }
        catch (MQClientException e) {
            log.error("ChannelBootstrap.initMqProducer error, RocketmqConfig: {},nameSrvAddr:{}", new Object[]{this.producerGroup, this.nameSrvAddr, e});
            throw new AppException("initMqProducer exception", (Throwable)e);
        }
    }
}

