/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.config.spring.context.annotation.DubboComponentScan;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@DubboComponentScan(basePackages={"org.apache.ozhera.app"})
@MapperScan(value={"org.apache.ozhera.app.dao"})
@EnableScheduling
public class AppBootstrap {
    private static final Logger log = LoggerFactory.getLogger(AppBootstrap.class);

    public static void main(String[] args) {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            SpringApplication.run(AppBootstrap.class, (String[])args);
            log.info("AppBootstrap MAX_MEMORY: {}MB", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
            log.info("AppBootstrap TOTAL_MEMORY: {}MB", (Object)(Runtime.getRuntime().totalMemory() / 1024L / 1024L));
            log.info("AppBootstrap Start used: {}s", (Object)stopwatch.elapsed(TimeUnit.SECONDS));
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            System.exit(-1);
        }
    }
}

