/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.project.group;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupAppRequest;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupDataRequest;
import org.apache.ozhera.app.api.model.project.group.HeraProjectGroupModel;
import org.apache.ozhera.app.api.model.project.group.ProjectGroupTreeNode;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.dao.HeraBaseInfoDao;
import org.apache.ozhera.app.dao.HeraProjectGroupAppDao;
import org.apache.ozhera.app.dao.HeraProjectGroupDao;
import org.apache.ozhera.app.dao.HeraProjectGroupUserDao;
import org.apache.ozhera.app.enums.CommonError;
import org.apache.ozhera.app.model.HeraAppBaseInfo;
import org.apache.ozhera.app.model.HeraProjectGroup;
import org.apache.ozhera.app.model.HeraProjectGroupApp;
import org.apache.ozhera.app.model.HeraProjectGroupUser;
import org.apache.ozhera.app.service.project.group.TreeQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HeraProjectGroupService {
    private static final Logger log = LoggerFactory.getLogger(HeraProjectGroupService.class);
    @Autowired
    HeraProjectGroupDao projectGroupDao;
    @Autowired
    HeraProjectGroupUserDao groupUserDao;
    @Autowired
    HeraProjectGroupAppDao projectGroupAppDao;
    @Autowired
    HeraBaseInfoDao heraBaseInfoDao;

    public Result create(HeraProjectGroupDataRequest request) {
        List<HeraProjectGroupModel> heraProjectGroupModels;
        Integer parentGroupId = request.getParentGroupId();
        if (parentGroupId != -1 && (heraProjectGroupModels = this.projectGroupDao.listByIds(Lists.newArrayList((Object[])new Integer[]{parentGroupId}), request.getType(), null, null)) != null && heraProjectGroupModels.size() < 1) {
            return Result.fail((Integer)-1, (String)("there is no data  which project group  id is " + parentGroupId));
        }
        HeraProjectGroupModel projectGroup = new HeraProjectGroupModel();
        projectGroup.setRelationObjectId(request.getRelationObjectId());
        projectGroup.setType(request.getType());
        List<HeraProjectGroupModel> search = this.projectGroupDao.search(projectGroup, null, null);
        if (!CollectionUtils.isEmpty(search)) {
            Result fail = Result.fail((Integer)-1, (String)("the data relationObjectId: " + request.getRelationObjectId() + " has exist!  projectGroupId:" + search.get(0).getId() + "parentGroupId:" + search.get(0).getParentGroupId()));
            fail.setData((Object)search.get(0).getId());
            return fail;
        }
        HeraProjectGroup group = new HeraProjectGroup();
        BeanUtils.copyProperties((Object)request, (Object)group);
        Integer groupId = this.projectGroupDao.create(group);
        if (!CollectionUtils.isEmpty((Collection)request.getUsers())) {
            ArrayList<HeraProjectGroupUser> toCreateUsers = new ArrayList<HeraProjectGroupUser>();
            request.getUsers().forEach(t -> {
                HeraProjectGroupUser user = new HeraProjectGroupUser();
                user.setProjectGroupId(groupId);
                user.setUser((String)t);
                user.setStatus(0);
                user.setCreateTime(new Date());
                user.setUpdateTime(new Date());
                toCreateUsers.add(user);
            });
            this.groupUserDao.batchInsert(toCreateUsers);
        }
        if (!CollectionUtils.isEmpty((Collection)request.getApps())) {
            ArrayList<HeraProjectGroupApp> toCreateApps = new ArrayList<HeraProjectGroupApp>();
            for (HeraProjectGroupAppRequest app : request.getApps()) {
                if (app.getAppId() == null || app.getPlatFormType() == null) {
                    log.error("create project group param app is error! request:{}", (Object)request.toString());
                    continue;
                }
                Integer baseInfoId = this.heraBaseInfoDao.idByBindIdsAndPlat(String.valueOf(app.getAppId()), app.getPlatFormType());
                HeraProjectGroupApp groupApp = new HeraProjectGroupApp();
                groupApp.setProjectGroupId(groupId);
                groupApp.setAppBaseInfoId(baseInfoId);
                groupApp.setStatus(0);
                groupApp.setCreateTime(new Date());
                groupApp.setUpdateTime(new Date());
                toCreateApps.add(groupApp);
            }
            this.projectGroupAppDao.batchInsert(toCreateApps);
        }
        return Result.success((Object)groupId);
    }

    public Result update(HeraProjectGroupDataRequest request) {
        Integer parentGroupId;
        List<HeraProjectGroupModel> heraProjectGroupModels;
        if (request.getParentGroupId() != null && (heraProjectGroupModels = this.projectGroupDao.listByIds(Lists.newArrayList((Object[])new Integer[]{parentGroupId = request.getParentGroupId()}), request.getType(), null, null)) != null && heraProjectGroupModels.size() < 1) {
            return Result.fail((Integer)-1, (String)("there is no project Group data which Id is " + parentGroupId));
        }
        if (request.getRelationObjectId() != null && request.getType() != null) {
            HeraProjectGroupModel projectGroup = new HeraProjectGroupModel();
            projectGroup.setRelationObjectId(request.getRelationObjectId());
            projectGroup.setType(request.getType());
            List<HeraProjectGroupModel> search = this.projectGroupDao.search(projectGroup, null, null);
            if (!CollectionUtils.isEmpty(search) && !search.get(0).getId().equals(request.getId())) {
                return Result.fail((Integer)-1, (String)("the data relationObjectId: " + request.getRelationObjectId() + " has exist!"));
            }
        }
        log.info("update project Group request:{}", (Object)new Gson().toJson((Object)request));
        HeraProjectGroup group = new HeraProjectGroup();
        BeanUtils.copyProperties((Object)request, (Object)group);
        log.info("update project Group group:{}", (Object)new Gson().toJson((Object)group));
        Integer groupId = this.projectGroupDao.update(group);
        this.updateUsers(request);
        this.updateApps(request);
        return Result.success((Object)groupId);
    }

    public Result delete(Integer id) {
        HeraProjectGroupModel model = new HeraProjectGroupModel();
        model.setParentGroupId(id);
        List<HeraProjectGroupModel> search = this.projectGroupDao.search(model, null, null);
        if (search != null && search.size() > 0) {
            return Result.fail((Integer)-1, (String)"The current node cannot be deleted because it has child nodes\uff01");
        }
        List<HeraProjectGroupApp> apps = this.projectGroupAppDao.listByProjectGroupId(id);
        if (!CollectionUtils.isEmpty(apps)) {
            return Result.fail((Integer)-1, (String)"The current node cannot be deleted because it has apps\uff01");
        }
        this.projectGroupAppDao.delByGroupId(id);
        this.groupUserDao.delByGroupId(id);
        this.projectGroupDao.delById(id);
        return Result.success((Object)id);
    }

    private void updateUsers(HeraProjectGroupDataRequest request) {
        if (request.getUsers() != null) {
            List updateUsers = request.getUsers();
            List<HeraProjectGroupUser> existUsers = this.groupUserDao.listByProjectGroupId(request.getId());
            if (CollectionUtils.isEmpty(existUsers)) {
                ArrayList<HeraProjectGroupUser> users = new ArrayList<HeraProjectGroupUser>();
                updateUsers.forEach(t -> {
                    HeraProjectGroupUser userI = new HeraProjectGroupUser();
                    userI.setProjectGroupId(request.getId());
                    userI.setUser((String)t);
                    userI.setStatus(0);
                    userI.setCreateTime(new Date());
                    userI.setUpdateTime(new Date());
                    users.add(userI);
                });
                Integer integer = this.groupUserDao.batchInsert(users);
                return;
            }
            List<HeraProjectGroupUser> delUsers = existUsers.stream().filter(t -> !updateUsers.contains(t.getUser())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(delUsers)) {
                delUsers.forEach(t -> this.groupUserDao.delById(t.getId()));
            }
            if (CollectionUtils.isEmpty((Collection)updateUsers)) {
                return;
            }
            updateUsers.removeAll(existUsers.stream().map(t -> t.getUser()).collect(Collectors.toList()));
            ArrayList<HeraProjectGroupUser> users = new ArrayList<HeraProjectGroupUser>();
            updateUsers.forEach(t -> {
                HeraProjectGroupUser userI = new HeraProjectGroupUser();
                userI.setProjectGroupId(request.getId());
                userI.setUser((String)t);
                userI.setStatus(0);
                userI.setCreateTime(new Date());
                userI.setUpdateTime(new Date());
                users.add(userI);
            });
            Integer n = this.groupUserDao.batchInsert(users);
        }
    }

    private void updateApps(HeraProjectGroupDataRequest request) {
        List<HeraProjectGroupApp> toDeleteApps;
        List updateApps = request.getApps();
        if (updateApps == null) {
            return;
        }
        List<HeraProjectGroupApp> existApps = this.projectGroupAppDao.listByProjectGroupId(request.getId());
        if (CollectionUtils.isEmpty(existApps)) {
            if (updateApps.size() == 0) {
                return;
            }
            ArrayList<HeraProjectGroupApp> apps = new ArrayList<HeraProjectGroupApp>();
            for (HeraProjectGroupAppRequest appRequest : updateApps) {
                if (appRequest.getAppId() == null || appRequest.getPlatFormType() == null) {
                    log.error("updateApps param app is invalid! request:{}", (Object)request.toString());
                    continue;
                }
                Integer baseInfoId = this.heraBaseInfoDao.idByBindIdsAndPlat(String.valueOf(appRequest.getAppId()), appRequest.getPlatFormType());
                if (baseInfoId == null) {
                    log.error("updateApps error! no baseInfo found for appId:{},platFormType:{}", (Object)appRequest.getAppId(), (Object)appRequest.getPlatFormType());
                    continue;
                }
                HeraProjectGroupApp app = new HeraProjectGroupApp();
                app.setProjectGroupId(request.getId());
                app.setAppBaseInfoId(baseInfoId);
                app.setStatus(0);
                app.setCreateTime(new Date());
                app.setUpdateTime(new Date());
                apps.add(app);
            }
            this.projectGroupAppDao.batchInsert(apps);
            return;
        }
        ArrayList<Integer> updateAppIds = new ArrayList<Integer>();
        if (!CollectionUtils.isEmpty((Collection)updateApps)) {
            for (HeraProjectGroupAppRequest appRequest : updateApps) {
                if (appRequest.getAppId() == null || appRequest.getPlatFormType() == null) {
                    log.error("updateApps param error! request : {}", (Object)request.toString());
                    continue;
                }
                Integer baseInfoId = this.heraBaseInfoDao.idByBindIdsAndPlat(String.valueOf(appRequest.getAppId()), appRequest.getPlatFormType());
                if (baseInfoId == null) continue;
                updateAppIds.add(baseInfoId);
            }
        }
        if (!CollectionUtils.isEmpty(toDeleteApps = existApps.stream().filter(t -> !updateAppIds.contains(t.getAppBaseInfoId())).collect(Collectors.toList()))) {
            toDeleteApps.forEach(t -> this.projectGroupAppDao.delById(t.getId()));
        }
        if (CollectionUtils.isEmpty(updateAppIds)) {
            return;
        }
        updateAppIds.removeAll(existApps.stream().map(t -> t.getAppBaseInfoId()).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(updateAppIds)) {
            ArrayList<HeraProjectGroupApp> apps = new ArrayList<HeraProjectGroupApp>();
            for (HeraProjectGroupAppRequest appRequest : updateApps) {
                if (appRequest.getAppId() == null || appRequest.getPlatFormType() == null) {
                    log.error("updateApps param app is invalid! request:{}", (Object)request.toString());
                    continue;
                }
                Integer baseInfoId = this.heraBaseInfoDao.idByBindIdsAndPlat(String.valueOf(appRequest.getAppId()), appRequest.getPlatFormType());
                if (baseInfoId == null) {
                    log.error("updateApps error! no baseInfo found for appId:{},platFormType:{}", (Object)appRequest.getAppId(), (Object)appRequest.getPlatFormType());
                    continue;
                }
                HeraProjectGroupApp app = new HeraProjectGroupApp();
                app.setProjectGroupId(request.getId());
                app.setAppBaseInfoId(baseInfoId);
                app.setStatus(0);
                app.setCreateTime(new Date());
                app.setUpdateTime(new Date());
                apps.add(app);
            }
            this.projectGroupAppDao.batchInsert(apps);
        }
    }

    public Result<ProjectGroupTreeNode> getFullTree(Integer type) {
        HeraProjectGroupModel rootGroupNode = this.getRootGroupNode(type);
        if (rootGroupNode == null) {
            log.error("getFullTree no root data found for type : {}", (Object)type);
            return Result.fail((CommonError)CommonError.NOT_EXISTS_DATA);
        }
        HeraProjectGroupModel model = new HeraProjectGroupModel();
        Long count = this.projectGroupDao.count(model);
        if (count == null || count.intValue() <= 0) {
            log.error("getFullTree error! count node data return : {}", (Object)count);
            return Result.fail((CommonError)CommonError.NOT_EXISTS_DATA);
        }
        ArrayList<HeraProjectGroupModel> allData = new ArrayList<HeraProjectGroupModel>();
        Integer page = count.intValue() % 300 == 0 ? count.intValue() / 300 : count.intValue() / 300 + 1;
        for (int i = 0; i < page; ++i) {
            allData.addAll(this.projectGroupDao.search(model, i + 1, 300));
        }
        TreeQueryBuilder treeBuilder = new TreeQueryBuilder(new HashSet<HeraProjectGroupModel>(allData));
        Result<ProjectGroupTreeNode> treeByProjectGroup = treeBuilder.getTreeByProjectGroup(rootGroupNode);
        return treeByProjectGroup;
    }

    public Result<ProjectGroupTreeNode> getTreeByUser(String user, Integer type, String projectGroupName, Integer level) {
        HeraProjectGroupModel rootGroupNode = this.getRootGroupNode(type);
        if (rootGroupNode == null) {
            log.error("getTreeByUser no root data found for type : {}", (Object)type);
            return Result.fail((CommonError)CommonError.NOT_EXISTS_DATA);
        }
        List<HeraProjectGroupModel> nodesByUser = this.getNodesByUser(user, type, projectGroupName, level);
        if (CollectionUtils.isEmpty(nodesByUser)) {
            return Result.success();
        }
        Set<HeraProjectGroupModel> treeNodes = this.pathToRootData(nodesByUser, type);
        TreeQueryBuilder treeBuilder = new TreeQueryBuilder(treeNodes);
        Result<ProjectGroupTreeNode> treeByProjectGroup = treeBuilder.getTreeByProjectGroup(rootGroupNode);
        return treeByProjectGroup;
    }

    public Result<List<HeraProjectGroupModel>> searchChildGroups(String user, Integer groupType, Integer projectGroupId, Integer page, Integer pageSize) {
        if (StringUtils.isBlank((CharSequence)user) || groupType == null || projectGroupId == null) {
            log.info("searchChildGroups param invalid! user : {}, groupType: {}, projectGroupId: {}", new Object[]{user, groupType, projectGroupId});
            return Result.fail((CommonError)CommonError.ParamsError);
        }
        List<Integer> userGroupIds = this.groupUserDao.listGroupIdsByUser(user);
        if (CollectionUtils.isEmpty(userGroupIds)) {
            log.info("searchChildGroups no group data found for user! user:{},projectGroupId:{},groupType:{}", new Object[]{user, projectGroupId, groupType});
            return Result.success();
        }
        if (!userGroupIds.contains(projectGroupId)) {
            log.info("searchChildGroups user:{} has no authorization for assign projectGroupId:{},groupType:{}", new Object[]{user, projectGroupId, groupType});
            return Result.fail((CommonError)CommonError.NO_AUTHORIZATION);
        }
        HeraProjectGroupModel projectGroup = new HeraProjectGroupModel();
        projectGroup.setParentGroupId(projectGroupId);
        projectGroup.setType(groupType);
        List<HeraProjectGroupModel> projectGroups = this.projectGroupDao.search(projectGroup, null, null);
        if (CollectionUtils.isEmpty(projectGroups)) {
            log.info("searchChildGroups no assign type group data found for user! user : {},projectGroupId : {},groupType : {} ", new Object[]{user, projectGroupId, groupType});
        }
        return Result.success(projectGroups);
    }

    public Result<List<HeraAppBaseInfoModel>> searchGroupApps(String user, Integer groupType, Integer projectGroupId, String appName, Integer page, Integer pageSize) {
        List<HeraAppBaseInfo> heraAppBaseInfos;
        List<Integer> groupIds = new ArrayList<Integer>();
        List<Integer> userGroupIds = this.groupUserDao.listGroupIdsByUser(user);
        if (CollectionUtils.isEmpty(userGroupIds)) {
            log.info("getGroupApps no group data found for user! user:{},projectGroupId:{},groupType:{},appName:{}", new Object[]{user, projectGroupId, groupType, appName});
            return Result.success();
        }
        if (projectGroupId != null) {
            if (!userGroupIds.contains(projectGroupId)) {
                log.info("getGroupApps user:{} has no authorization for assign projectGroupId:{},groupType:{}", new Object[]{user, projectGroupId, groupType});
                return Result.fail((CommonError)CommonError.NO_AUTHORIZATION);
            }
            groupIds.add(projectGroupId);
        } else {
            groupIds.addAll(userGroupIds);
        }
        List<HeraProjectGroupModel> projectGroupsByType = this.projectGroupDao.listByIds(groupIds, groupType, null, null);
        if (CollectionUtils.isEmpty(projectGroupsByType)) {
            log.info("getGroupApps no assign type group data found for user! user:{},projectGroupId:{},groupType:{},appName:{}", new Object[]{user, projectGroupId, groupType, appName});
            return Result.success();
        }
        groupIds = projectGroupsByType.stream().map(t -> t.getId()).collect(Collectors.toList());
        List<Integer> appBaseInfoIds = this.projectGroupAppDao.getAppBaseInfoIds(groupIds);
        if (CollectionUtils.isEmpty(appBaseInfoIds)) {
            log.info("getGroupApps no apps data found! user:{},appBaseInfoIds:{},groupType:{}", new Object[]{user, appBaseInfoIds, groupType});
            return Result.success();
        }
        HeraAppBaseInfoModel appBaseInfoModel = new HeraAppBaseInfoModel();
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            appBaseInfoModel.setAppName(appName);
        }
        if (CollectionUtils.isEmpty(heraAppBaseInfos = this.heraBaseInfoDao.searchAppsByIds(appBaseInfoIds, appBaseInfoModel, page, pageSize))) {
            return Result.success();
        }
        ArrayList list = new ArrayList();
        heraAppBaseInfos.forEach(t -> {
            HeraAppBaseInfoModel model = new HeraAppBaseInfoModel();
            BeanUtils.copyProperties((Object)t, (Object)model);
            list.add(model);
        });
        return Result.success(list);
    }

    private HeraProjectGroupModel getRootGroupNode(Integer type) {
        HeraProjectGroupModel model = new HeraProjectGroupModel();
        model.setParentGroupId(Integer.valueOf(-1));
        model.setType(type);
        List<HeraProjectGroupModel> rootNodes = this.projectGroupDao.search(model, null, null);
        if (CollectionUtils.isEmpty(rootNodes)) {
            log.error("getRootGroupNode error! no data parenId is -1 for type : {}", (Object)type);
            return null;
        }
        if (rootNodes.size() > 1) {
            log.error("getRootGroupNode error! more than 1 root data found! parenId is -1 and type : {}", (Object)type);
        }
        return rootNodes.get(0);
    }

    public List<HeraProjectGroupModel> getNodesByUser(String user, Integer type, String projectGroupName, Integer level) {
        if (StringUtils.isBlank((CharSequence)user)) {
            log.error("getNodesByUser user is invalid!user:{},projectGroupName:{}", (Object)user);
            return null;
        }
        List<Integer> integers = this.groupUserDao.listGroupIdsByUser(user);
        if (CollectionUtils.isEmpty(integers)) {
            return null;
        }
        return this.projectGroupDao.listByIds(integers, type, projectGroupName, level);
    }

    public Set<HeraProjectGroupModel> pathToRootData(List<HeraProjectGroupModel> searchData, Integer type) {
        HashSet<HeraProjectGroupModel> result = new HashSet<HeraProjectGroupModel>();
        if (CollectionUtils.isEmpty(searchData)) {
            return result;
        }
        result.addAll(searchData);
        List<Integer> parentIds = searchData.stream().filter(t -> t.getParentGroupId() != null && t.getParentGroupId() != -1).map(k -> k.getParentGroupId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(parentIds)) {
            return result;
        }
        List<HeraProjectGroupModel> parentNodes = this.projectGroupDao.listByIds(parentIds, type, null, null);
        if (CollectionUtils.isEmpty(parentNodes)) {
            return result;
        }
        result.addAll(this.pathToRootData(parentNodes, type));
        return result;
    }
}

