/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.user;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class UserConfigService {
    @NacosValue(value="${hera.admin.member.list}", autoRefreshed=true)
    private String adminMemberList;
    @NacosValue(autoRefreshed=true, value="${assign.login.user:}")
    private String assignLoginUser;
    private String superAdmin = "gaoxihui";

    public List<String> getAdminUserList() {
        if (StringUtils.isBlank((CharSequence)this.adminMemberList)) {
            return Lists.newArrayList();
        }
        String[] admins = this.adminMemberList.split(",");
        return Arrays.asList(admins);
    }

    public boolean isAdmin(String user) {
        return this.getAdminUserList().contains(user);
    }

    public String getAssignUser(String currentUser) {
        if (!this.isSuperAdmin(currentUser)) {
            return currentUser;
        }
        if (StringUtils.isBlank((CharSequence)this.assignLoginUser)) {
            return currentUser;
        }
        return this.assignLoginUser;
    }

    public boolean isSuperAdmin(String user) {
        if (StringUtils.isBlank((CharSequence)user)) {
            return false;
        }
        return user.equals(this.superAdmin);
    }
}

