/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.user;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.ozhera.monitor.service.user.UseDetailInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class LocalUser {
    private static final Logger log = LoggerFactory.getLogger(LocalUser.class);
    private static final ThreadLocal<UseDetailInfo> local = new ThreadLocal();

    public static void set(UseDetailInfo user) {
        local.set(user);
    }

    public static final UseDetailInfo get() {
        return local.get();
    }

    public static void clear() {
        local.remove();
    }

    public static final Map<Integer, UseDetailInfo.DeptDescr> getDepts() {
        HashMap map = Maps.newHashMap();
        UseDetailInfo user = LocalUser.get();
        log.info("debug_user_info={}", (Object)user);
        if (user == null || CollectionUtils.isEmpty(user.getFullDeptDescrList())) {
            return map;
        }
        for (UseDetailInfo.DeptDescr dept : user.getFullDeptDescrList()) {
            map.put(Integer.valueOf(dept.getLevel()), dept);
        }
        return map;
    }
}

