/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraAppBaseInfoModel;
import org.apache.ozhera.monitor.bo.AppLanguage;
import org.apache.ozhera.monitor.bo.AppType;
import org.apache.ozhera.monitor.bo.PlatFormType;
import org.apache.ozhera.monitor.dao.AppGrafanaMappingDao;
import org.apache.ozhera.monitor.dao.AppMonitorDao;
import org.apache.ozhera.monitor.dao.GrafanaTemplateDao;
import org.apache.ozhera.monitor.dao.model.AppGrafanaMapping;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.dao.model.GrafanaTemplate;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AppGrafanaMappingService;
import org.apache.ozhera.monitor.service.GrafanaService;
import org.apache.ozhera.monitor.service.HeraBaseInfoService;
import org.apache.ozhera.monitor.service.api.AppGrafanaMappingServiceExtension;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.apache.ozhera.monitor.service.model.GrafanaResponse;
import org.apache.ozhera.monitor.service.model.MutiGrafanaResponse;
import org.apache.ozhera.monitor.service.serverless.ServerLessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppGrafanaMappingServiceImpl
implements AppGrafanaMappingService {
    private static final Logger log = LoggerFactory.getLogger(AppGrafanaMappingServiceImpl.class);
    @Autowired
    AppGrafanaMappingDao appGrafanaMappingDao;
    @Autowired
    GrafanaService grafanaService;
    @Autowired
    AppMonitorDao appMonitorDao;
    @Autowired
    GrafanaTemplateDao grafanaTemplateDao;
    @Autowired
    HeraBaseInfoService heraBaseInfoService;
    @Autowired
    PlatFormTypeExtensionService platFormTypeExtensionService;
    @Autowired
    private ServerLessService serverLessService;
    @Autowired
    private AppGrafanaMappingServiceExtension appGrafanaMappingServiceExtension;
    @Value(value="${server.type}")
    private String serverType;
    @Value(value="${grafana.domain}")
    private String grafanaDomain;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    public static final String OLD_ST_GRAFANA_DOMAIN = "http://grafana.mione";
    public static final String OLD_ONLINE_GRAFANA_DOMAIN = "http://grafana.be";

    @Override
    public void exeReloadTemplateBase(Integer pSize) {
        log.info("exeReloadTemplateBase will be running!! pSize:" + pSize);
        Future<String> result = this.executor.submit(() -> {
            log.info("exeReloadTemplateBase start running!! pSize:" + pSize);
            try {
                HeraAppBaseInfoModel baseInfoCondition = new HeraAppBaseInfoModel();
                Long total = this.heraBaseInfoService.count(baseInfoCondition);
                log.info("AppGrafanaMappingService.exeReloadTemplateBase data totalNum ====== {}", (Object)total);
                if (total == null || total.intValue() == 0) {
                    log.info("AppGrafanaMappingService.exeReloadTemplateBase no data found!!!");
                    return "No data found!!";
                }
                int pageCount = total.intValue() / pSize + (total.intValue() % pSize > 0 ? 1 : 0);
                for (int i = 0; i < pageCount; ++i) {
                    int offset = i + 1;
                    List<HeraAppBaseInfoModel> list = this.heraBaseInfoService.query(baseInfoCondition, offset, pSize);
                    for (HeraAppBaseInfoModel heraAppBaseInfo : list) {
                        try {
                            this.createTmpByAppBaseInfo(heraAppBaseInfo);
                        }
                        catch (Exception e1) {
                            log.error("grafanaMappingService.exeReloadTemplateBase error appName:{} error : {}", new Object[]{heraAppBaseInfo.getAppName(), e1.getMessage(), e1});
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("AppGrafanaMappingService.exeReloadTemplateBase error : {}", (Object)e.getMessage(), (Object)e);
                return ErrorCode.unknownError.getMessage();
            }
            return ErrorCode.success.getMessage();
        });
    }

    @Override
    public void reloadTmpByAppId(Integer id) {
        HeraAppBaseInfoModel baseInfo = this.heraBaseInfoService.getById(id);
        if (baseInfo == null) {
            log.error("reloadTmpByAppId no data found id:{}", (Object)id);
            return;
        }
        this.createTmpByAppBaseInfo(baseInfo);
    }

    @Override
    public void createTmpByAppBaseInfo(HeraAppBaseInfoModel baseInfo) {
        GrafanaTemplate template = new GrafanaTemplate();
        Integer appType = baseInfo.getAppType();
        if (appType == null || AppType.mesh.getCode().equals(appType)) {
            appType = AppType.businessType.getCode();
        }
        template.setAppType(appType);
        template.setPlatform(baseInfo.getPlatformType());
        try {
            Integer langUageCode = AppLanguage.getCodeByMessage(baseInfo.getAppLanguage());
            if (langUageCode == null) {
                langUageCode = AppLanguage.java.getCode();
                log.error("the app base info no language set! set default language java. baseInfo:{}", (Object)new Gson().toJson((Object)baseInfo));
            }
            template.setLanguage(langUageCode);
            this.appGrafanaMappingServiceExtension.setPlatFormByLanguage(template, baseInfo.getAppLanguage());
            List<GrafanaTemplate> search = this.grafanaTemplateDao.search(template);
            if (CollectionUtils.isEmpty(search)) {
                log.error("createTmpByAppBaseInfo,no template config found! baseInfo:{}", (Object)new Gson().toJson((Object)baseInfo));
                return;
            }
            Optional<Integer> platformType = Optional.ofNullable(baseInfo.getPlatformType());
            String grafanaDirByCode = platformType.isPresent() ? this.platFormTypeExtensionService.getGrafanaDirByTypeCode(platformType.get()) : PlatFormType.open.getGrafanaDir();
            ArrayList<String> funcList = new ArrayList();
            if (AppType.serverless.getCode().equals(baseInfo.getAppType())) {
                funcList = this.serverLessService.getFaasFunctionList(Integer.valueOf(baseInfo.getBindId()));
            }
            MutiGrafanaResponse mutiGrafanaResponse = this.grafanaService.requestGrafanaTemplate(this.serverType, baseInfo.getBindId() + "_" + baseInfo.getAppName(), grafanaDirByCode, search.get(0), funcList);
            log.info("createTmpByAppBaseInfo response info : {}", (Object)mutiGrafanaResponse);
            this.appGrafanaMappingServiceExtension.dealRequestGrafanaTemplateCode(mutiGrafanaResponse.getCode(), baseInfo.getBindId(), baseInfo.getAppName());
            if (mutiGrafanaResponse.getCode() != 0 || mutiGrafanaResponse.getData() == null) {
                log.info("create grafana fail! baseInfo:{},response:{}", (Object)baseInfo.toString(), (Object)new Gson().toJson((Object)mutiGrafanaResponse));
                return;
            }
            log.info("grafanaMappingService.createTmpByAppBaseInfo success appName : {}, version:{},area : {}, returnUrl :{}", new Object[]{baseInfo.getAppName(), mutiGrafanaResponse.getData().get(0).getMimonitor_version(), grafanaDirByCode, mutiGrafanaResponse});
            String url = new StringBuffer().append(this.grafanaDomain).append(mutiGrafanaResponse.getUrl()).toString();
            AppGrafanaMapping grafanaMapping = new AppGrafanaMapping();
            grafanaMapping.setGrafanaUrl(url);
            grafanaMapping.setAppName(baseInfo.getBindId() + "_" + baseInfo.getAppName());
            grafanaMapping.setMioneEnv(grafanaDirByCode);
            int i = this.saveOrUpdate(grafanaMapping);
            if (i > 0) {
                log.info("createTmpByAppBaseInfo success!grafanaMapping:{}", (Object)grafanaMapping.toString());
            } else {
                log.info("createTmpByAppBaseInfo fail!grafanaMapping:{}", (Object)grafanaMapping.toString());
            }
        }
        catch (JsonSyntaxException e) {
            log.error("createTmpByAppBaseInfo error!{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    @Deprecated
    public String createGrafanaUrlByAppName(String appName, String area) {
        if (StringUtils.isEmpty((CharSequence)appName) || StringUtils.isEmpty((CharSequence)area)) {
            log.error("GrafanaMappingController.createGrafanaUrlByAppName error! param appName or area is empty!");
            return ErrorCode.invalidParamError.getMessage();
        }
        try {
            String grafanaReqResult = this.grafanaService.requestGrafana(this.serverType, appName, area);
            log.info("GrafanaMappingController.createGrafanaUrlByAppName requestGrafana serverType:{} ,appName : {},area : {}, result : {}", new Object[]{this.serverType, appName, area, grafanaReqResult});
            GrafanaResponse grafanaResponse = (GrafanaResponse)new Gson().fromJson(grafanaReqResult, GrafanaResponse.class);
            String url = new StringBuffer().append(this.grafanaDomain).append(grafanaResponse.getUrl()).toString();
            AppGrafanaMapping appGrafanaMapping = new AppGrafanaMapping();
            appGrafanaMapping.setMioneEnv(area);
            appGrafanaMapping.setAppName(appName);
            appGrafanaMapping.setGrafanaUrl(url);
            Integer ret = this.saveOrUpdate(appGrafanaMapping);
            if (ret > 0) {
                log.info("GrafanaMappingController.createGrafanaUrlByAppName save data success  name : {}, area : {}, url : {} ", new Object[]{appName, area, url});
                return ErrorCode.success.getMessage();
            }
            log.info("GrafanaMappingController.createGrafanaUrlByAppName save data failed  name : {}, area : {}, url : {} ", new Object[]{appName, area, url});
            return "data save failed!!";
        }
        catch (Exception e) {
            log.error("GrafanaMappingController.createGrafanaUrlByAppName error:{}", (Object)e.getMessage(), (Object)e);
            return ErrorCode.unknownError.getMessage();
        }
    }

    @Override
    public Result getGrafanaUrlByAppName(String appName) {
        if (StringUtils.isEmpty((CharSequence)appName)) {
            log.error("AppGrafanaMappingService#getGrafanaUrlByAppName param is empty");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        int i = appName.indexOf("_");
        String bindId = appName.substring(0, i);
        String appNameBase = appName.substring(i + 1);
        String appType = null;
        try {
            AppGrafanaMapping mapping = this.appGrafanaMappingDao.getByAppName(appName);
            if (mapping == null) {
                log.info("AppGrafanaMappingService#getGrafanaUrlByAppName can not find data for appName : {}", (Object)appName);
                return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), null);
            }
            log.info("AppGrafanaMappingService#getGrafanaUrlByAppName by appName : {} ,return : {}", (Object)appName, (Object)mapping.getGrafanaUrl());
            HeraAppBaseInfoModel heraAppBaseInfo = new HeraAppBaseInfoModel();
            heraAppBaseInfo.setBindId(bindId);
            heraAppBaseInfo.setAppName(appNameBase);
            List<HeraAppBaseInfoModel> query = this.heraBaseInfoService.query(heraAppBaseInfo, null, null);
            if (CollectionUtils.isEmpty(query) || query.get(0).getAppType() == null) {
                log.error("no appType found for appName:{},has set default type by businessType type", (Object)appName);
                appType = AppType.businessType.getMessage();
            } else {
                AppType anEnum = AppType.getEnum(query.get(0).getAppType());
                if (anEnum == null) {
                    log.error("error AppType appName:{},has set default type by businessType type", (Object)appName);
                    appType = AppType.businessType.getMessage();
                } else {
                    appType = anEnum.getMessage();
                }
                if (appType.equals(AppType.mesh.getMessage())) {
                    appType = AppType.businessType.getMessage();
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("appType", appType);
            map.put("url", this.transferGrafanaUrl(mapping.getGrafanaUrl()));
            return Result.success(map);
        }
        catch (Exception e) {
            log.error("AppGrafanaMappingService#getGrafanaUrlByAppName error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    @Deprecated
    public Result<String> getGrafanaUrlByAppId(Integer appId) {
        if (appId == null) {
            log.error("AppGrafanaMappingService#getGrafanaUrlByAppId param is empty");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        try {
            AppMonitor appMonitor = this.appMonitorDao.getByAppId(appId);
            if (appMonitor == null) {
                return Result.success(null);
            }
            String grafanaName = appMonitor.getProjectId() + "_" + appMonitor.getProjectName();
            AppGrafanaMapping mapping = this.appGrafanaMappingDao.getByAppName(grafanaName);
            if (mapping == null) {
                log.info("AppGrafanaMappingService#getGrafanaUrlByAppId can not find data for appName : {}", (Object)grafanaName);
                return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), null);
            }
            log.info("AppGrafanaMappingService#getGrafanaUrlByAppId by appName : {} ,return : {}", (Object)grafanaName, (Object)mapping.getGrafanaUrl());
            return new Result(ErrorCode.success.getCode(), ErrorCode.success.getMessage(), (Object)mapping.getGrafanaUrl());
        }
        catch (Exception e) {
            log.error("AppGrafanaMappingService#getGrafanaUrlByAppId error" + e.getMessage(), (Throwable)e);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Integer save(AppGrafanaMapping appGrafanaMapping) {
        try {
            return this.appGrafanaMappingDao.generateGrafanaMapping(appGrafanaMapping);
        }
        catch (Exception e) {
            log.error("AppGrafanaMappingService#save error" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public Integer saveOrUpdate(AppGrafanaMapping appGrafanaMapping) {
        try {
            AppGrafanaMapping byAppName = this.appGrafanaMappingDao.getByAppName(appGrafanaMapping.getAppName());
            if (byAppName == null) {
                return this.appGrafanaMappingDao.generateGrafanaMapping(appGrafanaMapping);
            }
            appGrafanaMapping.setId(byAppName.getId());
            appGrafanaMapping.setCreateTime(byAppName.getCreateTime());
            return this.appGrafanaMappingDao.updateByPrimaryKey(appGrafanaMapping);
        }
        catch (Exception e) {
            log.error("AppGrafanaMappingService#saveOrUpdate error" + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    private String transferGrafanaUrl(String grafanaUrl) {
        if (!this.serverType.equals("online")) {
            if (grafanaUrl.startsWith(OLD_ST_GRAFANA_DOMAIN)) {
                String[] grafanaUrlArr = grafanaUrl.split(OLD_ST_GRAFANA_DOMAIN);
                if (grafanaUrlArr.length < 2) {
                    return grafanaUrl;
                }
                return this.grafanaDomain + grafanaUrlArr[1];
            }
            return grafanaUrl;
        }
        if (grafanaUrl.startsWith(OLD_ONLINE_GRAFANA_DOMAIN)) {
            String[] grafanaUrlArr = grafanaUrl.split(OLD_ONLINE_GRAFANA_DOMAIN);
            if (grafanaUrlArr.length < 2) {
                return grafanaUrl;
            }
            return this.grafanaDomain + grafanaUrlArr[1];
        }
        return grafanaUrl;
    }
}

