/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.api.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmPresetMetrics;
import org.apache.ozhera.monitor.bo.BasicUrlType;
import org.apache.ozhera.monitor.bo.MetricLabelKind;
import org.apache.ozhera.monitor.bo.MetricsRule;
import org.apache.ozhera.monitor.pojo.AlarmPresetMetricsPOJO;
import org.apache.ozhera.monitor.pojo.BasicUrlTypePOJO;
import org.apache.ozhera.monitor.service.api.AlarmPresetMetricsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class AlarmPresetMetricsServiceImpl
implements AlarmPresetMetricsService {
    @Override
    public List<MetricsRule> getEnumList() {
        AlarmPresetMetrics[] values;
        Map<AlarmPresetMetrics, MetricLabelKind> map = MetricLabelKind.getMetricLabelKindMap();
        MetricLabelKind kind = null;
        ArrayList<MetricsRule> list = new ArrayList<MetricsRule>();
        for (AlarmPresetMetrics value : values = AlarmPresetMetrics.values()) {
            if (value.getMetricType() == null || value.getUnit() == null || value.getStrategyType() == null) continue;
            MetricsRule rule = new MetricsRule(value.getCode(), value.getMessage(), value.getUnit().getCode(), value.getStrategyType().getCode(), value.getMetricType().getName(), value.getHideValueConfig());
            rule.setEnLable(value.getMessageEn());
            kind = map.get((Object)value);
            if (kind != null) {
                rule.setKind(kind.getKind());
            }
            list.add(rule);
        }
        return list;
    }

    @Override
    public AlarmPresetMetricsPOJO getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        for (AlarmPresetMetrics metrics : AlarmPresetMetrics.values()) {
            if (!metrics.getCode().equals(code)) continue;
            return this.convert(metrics);
        }
        return null;
    }

    private AlarmPresetMetricsPOJO convert(AlarmPresetMetrics metrics) {
        if (metrics == null) {
            return null;
        }
        AlarmPresetMetricsPOJO pojo = new AlarmPresetMetricsPOJO();
        pojo.setCode(metrics.getCode());
        pojo.setMessage(metrics.getMessage());
        pojo.setErrorMetric(metrics.getErrorMetric());
        pojo.setTotalMetric(metrics.getTotalMetric());
        pojo.setSlowQueryMetric(metrics.getSlowQueryMetric());
        pojo.setTimeCostMetric(metrics.getTimeCostMetric());
        pojo.setUnit(metrics.getUnit());
        pojo.setGroupKey(metrics.getGroupKey());
        pojo.setStrategyType(metrics.getStrategyType());
        pojo.setMetricType(metrics.getMetricType());
        pojo.setHideValueConfig(metrics.getHideValueConfig());
        pojo.setBasicUrlType(this.convert(metrics.getBasicUrlType()));
        pojo.setViewPanel(metrics.getViewPanel());
        pojo.setEnv(metrics.getEnv());
        pojo.setDomain(metrics.getDomain());
        return pojo;
    }

    private BasicUrlTypePOJO convert(BasicUrlType basicUrlType) {
        if (basicUrlType == null) {
            return null;
        }
        BasicUrlTypePOJO pojo = new BasicUrlTypePOJO();
        pojo.setName(basicUrlType.getName());
        pojo.setReqJsonObject(basicUrlType.getReqJsonObject());
        return pojo;
    }

    @Override
    public Map<String, String> getEnumMap() {
        AlarmPresetMetrics[] values;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (AlarmPresetMetrics value : values = AlarmPresetMetrics.values()) {
            map.put(value.getCode(), value.getMessage());
        }
        return map;
    }
}

